/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.combat;

import com.google.common.collect.Multimap;
import insane96mcp.iguanatweaksreborn.module.items.misc.ItemDefinition;
import insane96mcp.iguanatweaksreborn.module.items.misc.ItemDefinitionsReloadListener;
import insane96mcp.iguanatweaksreborn.module.items.unbreakableitems.UnbreakableItems;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.util.ModNBTData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="iguanatweaksreborn:combat", description="Players will deal reduced knockback if attacking with a non-weapon or spamming. Knockback reductions are defined via Data Packs with Item Definitions (the item_stats integrated data pack already does this)")
public class Knockback
extends Feature {
    public ResourceLocation TIME_SINCE_LAST_SWING;
    public ResourceLocation SHOULD_APPLY_NO_KNOCKBACK;
    public ResourceLocation PROJECTILE_KNOCKBACK;
    @Config(min=0.0, max=1.0, description="Percentage knockback dealt if the player is using an item that doesn't have the attack damage attribute. Broken items from the Items module count as No Weapon")
    public static Double noWeaponPenalty = 0.35;
    @Config(min=0.0, max=1.0, description="Percentage knockback dealt if the player is attacking when the attack is not fully charged.")
    public static Double spamPenalty = 0.35;
    @Config(min=0.0, max=1.0, description="Percentage knockback dealt by projectiles.")
    public static Double projectileKnockback = 0.7;

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        this.TIME_SINCE_LAST_SWING = this.createDataKey("ticks_since_last_swing");
        this.SHOULD_APPLY_NO_KNOCKBACK = this.createDataKey("should_apply_no_knockback");
        this.PROJECTILE_KNOCKBACK = this.createDataKey("projectile_knockback");
    }

    @SubscribeEvent
    public void onPlayerAttackEvent(AttackEntityEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        Player player = event.getEntity();
        if (player.m_150110_().f_35937_) {
            return;
        }
        ModNBTData.put((Entity)player, (ResourceLocation)this.TIME_SINCE_LAST_SWING, (Object)player.f_20922_);
    }

    @SubscribeEvent
    public void onLivingHurtEvent(LivingHurtEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        Entity entity = event.getSource().m_7640_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ModNBTData.put((Entity)player, (ResourceLocation)this.SHOULD_APPLY_NO_KNOCKBACK, (Object)true);
        } else {
            Projectile projectile;
            entity = event.getSource().m_7640_();
            if (entity instanceof Projectile && (projectile = (Projectile)entity).m_19749_() != null && projectileKnockback < 1.0) {
                ModNBTData.put((Entity)projectile.m_19749_(), (ResourceLocation)this.PROJECTILE_KNOCKBACK, (Object)true);
            }
        }
    }

    @SubscribeEvent
    public void onKnockback(LivingKnockBackEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        this.reducedKnockback(event);
        this.itemKnockbackReduction(event);
    }

    public void reducedKnockback(LivingKnockBackEvent event) {
        if (event.getEntity().m_21213_() != event.getEntity().f_19797_) {
            return;
        }
        LivingEntity lastHurtByMob = event.getEntity().m_21188_();
        if (lastHurtByMob == null) {
            return;
        }
        if (lastHurtByMob instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)lastHurtByMob;
            if (!player.f_8941_.m_9294_()) {
                return;
            }
        }
        ItemStack itemStack = lastHurtByMob.m_21205_();
        float knockbackMultiplier = 1.0f;
        if (lastHurtByMob instanceof Player) {
            Player player = (Player)lastHurtByMob;
            if (((Boolean)ModNBTData.get((Entity)lastHurtByMob, (ResourceLocation)this.SHOULD_APPLY_NO_KNOCKBACK, Boolean.class)).booleanValue()) {
                int ticksSinceLastSwing;
                float cooldown;
                Multimap attributeModifiers = itemStack.m_41638_(EquipmentSlot.MAINHAND);
                if ((!attributeModifiers.containsKey((Object)Attributes.f_22281_) || Knockback.isEnabled(UnbreakableItems.class) && Feature.isEnabled(UnbreakableItems.class) && UnbreakableItems.isBroken(itemStack)) && noWeaponPenalty < 1.0) {
                    knockbackMultiplier = Math.min(knockbackMultiplier, noWeaponPenalty.floatValue());
                }
                if ((cooldown = Mth.m_14036_((float)(((float)(ticksSinceLastSwing = ((Integer)ModNBTData.get((Entity)player, (ResourceLocation)this.TIME_SINCE_LAST_SWING, Integer.class)).intValue()) + 0.5f) / player.m_36333_()), (float)0.0f, (float)1.0f)) <= 0.9f) {
                    knockbackMultiplier = Math.min(knockbackMultiplier, spamPenalty.floatValue());
                }
            }
        }
        if (((Boolean)ModNBTData.get((Entity)lastHurtByMob, (ResourceLocation)this.PROJECTILE_KNOCKBACK, Boolean.class)).booleanValue() && projectileKnockback < 1.0) {
            knockbackMultiplier = Math.min(knockbackMultiplier, projectileKnockback.floatValue());
            ModNBTData.remove((Entity)lastHurtByMob, (ResourceLocation)this.PROJECTILE_KNOCKBACK);
        }
        if (knockbackMultiplier < 1.0f) {
            if (lastHurtByMob.m_20142_() && lastHurtByMob instanceof Player) {
                event.setStrength(event.getStrength() - 0.5f);
            }
            event.setStrength(event.getStrength() * knockbackMultiplier);
        }
        ModNBTData.put((Entity)lastHurtByMob, (ResourceLocation)this.SHOULD_APPLY_NO_KNOCKBACK, (Object)false);
    }

    public void itemKnockbackReduction(LivingKnockBackEvent event) {
        if (event.getEntity().m_21188_() == null) {
            return;
        }
        event.setStrength(event.getStrength() * Knockback.getKnockbackMultiplier(event.getEntity().m_21188_().m_21205_()));
    }

    public static float getKnockbackMultiplier(ItemStack stack) {
        float multiplier = 1.0f;
        for (ItemDefinition itemDefinition : ItemDefinitionsReloadListener.DEFINITIONS) {
            if (itemDefinition.knockbackMultiplier() == null || !itemDefinition.item().matchesItem(stack)) continue;
            multiplier = itemDefinition.knockbackMultiplier().floatValue();
        }
        return multiplier;
    }
}

