/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.combat;

import com.google.common.collect.Multimap;
import insane96mcp.iguanatweaksreborn.InsaneSO;
import insane96mcp.iguanatweaksreborn.module.combat.PiercingDamage;
import insane96mcp.iguanatweaksreborn.module.combat.RegeneratingAbsorption;
import insane96mcp.iguanatweaksreborn.module.combat.criticalhits.CriticalRework;
import insane96mcp.iguanatweaksreborn.module.misc.Packs;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;

@LoadFeature(module="iguanatweaksreborn:combat")
public class MiscStats
extends Feature {
    @Config(description="Vanilla tooltips on gear don't sum up multiple modifiers (e.g. a sword would have \"4 Attack Damage\" and \"-2 Attack Damage\" instead of \"2 Attack Damage\". This might break other mods messing with these Tooltips (e.g. Quark's improved tooltips)")
    public static Boolean fixTooltips = true;
    @Config(description="If enabled, tools will not take 2 damage when used to hurt entities")
    public static Boolean oneDamageForToolAttacking = true;
    @Config(description="Rework Sweeping attack. Sweeping is no longer on swords, instead it's on hoes. Also, the sweeping attack deals full damage and the range is increased. Sweeping edge enchantment has been disabled via the enchantments feature disable_enchantments.json")
    public static Boolean sweepingOverhaul = true;
    @Config(description="Enables a data pack that reworks armor, weapons and tools.")
    public static Boolean combatReworkDataPack = true;
    List<EquipmentSlot> ORDERED_SLOTS = Arrays.asList(EquipmentSlot.MAINHAND, EquipmentSlot.OFFHAND, EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET);

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        InsaneSO.addServerPack("combat_rework", "Insane's Survival Overhaul Combat Rework", () -> this.isEnabled() && Packs.disableAllDataPacks == false && combatReworkDataPack != false);
    }

    public void readConfig(ModConfigEvent event) {
        super.readConfig(event);
        if (sweepingOverhaul.booleanValue()) {
            ToolActions.DEFAULT_SWORD_ACTIONS.remove(ToolActions.SWORD_SWEEP);
            ToolActions.DEFAULT_HOE_ACTIONS.add(ToolActions.SWORD_SWEEP);
        } else {
            ToolActions.DEFAULT_SWORD_ACTIONS.add(ToolActions.SWORD_SWEEP);
            ToolActions.DEFAULT_HOE_ACTIONS.remove(ToolActions.SWORD_SWEEP);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onItemTooltipEvent(ItemTooltipEvent event) {
        if (!this.isEnabled() || !fixTooltips.booleanValue() || event.getItemStack().m_41720_() instanceof PotionItem) {
            return;
        }
        ArrayList<Component> toRemove = new ArrayList<Component>();
        boolean hasModifiersTooltip = false;
        Component emptyLine = null;
        for (Component mutableComponent : event.getToolTip()) {
            Object object;
            if (emptyLine == null) {
                Component component2 = emptyLine = mutableComponent.m_7360_().isEmpty() && mutableComponent.m_214077_().equals(ComponentContents.f_237124_) ? mutableComponent : null;
            }
            if ((object = mutableComponent.m_214077_()) instanceof TranslatableContents) {
                TranslatableContents t = (TranslatableContents)object;
                if (t.m_237508_().startsWith("item.modifiers.")) {
                    hasModifiersTooltip = true;
                    toRemove.add(mutableComponent);
                    if (emptyLine != null) {
                        toRemove.add(emptyLine);
                    }
                    emptyLine = null;
                } else if (t.m_237508_().startsWith("attribute.modifier.")) {
                    toRemove.add(mutableComponent);
                }
            }
            if (!hasModifiersTooltip) continue;
            List siblings = mutableComponent.m_7360_();
            object = siblings.iterator();
            while (object.hasNext()) {
                TranslatableContents translatableContents;
                Component component3 = (Component)object.next();
                ComponentContents componentContents = component3.m_214077_();
                if (!(componentContents instanceof TranslatableContents) || !(translatableContents = (TranslatableContents)componentContents).m_237508_().startsWith("attribute.modifier.")) continue;
                toRemove.add(mutableComponent);
            }
        }
        toRemove.forEach(component -> event.getToolTip().remove(component));
        List<EquipmentSlot> orderedSlots = Arrays.asList(EquipmentSlot.MAINHAND, EquipmentSlot.OFFHAND, EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET);
        for (EquipmentSlot equipmentslot : orderedSlots) {
            Multimap multimap = event.getItemStack().m_41638_(equipmentslot);
            if (multimap.isEmpty()) continue;
            event.getToolTip().add(CommonComponents.f_237098_);
            event.getToolTip().add(Component.m_237115_((String)("item.modifiers." + equipmentslot.m_20751_())).m_130940_(ChatFormatting.GRAY));
            multimap.keySet().stream().sorted(Comparator.comparing(attr -> ForgeRegistries.ATTRIBUTES.getKey(attr).m_135815_())).forEach(attribute -> {
                if (!MiscStats.shouldAttributeBeShown(attribute)) {
                    return;
                }
                Map modifiersByOperation = multimap.get(attribute).stream().collect(Collectors.groupingBy(AttributeModifier::m_22217_, () -> new TreeMap(Comparator.comparingInt(Enum::ordinal)), Collectors.toList()));
                modifiersByOperation.forEach((operation, modifiers) -> {
                    double amount = modifiers.stream().mapToDouble(AttributeModifier::m_22218_).sum();
                    boolean isEqualTooltip = false;
                    if (event.getEntity() != null && operation == AttributeModifier.Operation.ADDITION && equipmentslot == EquipmentSlot.MAINHAND && (attribute.equals(PiercingDamage.PIERCING_DAMAGE.get()) || attribute.equals(Attributes.f_22283_) || attribute.equals(Attributes.f_22278_) || attribute.equals(ForgeMod.ENTITY_REACH.get()) || attribute.equals(ForgeMod.BLOCK_REACH.get()) || attribute.equals(CriticalRework.CHANCE_ATTRIBUTE.get()) || attribute.equals(CriticalRework.DAMAGE_ATTRIBUTE.get()) || attribute.equals(Attributes.f_22281_))) {
                        amount += event.getEntity().m_21172_(attribute);
                        isEqualTooltip = true;
                        if (attribute.equals(CriticalRework.DAMAGE_ATTRIBUTE.get())) {
                            amount += 1.0;
                        }
                    }
                    if (!isEqualTooltip && amount == 0.0) {
                        return;
                    }
                    String translationString = "attribute.modifier.plus.";
                    if (isEqualTooltip || operation == AttributeModifier.Operation.MULTIPLY_TOTAL) {
                        translationString = "attribute.modifier.equals.";
                    } else if (amount < 0.0) {
                        translationString = "attribute.modifier.take.";
                    }
                    MutableComponent attributeComponent = Component.m_237115_((String)attribute.m_22087_());
                    MutableComponent component = switch (operation) {
                        case AttributeModifier.Operation.ADDITION -> {
                            if (attribute.equals(Attributes.f_22278_) || attribute.equals(CriticalRework.CHANCE_ATTRIBUTE.get()) || attribute.equals(CriticalRework.DAMAGE_ATTRIBUTE.get())) {
                                yield Component.m_237110_((String)(translationString + operation.m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(amount * 100.0) + "%", attributeComponent});
                            }
                            yield Component.m_237110_((String)(translationString + operation.m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(Math.abs(amount)), attributeComponent});
                        }
                        case AttributeModifier.Operation.MULTIPLY_BASE -> Component.m_237110_((String)(translationString + operation.m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(Math.abs(amount) * 100.0), attributeComponent});
                        case AttributeModifier.Operation.MULTIPLY_TOTAL -> Component.m_237110_((String)(translationString + operation.m_22235_()), (Object[])new Object[]{"x" + ItemStack.f_41584_.format(amount > 0.0 ? Math.abs(amount) + 1.0 : 1.0 - Math.abs(amount)), attributeComponent});
                        default -> Component.m_237113_((String)"???");
                    };
                    if (isEqualTooltip) {
                        component = CommonComponents.m_264333_().m_7220_((Component)component.m_130940_(ChatFormatting.DARK_GREEN));
                    } else if (amount > 0.0) {
                        component.m_130940_(ChatFormatting.BLUE);
                    } else {
                        component.m_130940_(ChatFormatting.RED);
                    }
                    event.getToolTip().add(component);
                });
            });
        }
    }

    public static boolean shouldAttributeBeShown(Attribute attribute) {
        if (!(Feature.isEnabled(CriticalRework.class) || attribute != CriticalRework.CHANCE_ATTRIBUTE.get() && attribute != CriticalRework.DAMAGE_ATTRIBUTE.get())) {
            return false;
        }
        if (!Feature.isEnabled(PiercingDamage.class) && attribute == PiercingDamage.PIERCING_DAMAGE.get()) {
            return false;
        }
        return Feature.isEnabled(RegeneratingAbsorption.class) || attribute != RegeneratingAbsorption.ATTRIBUTE.get() && attribute != RegeneratingAbsorption.SPEED_ATTRIBUTE.get();
    }
}

