/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.combat;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import insane96mcp.iguanatweaksreborn.InsaneSO;
import insane96mcp.iguanatweaksreborn.data.criterion.ISOTriggers;
import insane96mcp.iguanatweaksreborn.network.message.UnfairOneShotActivation;
import insane96mcp.iguanatweaksreborn.setup.ISORegistries;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.config.Config;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

@LoadFeature(module="iguanatweaksreborn:combat", name="Unfair one-shot", description="Players live with a heart when too much damage that would kill them is dealt (only works for damage taken from mobs)")
public class UnfairOneShot
extends Feature {
    public static final RegistryObject<SoundEvent> UNFAIR_ONE_SHOT = ISORegistries.SOUND_EVENTS.register("unfair_one_shot", () -> SoundEvent.m_262856_((ResourceLocation)InsaneSO.location("unfair_one_shot"), (float)16.0f));
    public static final RegistryObject<Item> HALF_HEART_TEXTURE = ISORegistries.ITEMS.register("half_heart_texture", () -> new Item(new Item.Properties()));
    @Config(description="A list of effects to give when Unfair One Shot triggers, separated by semi-colons")
    public static String effectsConfig = "minecraft:resistance,50,4;minecraft:resistance,100,3;minecraft:resistance,150,1";
    private static final List<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
    @Config(description="If true, an animation is played on activation")
    public static Boolean animation = true;
    @Config(min=1.0, max=20.0, description="How much health you need to have for this to activate")
    public static Double activationHealth = 15.0;
    @Config(min=1.0, max=20.0, description="How much heal you're left with when this activates. Must be at least 1 lower than 'Activation health'")
    public static Double leftoverHealth = 2.0;
    public static int activationTicks = 0;
    public static float activationOffX = 0.0f;
    public static float activationOffY = 0.0f;

    public void readConfig(ModConfigEvent event) {
        String[] effectsArray;
        super.readConfig(event);
        effects.clear();
        for (String effect : effectsArray = effectsConfig.split(";")) {
            String[] effectArray;
            MobEffect mobEffect;
            if (effect.isEmpty() || (mobEffect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(ResourceLocation.parse((String)(effectArray = effect.split(","))[0]))) == null) continue;
            int duration = Integer.parseInt(effectArray[1]);
            int amplifier = Integer.parseInt(effectArray[2]);
            effects.add(new MobEffectInstance(mobEffect, duration, amplifier));
        }
        if (leftoverHealth >= activationHealth) {
            leftoverHealth = activationHealth - 1.0;
        }
    }

    @SubscribeEvent
    public void onPlayerAttackEvent(LivingDamageEvent event) {
        Object object;
        if (!(this.isEnabled() && event.getSource().m_7639_() instanceof LivingEntity && (object = event.getEntity()) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)object;
        if ((double)player.m_21223_() >= activationHealth && player.m_21223_() - event.getAmount() <= 0.0f) {
            event.setAmount(player.m_21223_() - leftoverHealth.floatValue());
            player.m_9236_().m_5594_(null, player.m_20183_(), (SoundEvent)UNFAIR_ONE_SHOT.get(), SoundSource.PLAYERS, 2.0f, 0.5f);
            ISOTriggers.UNFAIR_ONESHOT.trigger(player);
            for (MobEffectInstance effect : effects) {
                player.m_7292_(new MobEffectInstance(effect));
            }
            if (animation.booleanValue()) {
                UnfairOneShotActivation.send(player);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void registerGuiOverlays(RegisterGuiOverlaysEvent event) {
        event.registerBelowAll("unfair_oneshot_animation", (gui, guiGraphics, partialTicks, screenWidth, screenHeight) -> {
            if (!Feature.isEnabled(UnfairOneShot.class) || activationTicks == 0) {
                return;
            }
            int tick = 30 - activationTicks;
            float f = ((float)tick + partialTicks) / 30.0f;
            float f1 = f * f;
            float f2 = f * f1;
            float f3 = 10.25f * f2 * f1 - 24.95f * f1 * f1 + 25.5f * f2 - 13.8f * f1 + 4.0f * f;
            float f4 = f3 * (float)Math.PI;
            float f5 = 0.0f;
            RenderSystem.enableDepthTest();
            RenderSystem.disableCull();
            PoseStack posestack = new PoseStack();
            posestack.m_85836_();
            posestack.m_252880_((float)(screenWidth / 2) + f5 * Mth.m_14154_((float)Mth.m_14031_((float)(f4 * 2.0f))), (float)screenHeight * f, -50.0f);
            float f7 = 120.0f * Mth.m_14031_((float)f4);
            posestack.m_85841_(f7, -f7, f7);
            posestack.m_252781_(Axis.f_252436_.m_252977_(180.0f * Mth.m_14154_((float)Mth.m_14031_((float)f4))));
            MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.m_91087_().m_91269_().m_110104_();
            Minecraft.m_91087_().m_91291_().m_269128_(new ItemStack((ItemLike)HALF_HEART_TEXTURE.get()), ItemDisplayContext.FIXED, 0xF000F0, OverlayTexture.f_118083_, posestack, (MultiBufferSource)multibuffersource$buffersource, (Level)Minecraft.m_91087_().f_91073_, 0);
            posestack.m_85849_();
            multibuffersource$buffersource.m_109911_();
            RenderSystem.enableCull();
            RenderSystem.disableDepthTest();
        });
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.LevelTickEvent event) {
        if (activationTicks > 0 && event.phase == TickEvent.Phase.END && event.level.f_46443_ && event.level.m_46472_() == Level.f_46428_) {
            --activationTicks;
        }
    }
}

