/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.combat.fletching.data;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import insane96mcp.iguanatweaksreborn.module.combat.fletching.crafting.FletchingRecipe;
import insane96mcp.iguanatweaksreborn.setup.client.ISOBookCategory;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class FletchingRecipeSerializer
implements RecipeSerializer<FletchingRecipe> {
    private final CookieBaker<FletchingRecipe> factory = FletchingRecipe::new;

    public FletchingRecipe fromJson(ResourceLocation pRecipeId, JsonObject pJson) {
        ISOBookCategory category = (ISOBookCategory)ISOBookCategory.CODEC.m_262792_(GsonHelper.m_13851_((JsonObject)pJson, (String)"category", null), (Enum)ISOBookCategory.FLETCHING_MISC);
        String group = GsonHelper.m_13906_((JsonObject)pJson, (String)"group");
        ItemStack ingredient = FletchingRecipeSerializer.getItemStack(pJson, "ingredient", true);
        ItemStack catalyst1 = FletchingRecipeSerializer.getItemStack(pJson, "catalyst1", true);
        ItemStack catalyst2 = FletchingRecipeSerializer.getItemStack(pJson, "catalyst2", false);
        ItemStack result = FletchingRecipeSerializer.getItemStack(pJson, "result", true);
        return this.factory.create(pRecipeId, category, group, ingredient, catalyst1, catalyst2, result);
    }

    @Nullable
    public static ItemStack getItemStack(JsonObject json, String key, boolean required) {
        if (!json.has(key)) {
            if (required) {
                throw new JsonSyntaxException("Missing %s, expected to find a string or object".formatted(key));
            }
            return null;
        }
        if (json.get(key).isJsonObject()) {
            return CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)key), (boolean)true, (boolean)true);
        }
        String s1 = GsonHelper.m_13906_((JsonObject)json, (String)key);
        ResourceLocation resourcelocation = ResourceLocation.parse((String)s1);
        return new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(resourcelocation));
    }

    public FletchingRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
        ISOBookCategory category = (ISOBookCategory)pBuffer.m_130066_(ISOBookCategory.class);
        String group = pBuffer.m_130277_();
        ItemStack ingredient = pBuffer.m_130267_();
        ItemStack catalyst1 = pBuffer.m_130267_();
        boolean hasCatalyst2 = pBuffer.readBoolean();
        ItemStack catalyst2 = null;
        if (hasCatalyst2) {
            catalyst2 = pBuffer.m_130267_();
        }
        ItemStack result = pBuffer.m_130267_();
        return this.factory.create(pRecipeId, category, group, ingredient, catalyst1, catalyst2, result);
    }

    public void toNetwork(FriendlyByteBuf pBuffer, FletchingRecipe pRecipe) {
        pBuffer.m_130068_((Enum)pRecipe.category());
        pBuffer.m_130070_(pRecipe.m_6076_());
        pBuffer.m_130055_(pRecipe.getBaseIngredient());
        pBuffer.m_130055_(pRecipe.getCatalyst1());
        if (pRecipe.getCatalyst2() != null) {
            pBuffer.writeBoolean(true);
            pBuffer.m_130055_(pRecipe.getCatalyst2());
        } else {
            pBuffer.writeBoolean(false);
        }
        pBuffer.m_130055_(pRecipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_));
    }

    public static interface CookieBaker<T extends FletchingRecipe> {
        public T create(ResourceLocation var1, ISOBookCategory var2, String var3, ItemStack var4, ItemStack var5, @Nullable ItemStack var6, ItemStack var7);
    }
}

