/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.experience;

import insane96mcp.iguanatweaksreborn.InsaneSO;
import insane96mcp.iguanatweaksreborn.data.generator.ISOBlockTagsProvider;
import insane96mcp.iguanatweaksreborn.module.mining.blockdefinition.BlockDefinition;
import insane96mcp.iguanatweaksreborn.module.mining.blockdefinition.BlockDefinitionReloadListener;
import insane96mcp.iguanatweaksreborn.network.message.SyncExperienceFeature;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.MinMax;
import insane96mcp.insanelib.module.base.TagsFeature;
import insane96mcp.insanelib.util.ModNBTData;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.projectile.ThrownExperienceBottle;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="iguanatweaksreborn:experience", description="Various changes to experience. You can also use the iguanatweaks:disableExperience game rule to make experience disappear altogether.")
public class DroppedExperience
extends Feature {
    public static final GameRules.Key<GameRules.BooleanValue> RULE_DISABLEEXPERIENCE = GameRules.m_46189_((String)"iguanatweaks:disableExperience", (GameRules.Category)GameRules.Category.PLAYER, (GameRules.Type)GameRules.BooleanValue.m_46252_((boolean)false, (server, booleanValue) -> {
        disableExperience = booleanValue.m_46223_();
        for (ServerPlayer serverPlayer : server.m_6846_().m_11314_()) {
            SyncExperienceFeature.sync(booleanValue.m_46223_(), serverPlayer);
        }
    }));
    public static ResourceLocation XP_PROCESSED;
    public static final TagKey<Block> NO_BLOCK_XP_MULTIPLIER;
    public static final TagKey<EntityType<?>> NO_ENTITY_XP_MULTIPLIER;
    @Config(min=0.0, max=128.0, description="ALL Experience dropped will be multiplied by this value, regardless if affected by another multiplier.\nUse the iguanatweaks:disableExperience game rule to disable experience completely.")
    public static Double globalMultiplier;
    @Config(min=0.0, max=128.0, description="Experience dropped by blocks (Ores and Spawners) will be multiplied by this multiplier. Experience dropped by blocks are still affected by 'Global Experience Multiplier'\nCan be set to 0 to make blocks drop no experience")
    public static Double blockMultiplier;
    @Config(min=0.0, max=128.0, name="Mobs.Multiplier: Spawners", description="Experience dropped from mobs that come from spawners will be multiplied by this multiplier.\nExperience dropped by mobs from spawners are still affected by 'Global Experience Multiplier'\nCan be set to 0 to disable experience drop from mob that come from spawners.")
    public static Double mobs$multiplierSpawner;
    @Config(min=0.0, max=128.0, name="Mobs.Multiplier: Natural", description="Experience dropped from mobs that DON'T come from spawners will be multiplied by this multiplier.\nExperience dropped from mobs that DON'T come from spawners is still affected by 'Global Experience Multiplier'\nCan be set to 0 to disable experience drop from mob that DON'T come from spawners.")
    public static Double mobs$multiplierNatural;
    @Config(min=0.0, description="Vanilla mobs drop 1~4 xp per equipment they have.")
    public static Integer mobs$bonusExperiencePerEquipment;
    @Config(min=0.0, description="This is added to 'Bonus experience per equipment'.")
    public static Integer mobs$bonusExperiencePerEnchantedEquipment;
    @Config(min=0.0, max=512.0, name="Bottle o' Enchanting XP", description="Bottle o' enchanting will drop this amount of experience. Can be set to 0 to make Bottle o' enchanting drop no experience")
    public static Integer xpBottleDroppedXp;
    @Config(min=0.0, description="Experience gained from harvesting Honey or Honeycombs from beehives")
    public static MinMax honeyHarvestExperience;
    @Config(min=0.0, description="Experience obtained when cows or mooshrooms are milked or stewed. This only works if Fluid Cooldown is enabled.")
    public static MinMax milkXp;
    @Config(min=0.0, description="Experience obtained when shearing sheep.")
    public static MinMax shearXp;
    @Config(min=0.0, description="Experience obtained when brushing blocks.")
    public static MinMax brushingXp;
    public static Boolean disableExperience;

    public DroppedExperience(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
        XP_PROCESSED = this.createDataKey("xp_processed");
    }

    public static void tryGenerateMilkXp(Entity entity) {
        if (DroppedExperience.milkXp.min > 0.0 || DroppedExperience.milkXp.max > 0.0) {
            entity.m_9236_().m_7967_((Entity)new ExperienceOrb(entity.m_9236_(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), milkXp.getIntRandBetween(entity.m_9236_().f_46441_)));
        }
    }

    public static void tryGenerateBrushXp(Entity entity) {
        if (DroppedExperience.brushingXp.min > 0.0 || DroppedExperience.brushingXp.max > 0.0) {
            entity.m_9236_().m_7967_((Entity)new ExperienceOrb(entity.m_9236_(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), brushingXp.getIntRandBetween(entity.m_9236_().f_46441_)));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        ExperienceOrb xpOrb;
        Entity entity = event.getEntity();
        if (entity instanceof ExperienceOrb && (xpOrb = (ExperienceOrb)entity).m_9236_().m_46469_().m_46207_(RULE_DISABLEEXPERIENCE)) {
            event.setCanceled(true);
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        entity = event.getEntity();
        if (entity instanceof ExperienceOrb) {
            xpOrb = (ExperienceOrb)entity;
            DroppedExperience.handleGlobalExperience(xpOrb);
        }
        DroppedExperience.handleMobsMultiplier(event);
    }

    private static void handleGlobalExperience(ExperienceOrb xpOrb) {
        if (globalMultiplier == 1.0 || ((Boolean)ModNBTData.get((Entity)xpOrb, (ResourceLocation)XP_PROCESSED, Boolean.class)).booleanValue() || xpOrb.m_9236_().f_46443_) {
            return;
        }
        if (globalMultiplier == 0.0) {
            xpOrb.m_142687_(Entity.RemovalReason.KILLED);
        } else {
            xpOrb.f_20770_ = (int)((double)xpOrb.f_20770_ * globalMultiplier);
        }
        ModNBTData.put((Entity)xpOrb, (ResourceLocation)XP_PROCESSED, (Object)true);
        if ((double)xpOrb.f_20770_ <= 0.0) {
            xpOrb.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public static void handleMobsMultiplier(EntityJoinLevelEvent event) {
        Mob mob;
        Entity entity;
        if (mobs$multiplierSpawner == 1.0 && mobs$multiplierNatural == 1.0 || !((entity = event.getEntity()) instanceof Mob) || (mob = (Mob)entity).m_6095_().m_204039_(NO_ENTITY_XP_MULTIPLIER)) {
            return;
        }
        if (TagsFeature.isSpawnType((MobSpawnType)MobSpawnType.SPAWNER, (LivingEntity)mob)) {
            TagsFeature.setExperienceMultiplier((double)mobs$multiplierSpawner, (LivingEntity)mob);
        } else {
            TagsFeature.setExperienceMultiplier((double)mobs$multiplierNatural, (LivingEntity)mob);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onBlockXPDrop(BlockEvent.BreakEvent event) {
        if (!this.isEnabled() || event.getState().m_204336_(NO_BLOCK_XP_MULTIPLIER)) {
            return;
        }
        DroppedExperience.handleBlockDrop(event);
        DroppedExperience.handleMultiplier(event);
    }

    private static void handleBlockDrop(BlockEvent.BreakEvent event) {
        int silkTouchLevel = event.getPlayer().m_21205_().getEnchantmentLevel(Enchantments.f_44985_);
        if (silkTouchLevel > 0) {
            return;
        }
        for (BlockDefinition blockDefinition : BlockDefinitionReloadListener.DEFINITIONS) {
            int expDropped;
            if (!blockDefinition.matches(event.getState()) || (expDropped = blockDefinition.getStateExperienceDropped(event.getLevel().m_213780_())) <= -1) continue;
            event.setExpToDrop(expDropped);
        }
    }

    private static void handleMultiplier(BlockEvent.BreakEvent event) {
        if (blockMultiplier == 1.0) {
            return;
        }
        int xpToDrop = event.getExpToDrop();
        xpToDrop = (int)((double)xpToDrop * blockMultiplier);
        event.setExpToDrop(xpToDrop);
    }

    @SubscribeEvent
    public void fixEquipmentExperience(LivingDeathEvent event) {
        Mob mob;
        block5: {
            block4: {
                LivingEntity livingEntity = event.getEntity();
                if (!(livingEntity instanceof Mob)) break block4;
                mob = (Mob)livingEntity;
                if (mob.f_21364_ > 0) break block5;
            }
            return;
        }
        for (ItemStack stack : mob.m_6168_()) {
            if (stack.m_41619_()) continue;
            mob.f_21364_ += mobs$bonusExperiencePerEquipment.intValue();
            if (!stack.m_41793_()) continue;
            mob.f_21364_ += mobs$bonusExperiencePerEnchantedEquipment.intValue();
        }
        for (ItemStack stack : mob.m_6167_()) {
            if (stack.m_41619_()) continue;
            mob.f_21364_ += mobs$bonusExperiencePerEquipment.intValue();
            if (!stack.m_41793_()) continue;
            mob.f_21364_ += mobs$bonusExperiencePerEnchantedEquipment.intValue();
        }
    }

    public static int getXpBottleDroppedExperience(ThrownExperienceBottle thrownExperienceBottle) {
        return xpBottleDroppedXp;
    }

    @SubscribeEvent
    public void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        if (!disableExperience.booleanValue() || !event.getItemStack().m_150930_(Items.f_42612_)) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        SyncExperienceFeature.sync(event.getEntity().m_9236_().m_46469_().m_46207_(RULE_DISABLEEXPERIENCE), (ServerPlayer)event.getEntity());
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGH)
    public void removeExperienceBar(RenderGuiOverlayEvent.Pre event) {
        if (!disableExperience.booleanValue() || Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        if (Minecraft.m_91087_().f_91074_.m_245714_() == null && event.getOverlay().equals((Object)VanillaGuiOverlay.VIGNETTE.type())) {
            ((ForgeGui)Minecraft.m_91087_().f_91065_).rightHeight -= 6;
            ((ForgeGui)Minecraft.m_91087_().f_91065_).leftHeight -= 6;
        } else if (event.getOverlay().equals((Object)VanillaGuiOverlay.EXPERIENCE_BAR.type())) {
            event.setCanceled(true);
        }
    }

    static {
        NO_BLOCK_XP_MULTIPLIER = ISOBlockTagsProvider.create("no_xp_multiplier");
        NO_ENTITY_XP_MULTIPLIER = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)InsaneSO.location("no_xp_multiplier"));
        globalMultiplier = 1.0;
        blockMultiplier = 1.0;
        mobs$multiplierSpawner = 1.0;
        mobs$multiplierNatural = 1.0;
        mobs$bonusExperiencePerEquipment = 2;
        mobs$bonusExperiencePerEnchantedEquipment = 3;
        xpBottleDroppedXp = 40;
        honeyHarvestExperience = new MinMax(3.0, 5.0);
        milkXp = new MinMax(3.0, 5.0);
        shearXp = new MinMax(2.0, 3.0);
        brushingXp = new MinMax(6.0, 10.0);
        disableExperience = false;
    }
}

