/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.experience;

import com.ezylang.evalex.Expression;
import com.ezylang.evalex.data.EvaluationValue;
import insane96mcp.iguanatweaksreborn.module.experience.DroppedExperience;
import insane96mcp.iguanatweaksreborn.utils.ISOLogHelper;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="iguanatweaksreborn:experience", description="Changes the experience lost on death and xp per level required.")
public class PlayerExperience
extends Feature {
    @Config(description="The experience required to level up is calculated by this formula. The variable available is 'current_level'\nSet to empty to disable.\nThis is evaluated with EvalEx https://ezylang.github.io/EvalEx/concepts/parsing_evaluation.html.\nIncompatible with Allurement's 'Remove level Scaling' or any other mod that does something similar")
    public static String levelUpFormula = "40";
    @Config(min=-1.0, max=1.0, description="On death, players will drop this percentage of experience instead of max 7 levels. Setting to -1 will disable this.\nDue to Minecraft limitations this is incompatible with other mods that change the level scaling (e.g. Allurement's 'Remove level Scaling').")
    public static Double droppedExperienceOnDeath = 0.8;
    @Config(min=-1.0, max=1.0, description="Players will pick up experience faster")
    public static Boolean pickUpFaster = true;

    public PlayerExperience(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!this.isEnabled() || event.phase != TickEvent.Phase.START || !pickUpFaster.booleanValue()) {
            return;
        }
        if (event.player.f_36101_ > 0) {
            --event.player.f_36101_;
        }
    }

    public static int getBetterScalingLevel(int currentLevel) {
        if (!PlayerExperience.isEnabled(PlayerExperience.class) || levelUpFormula.isEmpty()) {
            return -1;
        }
        Expression expression = new Expression(levelUpFormula);
        try {
            EvaluationValue result = expression.with("current_level", (Object)currentLevel).evaluate();
            return result.getNumberValue().intValue();
        }
        catch (Exception ex) {
            ISOLogHelper.error("Failed to evaluate or parse eating speed formula: %s", expression);
            return PlayerExperience.vanillaXpNeededForNextLevel(currentLevel);
        }
    }

    private static int getTotalExperience(Player player, boolean ignoreGlobalXPMultiplier) {
        int totalExp = 0;
        for (int i = 0; i < player.f_36078_; ++i) {
            totalExp += PlayerExperience.getXpNeededForNextLevel(i);
        }
        totalExp += (int)((float)player.m_36323_() * player.f_36080_);
        if (!ignoreGlobalXPMultiplier && Feature.isEnabled(DroppedExperience.class) && DroppedExperience.globalMultiplier != 1.0) {
            totalExp *= (int)(1.0 / DroppedExperience.globalMultiplier);
        }
        if (totalExp > 250000) {
            totalExp = 250000;
        }
        return totalExp;
    }

    private static int getXpNeededForNextLevel(int currentLevel) {
        int betterScalingXp = PlayerExperience.getBetterScalingLevel(currentLevel);
        if (betterScalingXp != -1) {
            return betterScalingXp;
        }
        return PlayerExperience.vanillaXpNeededForNextLevel(currentLevel);
    }

    private static int vanillaXpNeededForNextLevel(int currentLevel) {
        if (currentLevel >= 30) {
            return 112 + (currentLevel - 30) * 9;
        }
        return currentLevel >= 15 ? 37 + (currentLevel - 15) * 5 : 7 + currentLevel * 2;
    }

    public static int getExperienceOnDeath(Player player, boolean ignoreGlobalXPMultiplier) {
        if (!PlayerExperience.isEnabled(PlayerExperience.class) || droppedExperienceOnDeath < 0.0 && !DroppedExperience.isEnabled(DroppedExperience.class) || player.m_9236_().m_46469_().m_46207_(GameRules.f_46133_) || player.m_5833_()) {
            return -1;
        }
        return (int)((double)PlayerExperience.getTotalExperience(player, ignoreGlobalXPMultiplier) * droppedExperienceOnDeath);
    }
}

