/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.experience.anvils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import insane96mcp.iguanatweaksreborn.module.experience.anvils.AnvilRepair;
import insane96mcp.iguanatweaksreborn.network.message.AnvilRepairSync;
import insane96mcp.iguanatweaksreborn.utils.ISOLogHelper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="iguanatweaksreborn")
public class AnvilRepairReloadListener
extends SimpleJsonResourceReloadListener {
    public static HashMap<ResourceLocation, AnvilRepair> REPAIRS = new HashMap();
    public static final AnvilRepairReloadListener INSTANCE;
    private static final Gson GSON;

    public AnvilRepairReloadListener() {
        super(GSON, "anvil_repairs");
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        REPAIRS.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
            try {
                AnvilRepair anvilRepair = (AnvilRepair)GSON.fromJson(entry.getValue(), AnvilRepair.class);
                REPAIRS.put(entry.getKey(), anvilRepair);
            }
            catch (JsonSyntaxException e) {
                ISOLogHelper.error("Parsing error loading Anvil Recipe %s: %s", entry.getKey(), e.getMessage());
            }
            catch (Exception e) {
                ISOLogHelper.error("Failed loading Anvil Recipe %s: %s", entry.getKey(), e.getMessage());
            }
        }
        ISOLogHelper.info("Loaded %s Anvil Recipes", REPAIRS.size());
    }

    @SubscribeEvent
    public static void onDataPackSync(OnDatapackSyncEvent event) {
        if (event.getPlayer() == null) {
            event.getPlayerList().m_11314_().forEach(player -> AnvilRepairSync.sync(REPAIRS, player));
        } else {
            AnvilRepairSync.sync(REPAIRS, event.getPlayer());
        }
    }

    public String m_7812_() {
        return "Anvil Repair Reload Listener";
    }

    static {
        GSON = new GsonBuilder().create();
        INSTANCE = new AnvilRepairReloadListener();
    }
}

