/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.experience.enchantments;

import com.google.common.collect.Lists;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.teamabnormals.allurement.core.AllurementConfig;
import insane96mcp.iguanatweaksreborn.InsaneSO;
import insane96mcp.iguanatweaksreborn.event.EnchantmentBonusMiningSpeedEvent;
import insane96mcp.iguanatweaksreborn.event.ISOEventFactory;
import insane96mcp.iguanatweaksreborn.event.StackMaxDamageEvent;
import insane96mcp.iguanatweaksreborn.integration.ToolBeltIntegration;
import insane96mcp.iguanatweaksreborn.mixin.EnchantmentAccessor;
import insane96mcp.iguanatweaksreborn.module.experience.enchantments.enchantment.FireAspect;
import insane96mcp.iguanatweaksreborn.module.experience.enchantments.enchantment.IAttributeEnchantment;
import insane96mcp.iguanatweaksreborn.module.experience.enchantments.enchantment.Knockback;
import insane96mcp.iguanatweaksreborn.module.experience.enchantments.enchantment.Luck;
import insane96mcp.iguanatweaksreborn.module.experience.enchantments.enchantment.damage.BaneOfSSSS;
import insane96mcp.iguanatweaksreborn.module.experience.enchantments.enchantment.damage.BonusDamageEnchantment;
import insane96mcp.iguanatweaksreborn.module.experience.enchantments.enchantment.damage.Sharpness;
import insane96mcp.iguanatweaksreborn.module.experience.enchantments.enchantment.damage.Smite;
import insane96mcp.iguanatweaksreborn.module.experience.enchantments.enchantment.protection.BlastProtection;
import insane96mcp.iguanatweaksreborn.module.experience.enchantments.enchantment.protection.FeatherFalling;
import insane96mcp.iguanatweaksreborn.module.experience.enchantments.enchantment.protection.FireProtection;
import insane96mcp.iguanatweaksreborn.module.experience.enchantments.enchantment.protection.OverallProtection;
import insane96mcp.iguanatweaksreborn.module.experience.enchantments.enchantment.protection.ProjectileProtection;
import insane96mcp.iguanatweaksreborn.module.experience.enchantments.integration.Allurement;
import insane96mcp.iguanatweaksreborn.module.items.misc.ItemDefinition;
import insane96mcp.iguanatweaksreborn.module.items.misc.ItemDefinitionsReloadListener;
import insane96mcp.iguanatweaksreborn.setup.ISORegistries;
import insane96mcp.iguanatweaksreborn.world.item.DurabilityModifier;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.JsonFeature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.data.IdTagMatcher;
import insane96mcp.insanelib.util.MathHelper;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.CombatEntry;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.RegistryObject;

@LoadFeature(module="iguanatweaksreborn:experience", description="Changes to some enchantments related stuff.")
public class EnchantmentsFeature
extends JsonFeature {
    static final EnchantmentCategory ACTUALLY_WEARABLE = EnchantmentCategory.create((String)"actually_wearable", item -> {
        Equipable equipable;
        return item instanceof Equipable && (equipable = (Equipable)item).m_40402_().m_254934_() || Block.m_49814_((Item)item) instanceof Equipable;
    });
    public static final RegistryObject<Enchantment> SHARPNESS = ISORegistries.ENCHANTMENTS.register("sharpness", Sharpness::new);
    public static final RegistryObject<Enchantment> SMITE = ISORegistries.ENCHANTMENTS.register("smite", Smite::new);
    public static final RegistryObject<Enchantment> BANE_OF_SSSSS = ISORegistries.ENCHANTMENTS.register("bane_of_sssss", BaneOfSSSS::new);
    public static final RegistryObject<Enchantment> FIRE_ASPECT = ISORegistries.ENCHANTMENTS.register("fire_aspect", FireAspect::new);
    public static final RegistryObject<Enchantment> KNOCKBACK = ISORegistries.ENCHANTMENTS.register("knockback", Knockback::new);
    public static final RegistryObject<Enchantment> LUCK = ISORegistries.ENCHANTMENTS.register("luck", Luck::new);
    public static final RegistryObject<Enchantment> PROTECTION = ISORegistries.ENCHANTMENTS.register("protection", OverallProtection::new);
    public static final RegistryObject<Enchantment> BLAST_PROTECTION = ISORegistries.ENCHANTMENTS.register("blast_protection", BlastProtection::new);
    public static final RegistryObject<Enchantment> FIRE_PROTECTION = ISORegistries.ENCHANTMENTS.register("fire_protection", FireProtection::new);
    public static final RegistryObject<Enchantment> PROJECTILE_PROTECTION = ISORegistries.ENCHANTMENTS.register("projectile_protection", ProjectileProtection::new);
    public static final RegistryObject<Enchantment> FEATHER_FALLING = ISORegistries.ENCHANTMENTS.register("feather_falling", FeatherFalling::new);
    @Config(description="Infinity can go up to level 4. Each level makes an arrow have only 1 in level+1 chance to consume. E.g. with Infinity 4 there's 1 in 5 chance to consume the arrow, and 4 in 5 to not consume it.")
    public static Boolean infinityOverhaul = true;
    @Config(description="Changes Unbreaking max level and actually increases item's durability instead of giving a chance for the item to not consume durability.")
    public static Boolean unbreakingOverhaul$enable = true;
    @Config
    public static Integer unbreakingOverhaul$maxLevel = 5;
    @Config
    public static Double unbreakingOverhaul$percentageIncrease = 0.2;
    @Config
    public static Integer unbreakingOverhaul$flatIncrease$armor = 10;
    @Config
    public static Integer unbreakingOverhaul$flatIncrease$shields = 15;
    @Config
    public static Integer unbreakingOverhaul$flatIncrease$tools = 25;
    @Config(description="Change the bonus efficiency formula from `lvl*lvl+1` to a percentage and flat increase.")
    public static Boolean efficiencyOverhaul$enable = true;
    @Config
    public static Double efficiencyOverhaul$percentageIncrease = 0.2;
    @Config
    public static Double efficiencyOverhaul$flatIncrease = 0.5;
    @Config(description="Changes Multishot to actually load 3 arrows, instead of materializing 2 arrows from thin air")
    public static Boolean actualMultishot = true;
    @Config(description="Thorns is no longer compatible with other protections, but deals damage every time (higher levels deal more damage) and no longer damages items.")
    public static Boolean thornsOverhaul = true;
    @Config(description="Loyalty is now one level only, equal to lvl II of the original enchantment.")
    public static Boolean loyaltyMiniRework = true;
    @Config(description="Mending only makes the tool repair by one durability every 2 xp instead of 2 durability/1 xp.")
    public static Boolean nerfMending = true;
    @Config(description="Respiration decreases air consumption by 50% per level instead of 100%.")
    public static Boolean nerfRespiration = true;
    @Config(description="Set arrow's damage increase with the Power enchantment (vanilla is 0.5). If set to a value != 0.5 the flat 0.5 bonus is also removed. Set to 0.5 to disable.")
    public static Double powerEnchantmentDamage = 0.1;
    @Config(description="If true, the formula for bonus damage for arrows is changed from `'Power Enchantment Damage' + 'Power Enchantment Damage' * lvl` to `base_damage * 'Power Enchantment Damage' * lvl`.")
    public static Boolean powerAffectsBaseArrowDamage = true;
    @Config(description="Vanilla is 0.6")
    public static Double punchStrength = 0.5;
    @Config
    public static Boolean preventFarmlandTramplingWithFeatherFalling = true;
    @Config(description="If true, vanilla protection enchantments are replaced with mod's ones. To re-enable vanilla enchantments refer to `disabled_enchantments.json`.\nProtection has only one level, protects 6% per level. Other protections work the same except for projectile that reduces the sight range of mobs by 2% per level. Feather falling protects for 16% per level instead of 12% + 1 per level.")
    public static Boolean replaceProtectionEnchantments = true;
    @Config(description="If true, vanilla damaging enchantments (such as smite or sharpness) are replaced with mod's ones. To re-enable vanilla enchantments refer to `disabled_enchantments.json`.\nChanges to damaging enchantments:\nEnchantments deal bonus damage based off the item's attack damage. So Sharpness on a Sword adds less damage than Sharpness on an Axe.\nSharpness deals +0.5 damage per level\nSmite deals +1 damage per level to undead and applies weakness\nBane of Arthropods has been replaced with Bane of Hissing that deals +1 damage per level to arthropods and creepers and applies slowness.\nImpaling is not replaced, but the bonus damage is lowered to 1 per level")
    public static Boolean replaceDamagingEnchantments = true;
    @Config(description="If true, Looting, Fortune and Luck of the Sea enchantments are replaced with a single one: Luck. Requires a Minecraft restart")
    public static Boolean reworkBonusLootEnchantments = true;
    @Config(description="If true, Luck will only have one level, working like Fortune/Looting/LoTS II.")
    public static Boolean luckOneLevelOnly = true;
    @Config(description="If true, vanilla fire aspect and knockback are replaced with mod's ones. To re-enable vanilla enchantments refer to `disabled_enchantments.json`.")
    public static Boolean replaceOtherEnchantments = true;
    public static final ArrayList<IdTagMatcher> DISABLED_ENCHANTMENTS_DEFAULT = new ArrayList<IdTagMatcher>(List.of(IdTagMatcher.newId((String)"minecraft:sharpness"), IdTagMatcher.newId((String)"minecraft:smite"), IdTagMatcher.newId((String)"minecraft:bane_of_arthropods"), IdTagMatcher.newId((String)"minecraft:fire_aspect"), IdTagMatcher.newId((String)"minecraft:knockback"), IdTagMatcher.newId((String)"minecraft:protection"), IdTagMatcher.newId((String)"minecraft:blast_protection"), IdTagMatcher.newId((String)"minecraft:projectile_protection"), IdTagMatcher.newId((String)"minecraft:fire_protection"), IdTagMatcher.newId((String)"minecraft:feather_falling"), IdTagMatcher.newId((String)"minecraft:looting"), IdTagMatcher.newId((String)"minecraft:fortune"), IdTagMatcher.newId((String)"minecraft:luck_of_the_sea"), IdTagMatcher.newId((String)"minecraft:sweeping"), IdTagMatcher.newId((String)"farmersdelight:backstabbing")));
    public static final ArrayList<IdTagMatcher> disabledEnchantments = new ArrayList();

    public EnchantmentsFeature(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
        EnchantmentsFeature.addSyncType((ResourceLocation)InsaneSO.location("disabled_enchantments"), (JsonFeature.SyncType)new JsonFeature.SyncType(json -> EnchantmentsFeature.loadAndReadJson((String)json, disabledEnchantments, DISABLED_ENCHANTMENTS_DEFAULT, (Type)IdTagMatcher.LIST_TYPE)));
        this.JSON_CONFIGS.add(new JsonFeature.JsonConfig("disabled_enchantments.json", disabledEnchantments, DISABLED_ENCHANTMENTS_DEFAULT, IdTagMatcher.LIST_TYPE, true, InsaneSO.location("disabled_enchantments")));
    }

    public String getModConfigFolder() {
        return "config/insanesurvivaloverhaul";
    }

    public void readConfig(ModConfigEvent event) {
        super.readConfig(event);
        if (infinityOverhaul.booleanValue()) {
            Enchantments.f_44952_.f_44674_ = Enchantment.Rarity.RARE;
            if (ModList.get().isLoaded("allurement")) {
                AllurementConfig.COMMON.infinityRequiresArrows.set((Object)true);
            }
        } else {
            Enchantments.f_44952_.f_44674_ = Enchantment.Rarity.VERY_RARE;
        }
        Enchantments.f_44972_.f_44674_ = this.isEnabled() && thornsOverhaul != false ? Enchantment.Rarity.RARE : Enchantment.Rarity.VERY_RARE;
        if (EnchantmentsFeature.isBonusLootEnchantmentReworkEnabled()) {
            Enchantments.f_44987_ = (Enchantment)LUCK.get();
        }
        if (this.isEnabled()) {
            ((EnchantmentAccessor)Enchantments.f_44975_).setCategory(ACTUALLY_WEARABLE);
        }
    }

    @SubscribeEvent
    public void onAttributeModifiers(ItemAttributeModifierEvent event) {
        event.getItemStack().getAllEnchantments().forEach((enchantment, lvl) -> {
            ArmorItem armorItem;
            Item patt12934$temp = event.getItemStack().m_41720_();
            if (patt12934$temp instanceof ArmorItem && (armorItem = (ArmorItem)patt12934$temp).m_40402_() != event.getSlotType()) {
                return;
            }
            if (enchantment instanceof IAttributeEnchantment) {
                IAttributeEnchantment attributeEnchantment = (IAttributeEnchantment)enchantment;
                attributeEnchantment.applyAttributeModifier(event, (int)lvl);
            }
        });
    }

    public static boolean isEnchantmentDisabled(Enchantment enchantment) {
        if (!Feature.isEnabled(EnchantmentsFeature.class)) {
            return false;
        }
        for (IdTagMatcher idTagMatcher : disabledEnchantments) {
            if (!idTagMatcher.matchesEnchantment(enchantment)) continue;
            return true;
        }
        return false;
    }

    public static boolean isUnbreakingOverhaulEnabled() {
        return Feature.isEnabled(EnchantmentsFeature.class) && unbreakingOverhaul$enable != false;
    }

    public static boolean isLoyaltyMiniReworkEnabled() {
        return Feature.isEnabled(EnchantmentsFeature.class) && loyaltyMiniRework != false;
    }

    @SubscribeEvent
    public void onStackDurability(StackMaxDamageEvent event) {
        if (!EnchantmentsFeature.isUnbreakingOverhaulEnabled()) {
            return;
        }
        int lvl = event.getStack().getEnchantmentLevel(Enchantments.f_44986_);
        if (lvl <= 0) {
            return;
        }
        event.setNewMaxDamage((int)((double)(event.getNewMaxDamage() + EnchantmentsFeature.getBonusFlatUnbreakingDurability(event.getStack()) * lvl) * (1.0 + (double)lvl * unbreakingOverhaul$percentageIncrease)));
    }

    public static int getBonusFlatUnbreakingDurability(ItemStack stack) {
        float f;
        Item item = stack.m_41720_();
        if (item instanceof DurabilityModifier) {
            DurabilityModifier durabilityModifier = (DurabilityModifier)item;
            f = durabilityModifier.getDurabilityMultiplier(stack);
        } else {
            f = 1.0f;
        }
        float durModifier = f;
        for (ItemDefinition definition : ItemDefinitionsReloadListener.DEFINITIONS) {
            if (!definition.item().matchesItem(stack) || definition.durability() == null || definition.durability().durabilityMultiplier == null) continue;
            durModifier *= definition.durability().durabilityMultiplier.floatValue();
        }
        if (stack.m_41720_() instanceof ShieldItem) {
            return (int)((float)unbreakingOverhaul$flatIncrease$shields.intValue() * durModifier);
        }
        return (int)((float)(stack.m_41720_() instanceof ArmorItem ? unbreakingOverhaul$flatIncrease$armor : unbreakingOverhaul$flatIncrease$tools).intValue() * durModifier);
    }

    public static boolean isBetterEfficiencyFormula() {
        return Feature.isEnabled(EnchantmentsFeature.class) && efficiencyOverhaul$enable != false;
    }

    @SubscribeEvent
    public void applyNewEfficiency(EnchantmentBonusMiningSpeedEvent event) {
        int lvl = event.getStack().getEnchantmentLevel(Enchantments.f_44984_);
        event.setNewMiningSpeed(event.getNewMiningSpeed() + EnchantmentsFeature.getEfficiencyBonus(event.getNewMiningSpeed(), lvl));
    }

    public static float getEfficiencyBonus(float baseEfficiency, int lvl) {
        if (lvl == 0) {
            return 0.0f;
        }
        if (!EnchantmentsFeature.isBetterEfficiencyFormula()) {
            return 1 + lvl * lvl;
        }
        float flatBonus = efficiencyOverhaul$flatIncrease.floatValue() * (float)lvl;
        return flatBonus + (baseEfficiency + flatBonus) * (float)lvl * efficiencyOverhaul$percentageIncrease.floatValue();
    }

    public static boolean isThornsOverhaul() {
        return Feature.isEnabled(EnchantmentsFeature.class) && thornsOverhaul != false;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onKnockback(LivingKnockBackEvent event) {
        if (!this.isEnabled() || event.getEntity().m_21231_().f_19276_.isEmpty() || event.getEntity().getPersistentData().m_128441_("iguanatweaksexpanded:cancel_knockback")) {
            return;
        }
        Entity directAttacker = ((CombatEntry)event.getEntity().m_21231_().f_19276_.get(event.getEntity().m_21231_().f_19276_.size() - 1)).f_19250_().m_7640_();
        if (!(directAttacker instanceof LivingEntity)) {
            return;
        }
        LivingEntity attacker = (LivingEntity)directAttacker;
        float knockback = Knockback.getKnockback(attacker);
        if (knockback == 0.0f) {
            return;
        }
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            float f = player.m_36403_(0.5f);
            knockback *= f * f;
        }
        event.setStrength(event.getStrength() + (knockback *= insane96mcp.iguanatweaksreborn.module.combat.Knockback.getKnockbackMultiplier(attacker.m_21205_())));
    }

    @SubscribeEvent
    public void onVisibility(LivingEvent.LivingVisibilityEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        int lvl = EnchantmentHelper.m_44836_((Enchantment)((Enchantment)PROJECTILE_PROTECTION.get()), (LivingEntity)event.getEntity());
        if (lvl < 1) {
            return;
        }
        event.modifyVisibility((double)(1.0f - 0.05f * (float)lvl));
    }

    public static float bonusDamageEnchantment(Enchantment enchantment, int lvl, LivingEntity attacker, Entity target) {
        if (!(enchantment instanceof BonusDamageEnchantment)) {
            return 0.0f;
        }
        BonusDamageEnchantment bonusDamageEnchantment = (BonusDamageEnchantment)enchantment;
        return bonusDamageEnchantment.getDamageBonus(attacker, target, attacker.m_21205_(), lvl);
    }

    @SubscribeEvent
    public void onFarmlandTrample(BlockEvent.FarmlandTrampleEvent event) {
        LivingEntity entity;
        Entity entity2;
        if (!this.isEnabled() || !preventFarmlandTramplingWithFeatherFalling.booleanValue() || !((entity2 = event.getEntity()) instanceof LivingEntity) || EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44967_, (LivingEntity)(entity = (LivingEntity)entity2)) <= 0 && EnchantmentHelper.m_44836_((Enchantment)((Enchantment)FEATHER_FALLING.get()), (LivingEntity)entity) <= 0) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onExperiencePickUp(PlayerXpEvent.PickupXp event) {
        int i;
        if (!this.isEnabled() || !nerfMending.booleanValue()) {
            return;
        }
        event.setCanceled(true);
        Player player = event.getEntity();
        player.f_36101_ = 2;
        player.m_7938_((Entity)event.getOrb(), 1);
        if (ModList.get().isLoaded("allurement")) {
            Allurement.onExperiencePickup(player, event.getOrb());
        }
        if ((i = EnchantmentsFeature.repairPlayerItems(event.getOrb(), player, event.getOrb().f_20770_)) > 0) {
            player.m_6756_(i);
        }
        --event.getOrb().f_147072_;
        if (event.getOrb().f_147072_ == 0) {
            event.getOrb().m_146870_();
        }
    }

    private static int repairPlayerItems(ExperienceOrb xpOrb, Player player, int xp) {
        ItemStack stack = EnchantmentsFeature.getRandomItemWith(Enchantments.f_44962_, (LivingEntity)player, ItemStack::m_41768_);
        if (stack == null) {
            return xp;
        }
        float repairAmount = Math.min((float)xpOrb.f_20770_ * 0.5f, (float)stack.m_41773_());
        stack.m_41721_(stack.m_41773_() - MathHelper.getAmountWithDecimalChance((RandomSource)player.m_217043_(), (float)repairAmount));
        int j = xp - Math.round(repairAmount * 2.0f);
        return j > 0 ? EnchantmentsFeature.repairPlayerItems(xpOrb, player, j) : 0;
    }

    public static ItemStack getRandomItemWith(Enchantment enchantment, LivingEntity livingEntity, Predicate<ItemStack> pStackCondition) {
        Map map = enchantment.m_44684_(livingEntity);
        if (map.isEmpty()) {
            return null;
        }
        ArrayList list = Lists.newArrayList();
        for (Map.Entry entry : map.entrySet()) {
            ItemStack itemStack = (ItemStack)entry.getValue();
            if (itemStack.m_41619_() || EnchantmentHelper.getTagEnchantmentLevel((Enchantment)enchantment, (ItemStack)itemStack) <= 0 || !pStackCondition.test(itemStack)) continue;
            list.add(itemStack);
        }
        return list.isEmpty() ? null : (ItemStack)list.get(livingEntity.m_217043_().m_188503_(list.size()));
    }

    public static void destroyVanishingCurseItemsInToolBelt(LivingEntity player) {
        if (!ModList.get().isLoaded("toolbelt")) {
            return;
        }
        ToolBeltIntegration.removeCursedItemsOnDeath(player);
    }

    @SubscribeEvent
    public void onFall(LivingFallEvent event) {
        int lvl = event.getEntity().m_6844_(EquipmentSlot.FEET).getEnchantmentLevel((Enchantment)FEATHER_FALLING.get());
        if (lvl <= 0) {
            return;
        }
        event.setDistance(event.getDistance() - (float)lvl);
    }

    public static boolean isInfinityOverhaulEnabled() {
        return Feature.isEnabled(EnchantmentsFeature.class) && infinityOverhaul != false;
    }

    public static boolean shouldReplaceBaneOfArthropods(Enchantment enchantment) {
        return enchantment == Enchantments.f_44979_ && Feature.isEnabled(EnchantmentsFeature.class) && EnchantmentsFeature.isEnchantmentDisabled(Enchantments.f_44979_) && !EnchantmentsFeature.isEnchantmentDisabled((Enchantment)BANE_OF_SSSSS.get());
    }

    public static boolean shouldReplaceWithLuck(Enchantment enchantment) {
        return (enchantment == Enchantments.f_44987_ || enchantment == Enchantments.f_44982_ || enchantment == Enchantments.f_44953_) && EnchantmentsFeature.isBonusLootEnchantmentReworkEnabled();
    }

    public static int getLuckLevel(int original, int luckLvl) {
        if (!EnchantmentsFeature.isBonusLootEnchantmentReworkEnabled() || !EnchantmentsFeature.isLuckOneLevelOnly() || luckLvl == 0) {
            return original;
        }
        return 2;
    }

    public static int getLuckLevel(ItemStack stack, int original) {
        int luckLvl = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)LUCK.get()), (ItemStack)stack);
        if (luckLvl <= 0) {
            return original;
        }
        return EnchantmentsFeature.isLuckOneLevelOnly() ? 2 : luckLvl;
    }

    public static boolean isBonusLootEnchantmentReworkEnabled() {
        return Feature.isEnabled(EnchantmentsFeature.class) && reworkBonusLootEnchantments != false;
    }

    public static boolean isLuckOneLevelOnly() {
        return Feature.isEnabled(EnchantmentsFeature.class) && luckOneLevelOnly != false;
    }

    public static int getEnchantmentValue(ItemStack stack, Operation<Integer> original) {
        for (ItemDefinition itemDefinition : ItemDefinitionsReloadListener.DEFINITIONS) {
            if (itemDefinition.enchantability() == null || !itemDefinition.item().matchesItem(stack)) continue;
            return itemDefinition.enchantability();
        }
        return (Integer)original.call(new Object[]{stack});
    }

    public static int getEnchantmentValue(ItemStack stack) {
        for (ItemDefinition itemDefinition : ItemDefinitionsReloadListener.DEFINITIONS) {
            if (itemDefinition.enchantability() == null || !itemDefinition.item().matchesItem(stack)) continue;
            return itemDefinition.enchantability();
        }
        return stack.getEnchantmentValue();
    }

    public static float applyMiningSpeedModifiers(float miningSpeed, @Nullable BlockState state, boolean applyEfficiency, @Nullable LivingEntity entity, boolean applyEntityBonuses) {
        if (entity == null) {
            return miningSpeed;
        }
        if (applyEfficiency) {
            int i = EnchantmentHelper.m_44926_((LivingEntity)entity);
            ItemStack itemstack = entity.m_21205_();
            if (i > 0 && !itemstack.m_41619_()) {
                miningSpeed += ISOEventFactory.getMiningSpeedWithEnchantments(entity, state, itemstack, miningSpeed, false);
            }
        }
        if (!applyEntityBonuses) {
            return miningSpeed;
        }
        if (MobEffectUtil.m_19584_((LivingEntity)entity)) {
            miningSpeed *= 1.0f + (float)(MobEffectUtil.m_19586_((LivingEntity)entity) + 1) * 0.2f;
        }
        if (entity.m_21023_(MobEffects.f_19599_)) {
            float miningFatigueMultiplier = switch (entity.m_21124_(MobEffects.f_19599_).m_19564_()) {
                case 0 -> 0.3f;
                case 1 -> 0.09f;
                case 2 -> 0.0027f;
                default -> 8.1E-4f;
            };
            miningSpeed *= miningFatigueMultiplier;
        }
        if (entity.isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get()) && !EnchantmentHelper.m_44934_((LivingEntity)entity)) {
            miningSpeed /= 5.0f;
        }
        if (!entity.m_20096_()) {
            miningSpeed /= 5.0f;
        }
        return miningSpeed;
    }
}

