/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.experience.enchantments.enchantment.damage;

import insane96mcp.iguanatweaksreborn.data.generator.ISOItemTagsProvider;
import insane96mcp.iguanatweaksreborn.module.experience.enchantments.EnchantmentsFeature;
import insane96mcp.insanelib.base.Feature;
import java.util.Set;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import org.jetbrains.annotations.NotNull;

public abstract class BonusDamageEnchantment
extends Enchantment {
    public static final TagKey<Item> ACCEPTS_ENCHANTMENT = ISOItemTagsProvider.create("enchanting/accepts_damage_enchantments");
    static final EnchantmentCategory CATEGORY = EnchantmentCategory.create((String)"damage_enchantment", item -> item.m_204114_().m_203656_(ACCEPTS_ENCHANTMENT));

    protected BonusDamageEnchantment(Enchantment.Rarity pRarity, EquipmentSlot[] pApplicableSlots) {
        super(pRarity, CATEGORY, pApplicableSlots);
    }

    public int m_6183_(int lvl) {
        return 4 + (lvl - 1) * 8;
    }

    public int m_6175_(int lvl) {
        return this.m_6183_(lvl) + 20;
    }

    protected boolean m_5975_(@NotNull Enchantment other) {
        return super.m_5975_(other) && !(other instanceof BonusDamageEnchantment);
    }

    public int m_6586_() {
        return 5;
    }

    public float getDamageBonus(LivingEntity attacker, Entity target, ItemStack stack, int lvl) {
        if (!this.isAffectedByEnchantment(target)) {
            return 0.0f;
        }
        return this.getDamageBonus(stack, lvl);
    }

    public float getDamageBonus(ItemStack stack, int lvl) {
        return this.getDamageBonusPerLevel() * (float)lvl * BonusDamageEnchantment.getDamageBonusRatio(stack);
    }

    public float getDamageBonusPerLevel() {
        return 1.0f;
    }

    public boolean isAffectedByEnchantment(Entity target) {
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return (super.canApplyAtEnchantingTable(stack) || stack.m_204117_(ACCEPTS_ENCHANTMENT)) && EnchantmentsFeature.replaceDamagingEnchantments != false && Feature.isEnabled(EnchantmentsFeature.class);
    }

    public boolean m_6592_() {
        return super.m_6592_() && EnchantmentsFeature.replaceDamagingEnchantments != false && Feature.isEnabled(EnchantmentsFeature.class);
    }

    public boolean allowedInCreativeTab(Item book, Set<EnchantmentCategory> allowedCategories) {
        return this.m_6592_();
    }

    public static float getDamageBonusRatio(ItemStack stack) {
        return (float)(stack.m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22281_).stream().filter(attributeModifier -> attributeModifier.m_22217_() == AttributeModifier.Operation.MULTIPLY_BASE).mapToDouble(AttributeModifier::m_22218_).sum() + 1.0);
    }
}

