/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.farming.livestock;

import insane96mcp.iguanatweaksreborn.InsaneSO;
import insane96mcp.iguanatweaksreborn.modifier.Modifier;
import insane96mcp.iguanatweaksreborn.module.experience.DroppedExperience;
import insane96mcp.iguanatweaksreborn.module.farming.livestock.ISOEatBlock;
import insane96mcp.iguanatweaksreborn.module.farming.livestock.LivestockData;
import insane96mcp.iguanatweaksreborn.module.farming.livestock.LivestockDataReloadListener;
import insane96mcp.iguanatweaksreborn.module.farming.livestock.PehkuiIntegration;
import insane96mcp.iguanatweaksreborn.module.misc.Packs;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.network.message.EntityModNBTDataSync;
import insane96mcp.insanelib.util.MCUtils;
import insane96mcp.insanelib.util.ModNBTData;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.ModList;

@LoadFeature(module="iguanatweaksreborn:farming", description="Slower breeding, Growing, Egging and Milking. Lower yield.")
public class Livestock
extends Feature {
    public static final TagKey<EntityType<?>> MILKABLE = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)InsaneSO.location("milkable"));
    public static final TagKey<EntityType<?>> PREVENT_BREEDING = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)InsaneSO.location("prevent_breeding"));
    public static final String MILK_COOLDOWN_LANG = "iguanatweaksreborn.milk_cooldown";
    public static ResourceLocation AGE;
    public static ResourceLocation MAX_AGE;
    public static ResourceLocation STOP_AGING;
    public static ResourceLocation LAST_FED;
    public static ResourceLocation MILK_COOLDOWN;
    public static ResourceKey<DamageType> OLD_AGE;
    @Config(description="Changes the chance for a chicken to come out from an egg (1 in this value). Vanilla is 8")
    public static Integer chickenFromEggChance;
    @Config(min=0.0, description="Seconds until you can milk cows (or stew mooshrooms)")
    public static Integer fluidCooldown;
    @Config(description="If true, animals will no longer be able to be bred manually. Only animals in iguanatweaksreborn:prevent_breeding will be affected by this.")
    public static Boolean preventBreeding;
    @Config(description="If true, mobs can randomly fall in love and possibly breed")
    public static Boolean autoBreed;
    @Config(min=0.0, description="If true, animals will be 'well fed' for this ticks when fed. During this time they have an higher chance (given by the livestock data) to breed. Set to 0 to disable.")
    public static Integer wellFed$duration;
    @Config(min=0.0, description="How much well fed time must be left to the entity to be able to feed it again.")
    public static Integer wellFed$leftToFeedAgain;
    @Config(min=0.0, description="How much well fed time is consumed when animals breed.")
    public static Integer wellFed$consumedOnBreed;
    @Config(description="If true, animals will age and die of old age. Configurable via data packs. With the data pack enabled, adult will drop more goodies. With pehkui installed, animals will also be smaller/bigger.")
    public static Boolean aging$enable;
    @Config(description="If true, animals die of old age.")
    public static Boolean aging$dieOfOldAge;
    @Config(description="If Die of old age is disabled you can still make animals grow up to this age")
    public static Age aging$stopAt;
    @Config(description="If fed a poisonous potato, animals will stop aging at a 'Stop At With Poisonous Potato' age.")
    public static Boolean aging$stopAgingWithPoisonousPotato;
    @Config(description="If true, animals will die if not young and haven't been fed in a while.")
    public static Boolean aging$starvationDeath;
    @Config(description="Enables a data pack that changes animal loot (reduced food drops) and slows down growing, breeding, egging etc")
    public static Boolean dataPack;

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        InsaneSO.addServerPack("livestock_changes", "Livestock Changes", () -> this.isEnabled() && Packs.disableAllDataPacks == false && dataPack != false);
        AGE = this.createDataKey("age");
        MAX_AGE = this.createDataKey("max_age");
        STOP_AGING = this.createDataKey("stop_aging");
        LAST_FED = this.createDataKey("last_fed");
        MILK_COOLDOWN = this.createDataKey("milk_cooldown");
    }

    @SubscribeEvent
    public void onSheepJoinLevel(EntityJoinLevelEvent event) {
        Entity entity;
        if (!this.isEnabled() || !((entity = event.getEntity()) instanceof Sheep)) {
            return;
        }
        Sheep sheep = (Sheep)entity;
        sheep.f_21345_.m_25363_((Goal)sheep.f_29803_);
        sheep.f_29803_ = new ISOEatBlock((Mob)sheep);
        sheep.f_21345_.m_25352_(5, (Goal)sheep.f_29803_);
    }

    @SubscribeEvent
    public void onLivingTick(LivingEvent.LivingTickEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (!event.getEntity().m_9236_().f_46443_) {
            Livestock.slowdownAnimalGrowth(event);
            Livestock.slowdownBreeding(event);
            Livestock.aging(event);
            Livestock.eggLay(event);
            Livestock.tryAutoBreed(event);
            if (Livestock.hasBeenFedRecently(event.getEntity()) && event.getEntity().m_217043_().m_188503_(200) == 0) {
                ((ServerLevel)event.getEntity().m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123748_, event.getEntity().m_20185_(), event.getEntity().m_20186_() + (double)(event.getEntity().m_20206_() / 1.5f), event.getEntity().m_20189_(), 5, 0.25, 0.25, 0.25, (double)0.2f);
            }
        }
        this.cowMilkTick(event);
    }

    public static double getRandomXWithin(LivingEntity entity, double delta) {
        return Livestock.getRandomValueInWidth(entity, delta) + entity.m_20185_();
    }

    public static double getRandomZWithin(LivingEntity entity, double delta) {
        return Livestock.getRandomValueInWidth(entity, delta) + entity.m_20189_();
    }

    public static double getRandomValueInWidth(LivingEntity entity, double delta) {
        return Mth.m_216263_((RandomSource)entity.m_217043_(), (double)((double)(-entity.m_20205_()) - delta), (double)((double)entity.m_20205_() + delta));
    }

    public static void tryAutoBreed(LivingEvent.LivingTickEvent event) {
        Animal animal;
        LivingEntity livingEntity;
        if (!(autoBreed.booleanValue() && (livingEntity = event.getEntity()) instanceof Animal && (animal = (Animal)livingEntity).m_5957_() && animal.m_146764_() == 0)) {
            return;
        }
        if ((event.getEntity().f_19797_ + event.getEntity().m_19879_()) % 600 != 0) {
            return;
        }
        if (event.getEntity().m_9236_().m_6249_((Entity)event.getEntity(), animal.m_20191_().m_82400_(16.0), entity -> entity.m_6095_() == animal.m_6095_()).size() > 16) {
            return;
        }
        ArrayList<Modifier> modifiersToApply = new ArrayList<Modifier>();
        LivestockDataReloadListener.LIVESTOCK_DATA.stream().filter(data -> data.matches((Entity)animal)).forEach(data -> modifiersToApply.addAll(data.autoBreedChanceModifiers));
        float chance = Modifier.applyModifiers(0.0f, modifiersToApply, animal.m_9236_(), animal.m_20183_(), (LivingEntity)animal);
        if ((double)chance <= 0.0 || animal.m_217043_().m_188501_() >= chance) {
            return;
        }
        animal.m_27595_(null);
    }

    public static boolean canSheepRegrowWool(Mob mob) {
        ArrayList<Modifier> modifiersToApply = new ArrayList<Modifier>();
        LivestockDataReloadListener.LIVESTOCK_DATA.stream().filter(data -> data.matches((Entity)mob)).forEach(data -> modifiersToApply.addAll(data.sheepWoolGrowthChanceModifiers));
        float chance = Modifier.applyModifiers(1.0f, modifiersToApply, mob.m_9236_(), mob.m_20183_(), (LivingEntity)mob);
        if ((double)chance >= 1.0) {
            return true;
        }
        return mob.m_217043_().m_188501_() < chance;
    }

    public static void aging(LivingEvent.LivingTickEvent event) {
        Age currAge;
        AgeableMob ageableMob;
        LivingEntity livingEntity;
        if (!aging$enable.booleanValue() || !((livingEntity = event.getEntity()) instanceof AgeableMob) || ((ageableMob = (AgeableMob)livingEntity).m_9236_().m_7654_().m_129921_() + ageableMob.m_19879_()) % 20 != 0 || ageableMob.m_6162_()) {
            return;
        }
        if (aging$stopAgingWithPoisonousPotato.booleanValue() && ((Boolean)ModNBTData.get((Entity)ageableMob, (ResourceLocation)STOP_AGING, Boolean.class)).booleanValue()) {
            return;
        }
        boolean forceUpdateScale = false;
        int age = (Integer)ModNBTData.get((Entity)ageableMob, (ResourceLocation)AGE, Integer.class);
        int maxAge = (Integer)ModNBTData.get((Entity)ageableMob, (ResourceLocation)MAX_AGE, Integer.class);
        if (maxAge == 0) {
            for (LivestockData data : LivestockDataReloadListener.LIVESTOCK_DATA) {
                if (!data.matches((Entity)ageableMob) || data.livingDays == null) continue;
                maxAge = (int)(data.getLivingDays((LivingEntity)ageableMob) * 20.0f * 60.0f);
                ModNBTData.put((Entity)ageableMob, (ResourceLocation)MAX_AGE, (Object)maxAge);
                break;
            }
            if (maxAge == 0) {
                return;
            }
            forceUpdateScale = true;
        }
        if ((currAge = Livestock.getAge(ageableMob)) == aging$stopAt && !aging$dieOfOldAge.booleanValue()) {
            return;
        }
        ++age;
        Age newAge = Livestock.getAge(ageableMob);
        if (aging$starvationDeath.booleanValue() && newAge != Age.YOUNG && !Livestock.hasBeenFedRecently((LivingEntity)ageableMob)) {
            ageableMob.m_6469_(ageableMob.m_269291_().m_269064_(), Float.MAX_VALUE);
        }
        if (newAge == Age.ELDER) {
            MCUtils.applyModifier((LivingEntity)ageableMob, (Attribute)Attributes.f_22279_, (UUID)UUID.fromString("e2083ae7-e37a-47c4-ab3e-84cf14fe6b6c"), (String)"Old animal modifier", (double)-0.35, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_BASE, (boolean)false);
        }
        if (age >= maxAge) {
            if (aging$dieOfOldAge.booleanValue()) {
                ageableMob.m_6469_(ageableMob.m_269291_().m_269298_(OLD_AGE, null), Float.MAX_VALUE);
            }
            return;
        }
        if (ModList.get().isLoaded("pehkui") && ((ageableMob.m_9236_().m_7654_().m_129921_() + ageableMob.m_19879_()) % 100 == 0 || forceUpdateScale)) {
            PehkuiIntegration.setSize((LivingEntity)ageableMob, newAge);
        }
        ModNBTData.put((Entity)ageableMob, (ResourceLocation)AGE, (Object)age);
    }

    public static float getAgeRatio(AgeableMob mob) {
        return (float)((Integer)ModNBTData.get((Entity)mob, (ResourceLocation)AGE, Integer.class)).intValue() / (float)((Integer)ModNBTData.get((Entity)mob, (ResourceLocation)MAX_AGE, Integer.class)).intValue();
    }

    public static Age getAge(AgeableMob mob) {
        float ratio = Livestock.getAgeRatio(mob);
        if (ratio < 0.3f) {
            return Age.YOUNG;
        }
        if (ratio < 0.7f) {
            return Age.ADULT;
        }
        return Age.ELDER;
    }

    public static void slowdownAnimalGrowth(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof AgeableMob)) {
            return;
        }
        AgeableMob mob = (AgeableMob)livingEntity;
        int growingAge = mob.m_146764_();
        if (growingAge >= 0) {
            return;
        }
        ArrayList<Modifier> modifiersToApply = new ArrayList<Modifier>();
        LivestockDataReloadListener.LIVESTOCK_DATA.stream().filter(data -> data.matches((Entity)mob)).forEach(data -> modifiersToApply.addAll(data.growthSpeedModifiers));
        float chanceToSlowDown = Modifier.applyModifiers(0.0f, modifiersToApply, mob.m_9236_(), mob.m_20183_(), (LivingEntity)mob);
        if ((double)chanceToSlowDown <= 1.0) {
            return;
        }
        double chance = 1.0 / (double)chanceToSlowDown;
        if ((double)mob.m_217043_().m_188501_() > chance) {
            mob.m_146762_(growingAge - 1);
        }
    }

    public static void slowdownBreeding(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof AgeableMob)) {
            return;
        }
        AgeableMob mob = (AgeableMob)livingEntity;
        int growingAge = mob.m_146764_();
        if (growingAge <= 0) {
            return;
        }
        ArrayList<Modifier> modifiersToApply = new ArrayList<Modifier>();
        LivestockDataReloadListener.LIVESTOCK_DATA.stream().filter(data -> data.matches((Entity)mob)).forEach(data -> modifiersToApply.addAll(data.breedingCooldownModifiers));
        float chanceToSlowDown = Modifier.applyModifiers(0.0f, modifiersToApply, mob.m_9236_(), mob.m_20183_(), (LivingEntity)mob);
        if ((double)chanceToSlowDown <= 1.0) {
            return;
        }
        double chance = 1.0 / (double)chanceToSlowDown;
        if ((double)mob.m_217043_().m_188501_() > chance) {
            mob.m_146762_(growingAge + 1);
        }
    }

    public static void eggLay(LivingEvent.LivingTickEvent event) {
        Chicken chicken;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Chicken) || (chicken = (Chicken)livingEntity).m_6162_()) {
            return;
        }
        if (chicken.f_28231_ < 0) {
            return;
        }
        ArrayList<Modifier> modifiersToApply = new ArrayList<Modifier>();
        LivestockDataReloadListener.LIVESTOCK_DATA.stream().filter(data -> data.matches((Entity)chicken)).forEach(data -> modifiersToApply.addAll(data.eggLayCooldownModifiers));
        float chanceToSlowDown = Modifier.applyModifiers(0.0f, modifiersToApply, chicken.m_9236_(), chicken.m_20183_(), (LivingEntity)chicken);
        if ((double)chanceToSlowDown <= 1.0) {
            return;
        }
        double chance = 1.0 / (double)chanceToSlowDown;
        if ((double)chicken.m_217043_().m_188501_() > chance) {
            ++chicken.f_28231_;
        }
    }

    @SubscribeEvent
    public void onAnimalFeed(PlayerInteractEvent.EntityInteract event) {
        Entity entity;
        if (event.isCanceled() || !this.isEnabled() || !((entity = event.getTarget()) instanceof Animal)) {
            return;
        }
        Animal animal = (Animal)entity;
        Livestock.feedToBreed(event, animal);
        if (event.isCanceled()) {
            return;
        }
        Livestock.poisonAnimal(event, animal);
    }

    public static void feedToBreed(PlayerInteractEvent.EntityInteract event, Animal animal) {
        TamableAnimal tamableAnimal;
        if (wellFed$duration <= 0 || !animal.m_6898_(event.getItemStack()) || !animal.m_6095_().m_204039_(PREVENT_BREEDING) || animal.m_6162_() || animal instanceof TamableAnimal && !(tamableAnimal = (TamableAnimal)animal).m_21824_()) {
            return;
        }
        if (!Livestock.canBeFed((LivingEntity)animal)) {
            event.setCanceled(true);
            return;
        }
        int age = animal.m_146764_();
        if (!animal.m_9236_().f_46443_ && age == 0 && animal.m_5957_()) {
            Livestock.setLastEat((LivingEntity)animal);
        }
    }

    public static void poisonAnimal(PlayerInteractEvent.EntityInteract event, Animal animal) {
        if (!aging$stopAgingWithPoisonousPotato.booleanValue() || !event.getItemStack().m_150930_(Items.f_42675_) || animal.m_6162_() || ((Boolean)ModNBTData.get((Entity)animal, (ResourceLocation)STOP_AGING, Boolean.class)).booleanValue()) {
            return;
        }
        animal.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 80));
        ModNBTData.put((Entity)animal, (ResourceLocation)STOP_AGING, (Object)true);
        event.getItemStack().m_41774_(1);
        event.getEntity().m_6674_(event.getHand());
    }

    public static void setLastEat(LivingEntity living, long lastFed) {
        ModNBTData.put((Entity)living, (ResourceLocation)LAST_FED, (Object)lastFed);
    }

    public static void setLastEat(LivingEntity living) {
        Livestock.setLastEat(living, living.m_9236_().m_46467_());
    }

    public static long getLastFed(LivingEntity living) {
        return (Long)ModNBTData.get((Entity)living, (ResourceLocation)LAST_FED, Long.class);
    }

    public static boolean hasBeenFedRecently(LivingEntity living) {
        long lastFed = Livestock.getLastFed(living);
        return lastFed > 0L && living.m_9236_().m_46467_() - lastFed < (long)(wellFed$duration * 60 * 20);
    }

    public static boolean canBeFed(LivingEntity living) {
        long lastFed = Livestock.getLastFed(living);
        if (lastFed == 0L) {
            return true;
        }
        return living.m_9236_().m_46467_() - lastFed > (long)(wellFed$leftToFeedAgain * 60 * 20);
    }

    public static void consumeFeed(LivingEntity living) {
        long lastFed = Livestock.getLastFed(living);
        if (lastFed > 0L) {
            lastFed -= (long)(wellFed$consumedOnBreed * 60 * 20);
        }
        Livestock.setLastEat(living, lastFed);
    }

    public void cowMilkTick(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity;
        if (event.getEntity().f_19797_ % 20 != 0 || !event.getEntity().m_6095_().m_204039_(MILKABLE) || !((livingEntity = event.getEntity()) instanceof Animal)) {
            return;
        }
        Animal animal = (Animal)livingEntity;
        int milkCooldown = (Integer)ModNBTData.get((Entity)animal, (ResourceLocation)MILK_COOLDOWN, Integer.class);
        if (milkCooldown > 0) {
            milkCooldown -= 20;
        }
        ModNBTData.put((Entity)animal, (ResourceLocation)MILK_COOLDOWN, (Object)milkCooldown);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onAnimalMilk(PlayerInteractEvent.EntityInteract event) {
        Animal animal;
        Entity entity;
        if (!this.isEnabled() || !event.getTarget().m_6095_().m_204039_(MILKABLE) || (entity = event.getTarget()) instanceof Animal && (animal = (Animal)entity).m_146764_() < 0 || !((entity = event.getTarget()) instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        Player player = event.getEntity();
        InteractionHand hand = event.getHand();
        ItemStack equipped = player.m_21120_(hand);
        if (equipped.m_41619_() || equipped.m_41720_() == Items.f_41852_) {
            return;
        }
        Item item = equipped.m_41720_();
        if (!(FluidUtil.getFluidHandler((ItemStack)equipped).isPresent() && FluidStack.loadFluidStackFromNBT((CompoundTag)equipped.m_41783_()).isEmpty() || living instanceof MushroomCow && item == Items.f_42399_)) {
            return;
        }
        int milkCooldown = (Integer)ModNBTData.get((Entity)living, (ResourceLocation)MILK_COOLDOWN, Integer.class);
        if (milkCooldown > 0) {
            event.setCanceled(true);
            if (!player.m_9236_().f_46443_) {
                living.m_5496_(SoundEvents.f_11832_, 0.4f, (event.getEntity().m_9236_().f_46441_.m_188501_() - event.getEntity().m_9236_().f_46441_.m_188501_()) * 0.2f + 1.2f);
                MutableComponent message = Component.m_237110_((String)MILK_COOLDOWN_LANG, (Object[])new Object[]{living.m_5446_()});
                player.m_5661_((Component)message, true);
            } else {
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
        } else if (!living.m_9236_().f_46443_) {
            ArrayList<Modifier> modifiersToApply = new ArrayList<Modifier>();
            LivestockDataReloadListener.LIVESTOCK_DATA.stream().filter(data -> data.matches((Entity)living)).forEach(data -> modifiersToApply.addAll(data.cowFluidCooldownModifiers));
            DroppedExperience.tryGenerateMilkXp((Entity)living);
            float cooldown = Modifier.applyModifiers(fluidCooldown.intValue(), modifiersToApply, living.m_9236_(), living.m_20183_(), living);
            if (cooldown <= 0.0f) {
                return;
            }
            milkCooldown = (int)(cooldown * 20.0f);
            ModNBTData.put((Entity)living, (ResourceLocation)MILK_COOLDOWN, (Object)milkCooldown);
            EntityModNBTDataSync.sync((LivingEntity)living, (ResourceLocation)MILK_COOLDOWN, Integer.class);
        }
    }

    @SubscribeEvent
    public void onEntityLoad(EntityJoinLevelEvent event) {
        LivingEntity livingEntity;
        Entity entity;
        if (!this.isEnabled() || event.getLevel().f_46443_ || !((entity = event.getEntity()) instanceof LivingEntity) || ModNBTData.contains((Entity)(livingEntity = (LivingEntity)entity), (ResourceLocation)MILK_COOLDOWN)) {
            return;
        }
        EntityModNBTDataSync.sync((LivingEntity)livingEntity, (ResourceLocation)MILK_COOLDOWN, Integer.class);
    }

    @SubscribeEvent
    public void onPlayerJoinWorld(PlayerEvent.PlayerLoggedInEvent event) {
        if (!this.isEnabled() || event.getEntity().m_9236_().f_46443_) {
            return;
        }
        for (Entity entity : ((ServerLevel)event.getEntity().m_9236_()).m_142646_().m_142273_()) {
            LivingEntity livingEntity;
            if (!(entity instanceof LivingEntity) || !ModNBTData.contains((Entity)(livingEntity = (LivingEntity)entity), (ResourceLocation)MILK_COOLDOWN)) continue;
            EntityModNBTDataSync.sync((LivingEntity)livingEntity, (ResourceLocation)MILK_COOLDOWN, Integer.class);
        }
    }

    @SubscribeEvent
    public void onBreed(BabyEntitySpawnEvent event) {
        Mob mob;
        if (!this.isEnabled() || !((mob = event.getParentA()) instanceof Animal)) {
            return;
        }
        Animal parentA = (Animal)mob;
        if (this.failBreeding(event, parentA)) {
            return;
        }
        this.twins(event, parentA);
        Livestock.consumeFeed((LivingEntity)parentA);
        Livestock.consumeFeed((LivingEntity)event.getParentB());
    }

    private boolean failBreeding(BabyEntitySpawnEvent event, Animal parentA) {
        ArrayList<Modifier> modifiersToApply = new ArrayList<Modifier>();
        LivestockDataReloadListener.LIVESTOCK_DATA.stream().filter(data -> data.matches((Entity)parentA)).forEach(data -> modifiersToApply.addAll(data.breedingFailChanceModifiers));
        float failChance = Modifier.applyModifiers(0.0f, modifiersToApply, parentA.m_9236_(), parentA.m_20183_(), (LivingEntity)parentA);
        if (failChance <= 0.0f) {
            return false;
        }
        if (failChance >= 1.0f || parentA.m_217043_().m_188501_() < failChance) {
            event.setCanceled(true);
            return true;
        }
        return false;
    }

    private void twins(BabyEntitySpawnEvent event, Animal parentA) {
        ArrayList<Modifier> modifiersToApplyTwins = new ArrayList<Modifier>();
        LivestockDataReloadListener.LIVESTOCK_DATA.stream().filter(data -> data.matches((Entity)parentA)).forEach(data -> modifiersToApplyTwins.addAll(data.twinsChanceModifiers));
        float twinsChance = Modifier.applyModifiers(0.0f, modifiersToApplyTwins, parentA.m_9236_(), parentA.m_20183_(), (LivingEntity)parentA);
        if (parentA.m_217043_().m_188501_() < twinsChance && event.getParentB() instanceof Animal) {
            parentA.m_27563_((ServerLevel)parentA.m_9236_(), (Animal)event.getParentB());
        }
    }

    public static boolean isBreedingDisabled(Animal animal) {
        return Feature.isEnabled(Livestock.class) && preventBreeding != false && animal.m_6095_().m_204039_(PREVENT_BREEDING);
    }

    static {
        OLD_AGE = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)InsaneSO.location("old_age"));
        chickenFromEggChance = 8;
        fluidCooldown = 1200;
        preventBreeding = true;
        autoBreed = true;
        wellFed$duration = 60;
        wellFed$leftToFeedAgain = 30;
        wellFed$consumedOnBreed = 20;
        aging$enable = true;
        aging$dieOfOldAge = true;
        aging$stopAt = Age.ELDER;
        aging$stopAgingWithPoisonousPotato = true;
        aging$starvationDeath = false;
        dataPack = true;
    }

    public static enum Age {
        YOUNG,
        ADULT,
        ELDER;

    }
}

