/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.farming.livestock;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import insane96mcp.iguanatweaksreborn.module.farming.livestock.LivestockData;
import insane96mcp.iguanatweaksreborn.utils.ISOLogHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="iguanatweaksreborn")
public class LivestockDataReloadListener
extends SimpleJsonResourceReloadListener {
    public static List<LivestockData> LIVESTOCK_DATA;
    public static final LivestockDataReloadListener INSTANCE;
    private static final Gson GSON;

    public LivestockDataReloadListener() {
        super(GSON, "livestock_data");
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        ArrayList<LivestockData> list = new ArrayList<LivestockData>();
        for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
            try {
                ResourceLocation name = entry.getKey();
                String[] split = name.m_135815_().split("/");
                if (split[split.length - 1].startsWith("_")) continue;
                LivestockData livestockData = (LivestockData)GSON.fromJson(entry.getValue(), LivestockData.class);
                list.add(livestockData);
            }
            catch (JsonSyntaxException e) {
                ISOLogHelper.error("Parsing error loading Livestock Data %s: %s", entry.getKey(), e.getMessage());
            }
            catch (Exception e) {
                ISOLogHelper.error("Failed loading Livestock Data %s: %s", entry.getKey(), e.getMessage());
            }
        }
        LIVESTOCK_DATA = list;
        ISOLogHelper.info("Loaded %s Livestock Data", LIVESTOCK_DATA.size());
    }

    @NotNull
    public String m_7812_() {
        return "Livestock Data Listener";
    }

    static {
        GSON = new GsonBuilder().create();
        INSTANCE = new LivestockDataReloadListener();
    }
}

