/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.farming.plantsgrowth;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.reflect.TypeToken;
import insane96mcp.iguanatweaksreborn.modifier.Modifier;
import insane96mcp.insanelib.data.IdTagMatcher;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

@JsonAdapter(value=Serializer.class)
public class PlantGrowthMultiplier {
    public final IdTagMatcher block;
    private final float growthMultiplier;
    protected final List<Modifier> modifiers = new ArrayList<Modifier>();
    public static final Type LIST_TYPE = new TypeToken<ArrayList<PlantGrowthMultiplier>>(){}.getType();

    private PlantGrowthMultiplier(IdTagMatcher block, float growthMultiplier, List<Modifier> modifiers) {
        this.block = block;
        this.growthMultiplier = growthMultiplier;
        this.modifiers.addAll(modifiers);
    }

    public float getMultiplier(BlockState state, Level level, BlockPos pos) {
        if (!this.block.matchesBlock(state)) {
            return 1.0f;
        }
        return Modifier.applyModifiers(this.growthMultiplier, this.modifiers, level, pos, null);
    }

    public static class Serializer
    implements JsonDeserializer<PlantGrowthMultiplier> {
        public PlantGrowthMultiplier deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jObject = json.getAsJsonObject();
            IdTagMatcher block = (IdTagMatcher)context.deserialize(jObject.get("block"), IdTagMatcher.class);
            float multiplier = GsonHelper.m_13820_((JsonObject)jObject, (String)"growth_multiplier", (float)1.0f);
            List<Modifier> modifiers = Modifier.deserializeList(jObject, "modifiers", context);
            return new PlantGrowthMultiplier(block, multiplier, modifiers);
        }
    }
}

