/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.farming.plantsgrowth;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import insane96mcp.iguanatweaksreborn.module.farming.plantsgrowth.PlantGrowthMultiplier;
import insane96mcp.iguanatweaksreborn.utils.ISOLogHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="iguanatweaksreborn")
public class PlantsGrowthReloadListener
extends SimpleJsonResourceReloadListener {
    public static List<PlantGrowthMultiplier> GROWTH_MULTIPLIERS = new ArrayList<PlantGrowthMultiplier>();
    public static final PlantsGrowthReloadListener INSTANCE;
    private static final Gson GSON;

    public PlantsGrowthReloadListener() {
        super(GSON, "plant_growth_modifiers");
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        GROWTH_MULTIPLIERS.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
            try {
                ResourceLocation name = entry.getKey();
                String[] split = name.m_135815_().split("/");
                if (split[split.length - 1].startsWith("_")) continue;
                PlantGrowthMultiplier plantGrowthMultiplier = (PlantGrowthMultiplier)GSON.fromJson(entry.getValue(), PlantGrowthMultiplier.class);
                GROWTH_MULTIPLIERS.add(plantGrowthMultiplier);
            }
            catch (JsonSyntaxException e) {
                ISOLogHelper.error("Parsing error loading Plant Growth Multipliers %s: %s", entry.getKey(), e.getMessage());
            }
            catch (Exception e) {
                ISOLogHelper.error("Failed loading Plant Growth Multipliers %s: %s", entry.getKey(), e.getMessage());
            }
        }
        ISOLogHelper.info("Loaded %s Plant Growth Multipliers", GROWTH_MULTIPLIERS.size());
    }

    @NotNull
    public String m_7812_() {
        return "Plants Growth Reload Listener";
    }

    static {
        GSON = new GsonBuilder().create();
        INSTANCE = new PlantsGrowthReloadListener();
    }
}

