/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.hungerhealth;

import insane96mcp.iguanatweaksreborn.module.combat.bows.Bows;
import insane96mcp.iguanatweaksreborn.network.NetworkHandler;
import insane96mcp.iguanatweaksreborn.network.message.ExhaustionSync;
import insane96mcp.iguanatweaksreborn.network.message.SaturationSync;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.event.PlayerExhaustionEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.NetworkDirection;

@LoadFeature(module="iguanatweaksreborn:hunger_health", description="Make the player consume more hunger with different actions. Please note that even if hunger is disabled, exhaustion will still be user by Tiredness.")
public class Exhaustion
extends Feature {
    @Config(min=0.0, max=128.0, description="When you break a block you'll get exhaustion equal to the block hardness multiplied by this value. Setting this to 0 will default to the vanilla exhaustion (0.005). (It's not affected by the Global Hardness Features)")
    public static Double blockBreakExhaustionMultiplier = 0.0;
    @Config(min=0.0, max=128.0, description="When breaking block you'll get exhaustion every tick during the breaking.")
    public static Double exhaustionOnBlockBreaking = 0.005;
    @Config(min=0.0, max=128.0, description="Every second the player will get this exhaustion.")
    public static Double passiveExhaustion = 0.005;
    @Config(min=0.0, max=128.0, description="Every tick of the player's rowing will get this exhaustion.")
    public static Double rowingExhaustion = 0.005;
    @Config(min=0.0, max=128.0, description="Every tick of the player's charging an arrow on a bow/crossbow will get this exhaustion.")
    public static Double bowChargeExhaustion = 0.005;
    @Config(description="When affected by the hunger effect, exhaustion will be doubled per level of the effect")
    public static Boolean effectiveHunger = true;
    private static final Map<UUID, Float> lastExhaustionLevels = new HashMap<UUID, Float>();
    private static final Map<UUID, Float> lastSaturationLevels = new HashMap<UUID, Float>();

    @SubscribeEvent
    public void breakExhaustion(BlockEvent.BreakEvent event) {
        if (!this.isEnabled() || blockBreakExhaustionMultiplier == 0.0) {
            return;
        }
        ServerLevel world = (ServerLevel)event.getLevel();
        BlockState state = world.m_8055_(event.getPos());
        double hardness = state.m_60800_((BlockGetter)event.getLevel(), event.getPos());
        double exhaustion = hardness * blockBreakExhaustionMultiplier - (double)0.005f;
        exhaustion = Math.max(exhaustion, 0.0);
        event.getPlayer().m_36399_((float)exhaustion);
    }

    @SubscribeEvent
    public void onBreakingBlock(PlayerEvent.BreakSpeed event) {
        if (!this.isEnabled() || exhaustionOnBlockBreaking == 0.0) {
            return;
        }
        event.getEntity().m_36399_(exhaustionOnBlockBreaking.floatValue());
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!this.isEnabled() || event.phase != TickEvent.Phase.END || event.player.m_9236_().f_46443_) {
            return;
        }
        if (passiveExhaustion > 0.0 && event.player.f_19797_ % 20 == 0) {
            event.player.m_36399_(passiveExhaustion.floatValue());
        }
        if (rowingExhaustion > 0.0 && event.player.m_20202_() != null && event.player.f_20902_ != 0.0f) {
            event.player.m_36399_(rowingExhaustion.floatValue());
        }
        if (bowChargeExhaustion > 0.0 && (event.player.m_21211_().m_150930_(Items.f_42411_) || event.player.m_21211_().m_150930_(Items.f_42717_) || event.player.m_21211_().m_150930_((Item)Bows.SHORTBOW.get()))) {
            event.player.m_36399_(bowChargeExhaustion.floatValue());
        }
    }

    @SubscribeEvent
    public void onExhaustion(PlayerExhaustionEvent event) {
        if (!(this.isEnabled() && effectiveHunger.booleanValue() && event.getEntity().m_21023_(MobEffects.f_19612_))) {
            return;
        }
        int amp = event.getEntity().m_21124_(MobEffects.f_19612_).m_19564_() + 1;
        event.setAmount(event.getAmount() * ((float)amp * 1.0f + 1.0f));
    }

    @SubscribeEvent
    public void onLivingTickEvent(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        Float lastSaturationLevel = lastSaturationLevels.get(player.m_20148_());
        if (lastSaturationLevel == null || lastSaturationLevel.floatValue() != player.m_36324_().m_38722_()) {
            SaturationSync msg = new SaturationSync(player.m_36324_().m_38722_());
            NetworkHandler.CHANNEL.sendTo((Object)msg, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            lastSaturationLevels.put(player.m_20148_(), Float.valueOf(player.m_36324_().m_38722_()));
        }
        Float lastExhaustionLevel = lastExhaustionLevels.get(player.m_20148_());
        float exhaustionLevel = player.m_36324_().f_38698_;
        if (lastExhaustionLevel == null || Math.abs(lastExhaustionLevel.floatValue() - exhaustionLevel) >= 0.01f) {
            ExhaustionSync msg = new ExhaustionSync(exhaustionLevel);
            NetworkHandler.CHANNEL.sendTo((Object)msg, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            lastExhaustionLevels.put(player.m_20148_(), Float.valueOf(exhaustionLevel));
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!(event.getEntity() instanceof ServerPlayer)) {
            return;
        }
        lastExhaustionLevels.remove(event.getEntity().m_20148_());
        lastSaturationLevels.remove(event.getEntity().m_20148_());
    }
}

