/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.hungerhealth.fooddrinks;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.reflect.TypeToken;
import com.mojang.datafixers.util.Pair;
import insane96mcp.iguanatweaksreborn.data.ISOMobEffectInstance;
import insane96mcp.iguanatweaksreborn.module.hungerhealth.fooddrinks.FoodDrinks;
import insane96mcp.insanelib.data.IdTagMatcher;
import insane96mcp.insanelib.util.LogHelper;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;

@JsonAdapter(value=Serializer.class)
public class CustomFoodProperties {
    IdTagMatcher food;
    public int nutrition = -1;
    public float saturationModifier = -1.0f;
    public int eatingTime = -1;
    public Boolean fastEating = null;
    public Boolean canAlwaysEat = null;
    public List<Pair<Supplier<ISOMobEffectInstance>, Float>> effects = null;
    public static final Type LIST_TYPE = new TypeToken<ArrayList<CustomFoodProperties>>(){}.getType();

    public CustomFoodProperties(IdTagMatcher food) {
        this.food = food;
    }

    public List<Pair<ISOMobEffectInstance, Float>> getEffects() {
        return this.effects.stream().map(pair -> Pair.of((Object)(pair.getFirst() != null ? (ISOMobEffectInstance)((Supplier)pair.getFirst()).get() : null), (Object)((Float)pair.getSecond()))).collect(Collectors.toList());
    }

    public void apply() {
        List items = FoodDrinks.getAllItems((IdTagMatcher)this.food, (boolean)false);
        for (Item item : items) {
            if (item.m_41473_() == null) {
                LogHelper.warn((String)"Item %s in Custom Food Properties is not edible", (Object[])new Object[]{item});
                return;
            }
            FoodProperties food = item.m_41473_();
            if (this.nutrition >= 0) {
                food.f_38723_ = this.nutrition;
            }
            if (this.saturationModifier >= 0.0f) {
                food.f_38724_ = this.saturationModifier;
            }
            if (this.fastEating != null) {
                food.f_38727_ = this.fastEating;
            }
            if (this.canAlwaysEat == null) continue;
            food.f_38726_ = this.canAlwaysEat;
        }
    }

    public String toString() {
        return "FoodValue{food: %s, nutrition: %s, saturation_modifier: %s, eating_time: %s, fast_eating: %s, can_always_eat: %s, effects: %s}".formatted(this.food, this.nutrition, Float.valueOf(this.saturationModifier), this.eatingTime, this.fastEating, this.canAlwaysEat, this.effects);
    }

    public static class Serializer
    implements JsonDeserializer<CustomFoodProperties>,
    JsonSerializer<CustomFoodProperties> {
        public CustomFoodProperties deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jObject = json.getAsJsonObject();
            IdTagMatcher food = (IdTagMatcher)context.deserialize(jObject.get("food"), IdTagMatcher.class);
            Builder builder = new Builder(food).nutrition(GsonHelper.m_13824_((JsonObject)jObject, (String)"nutrition", (int)-1)).saturationModifier(GsonHelper.m_13820_((JsonObject)jObject, (String)"saturation_modifier", (float)-1.0f)).setEatingTime(GsonHelper.m_13824_((JsonObject)jObject, (String)"eating_time", (int)-1));
            if (jObject.has("fast_eating")) {
                builder.fastEating(GsonHelper.m_13912_((JsonObject)jObject, (String)"fast_eating"));
            }
            if (jObject.has("can_always_eat")) {
                builder.alwaysEat(GsonHelper.m_13912_((JsonObject)jObject, (String)"can_always_eat"));
            }
            if (jObject.has("effects")) {
                JsonArray jArray = jObject.getAsJsonArray("effects");
                if (jArray.isEmpty()) {
                    builder.noEffects();
                } else {
                    jArray.forEach(element -> {
                        float chance = 1.0f;
                        if (element.getAsJsonObject().has("chance")) {
                            chance = GsonHelper.m_13915_((JsonObject)element.getAsJsonObject(), (String)"chance");
                        }
                        builder.addEffect((ISOMobEffectInstance)context.deserialize(element, ISOMobEffectInstance.class), chance);
                    });
                }
            }
            return builder.build();
        }

        public JsonElement serialize(CustomFoodProperties src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.add("food", context.serialize((Object)src.food));
            if (src.nutrition >= 0) {
                jsonObject.addProperty("nutrition", (Number)src.nutrition);
            }
            if (src.saturationModifier >= 0.0f) {
                jsonObject.addProperty("saturation_modifier", (Number)Float.valueOf(src.saturationModifier));
            }
            if (src.eatingTime >= 0) {
                jsonObject.addProperty("eating_time", (Number)src.eatingTime);
            }
            if (src.fastEating != null) {
                jsonObject.addProperty("fast_eating", src.fastEating);
            }
            if (src.canAlwaysEat != null) {
                jsonObject.addProperty("can_always_eat", src.canAlwaysEat);
            }
            if (src.effects != null) {
                JsonArray effects = new JsonArray();
                src.getEffects().forEach(pair -> {
                    JsonElement effect = context.serialize(pair.getFirst());
                    if (((Float)pair.getSecond()).floatValue() != 1.0f) {
                        ((JsonObject)effect).addProperty("chance", (Number)pair.getSecond());
                    }
                    effects.add(effect);
                });
                jsonObject.add("effects", (JsonElement)effects);
            }
            return jsonObject;
        }
    }

    public static class Builder {
        CustomFoodProperties customFoodProperties;

        public Builder(IdTagMatcher food) {
            this.customFoodProperties = new CustomFoodProperties(food);
        }

        public CustomFoodProperties build() {
            return this.customFoodProperties;
        }

        public Builder nutrition(int nutrition) {
            this.customFoodProperties.nutrition = nutrition;
            return this;
        }

        public Builder saturationModifier(float saturationModifier) {
            this.customFoodProperties.saturationModifier = saturationModifier;
            return this;
        }

        public Builder setEatingTime(int eatingTime) {
            this.customFoodProperties.eatingTime = eatingTime;
            return this;
        }

        public Builder fastEating(boolean fastEating) {
            this.customFoodProperties.fastEating = fastEating;
            return this;
        }

        public Builder alwaysEat(boolean alwaysEat) {
            this.customFoodProperties.canAlwaysEat = alwaysEat;
            return this;
        }

        public Builder noEffects() {
            this.customFoodProperties.effects = new ArrayList<Pair<Supplier<ISOMobEffectInstance>, Float>>();
            return this;
        }

        public Builder addEffect(ISOMobEffectInstance mobEffectInstance) {
            return this.addEffect(mobEffectInstance, 1.0f);
        }

        public Builder addEffect(ISOMobEffectInstance mobEffectInstance, float chance) {
            if (this.customFoodProperties.effects == null) {
                this.customFoodProperties.effects = new ArrayList<Pair<Supplier<ISOMobEffectInstance>, Float>>();
            }
            this.customFoodProperties.effects.add((Pair<Supplier<ISOMobEffectInstance>, Float>)Pair.of(() -> mobEffectInstance, (Object)Float.valueOf(chance)));
            return this;
        }
    }
}

