/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.hungerhealth.healthregen;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.MinMax;
import insane96mcp.insanelib.util.MCUtils;
import insane96mcp.insanelib.util.ModNBTData;
import java.text.DecimalFormat;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;

@LoadFeature(module="iguanatweaksreborn:hunger_health", name="Health Regen & Hunger", description="Makes Health regen work differently, similar to Combat Test snapshots. Can be customized. Hunger related stuff doesn't work (for obvious reasons) if No Hunger feature is enabled")
public class HealthRegenHunger
extends Feature {
    public static final UUID SPRINT_PENALTY_UUID = UUID.fromString("a6d61c15-b60f-4503-b206-247c4690c436");
    public static ResourceLocation PASSIVE_REGEN_TICK;
    private static final int PASSIVE_REGEN_TICK_RATE = 10;
    private static final int FOOD_REGEN_TICK_RATE = 10;
    @Config(description="If true, Passive Regeneration is enabled")
    public static Boolean passiveHealthRegen$enable;
    @Config(description="Min represents how many ticks the regeneration of 1 HP takes when health is 100%, Max how many ticks when health is 0%")
    public static MinMax passiveHealthRegen$speed;
    @Config(min=0.0, description="Sets how many ticks between the health regeneration happens (vanilla is 80).")
    public static Integer healthRegenSpeed;
    @Config(min=0.0, description="Sets how much hunger the player must have to regen health (vanilla is 17).")
    public static Integer regenWhenFoodAbove;
    @Config(description="Set to true to disable the health regen boost given when max hunger and saturation (false in Vanilla).")
    public static Boolean disableSaturationRegenBoost;
    @Config(description="Set to true to consume Hunger only (and not saturation) when regenerating health (false for Vanilla).")
    public static Boolean consumeHungerOnly;
    @Config(min=0.0, max=40.0, description="Vanilla consumes 1 saturation or hunger whenever Exhaustion reaches 4.0. You can change that value with this config option. NOTE that Minecraft caps this value to 40.")
    public static Double maxExhaustion;
    @Config(min=0.0, max=1.0, description="If 'Consume Hunger Only' is true then this is the chance to consume an hunger whenever the player is healed (vanilla ignores this; Combat Test has this set to 0.5).")
    public static Double hungerConsumptionChance;
    @Config(min=0.0, description="Sets how many ticks between starve damage happens (vanilla is 80).")
    public static Integer starve$speed;
    @Config(min=0.0, description="Set how much damage is dealt when starving (vanilla is 1).")
    public static Integer starve$damage;
    @Config(min=0.0, max=20.0, description="The player will start starving at this hunger (Vanilla is 0)")
    public static Integer starve$atHunger;
    @Config(description="If below 'Starve at Hunger' player will starve 2x faster for each hunger point below 'Starve at Hunger'.")
    public static Boolean starve$fasterWhenReallyHungry;
    @Config(min=0.0, max=20.0, description="Player can only sprint when have at least this much hunger. Vanilla is 7")
    public static Integer sprint$minHunger;
    @Config(min=0.0, max=20.0, description="Movement speed penalty when below this hunger")
    public static Integer sprint$speedPenaltyBelowHunger;
    @Config(min=0.0, description="How much less movement speed per hunger below 'Speed Penalty below hunger' sprinting players have")
    public static Double sprint$speedReductionEachHunger;
    @Config(description="If enabled, peaceful difficulty no longer heals and fulfills the player")
    public static Boolean peacefulHunger;
    @Config(min=0.0, max=1.0, description="When eating you'll get healed by this percentage of 'hunger + saturation' restored.")
    public static Double foodHealMultiplier;

    public HealthRegenHunger(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
        PASSIVE_REGEN_TICK = this.createDataKey("passive_health_regen");
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!this.isEnabled() || event.player.m_9236_().f_46443_ || event.phase.equals((Object)TickEvent.Phase.START)) {
            return;
        }
        if (event.player.f_19797_ % 10 == 1 && passiveHealthRegen$enable.booleanValue() && event.player.m_36325_()) {
            HealthRegenHunger.incrementPassiveRegenTick(event.player);
            int passiveRegen = HealthRegenHunger.getPassiveRegenSpeed(event.player);
            if (HealthRegenHunger.getPassiveRegenTick(event.player) > passiveRegen) {
                float heal = 1.0f;
                event.player.m_5634_(heal);
                HealthRegenHunger.resetPassiveRegenTick(event.player);
            }
        }
    }

    private static int getPassiveRegenSpeed(Player player) {
        float healthPerc = 1.0f - player.m_21223_() / player.m_21233_();
        float ticks = (float)((HealthRegenHunger.passiveHealthRegen$speed.max - HealthRegenHunger.passiveHealthRegen$speed.min) * (double)healthPerc + HealthRegenHunger.passiveHealthRegen$speed.min);
        if (player.m_9236_().m_46791_().equals((Object)Difficulty.HARD)) {
            ticks *= 1.5f;
        }
        return (int)ticks;
    }

    private static int getPassiveRegenTick(Player player) {
        return (Integer)ModNBTData.get((Entity)player, (ResourceLocation)PASSIVE_REGEN_TICK, Integer.class);
    }

    private static void incrementPassiveRegenTick(Player player) {
        ModNBTData.put((Entity)player, (ResourceLocation)PASSIVE_REGEN_TICK, (Object)(HealthRegenHunger.getPassiveRegenTick(player) + 10));
    }

    private static void resetPassiveRegenTick(Player player) {
        ModNBTData.put((Entity)player, (ResourceLocation)PASSIVE_REGEN_TICK, (Object)0);
    }

    @SubscribeEvent
    public void onPlayerEat(LivingEntityUseItemEvent.Finish event) {
        if (!this.isEnabled() || event.getItem().m_41720_().m_41473_() == null || !(event.getEntity() instanceof Player) || event.getEntity().m_9236_().f_46443_) {
            return;
        }
        this.healOnEat(event);
    }

    public void healOnEat(LivingEntityUseItemEvent.Finish event) {
        if (foodHealMultiplier == 0.0) {
            return;
        }
        FoodProperties food = event.getItem().m_41720_().getFoodProperties(event.getItem(), event.getEntity());
        double heal = (double)MCUtils.getFoodEffectiveness((FoodProperties)food) * foodHealMultiplier;
        event.getEntity().m_5634_((float)heal);
    }

    public static boolean tickFoodStats(FoodData foodStats, Player player) {
        if (!Feature.isEnabled(HealthRegenHunger.class)) {
            return false;
        }
        Difficulty difficulty = player.m_9236_().m_46791_();
        foodStats.f_38700_ = foodStats.m_38702_();
        if ((double)foodStats.f_38698_ > maxExhaustion) {
            foodStats.f_38698_ = (float)((double)foodStats.f_38698_ - maxExhaustion);
            if (foodStats.f_38697_ > 0.0f) {
                foodStats.f_38697_ = Math.max(foodStats.f_38697_ - 1.0f, 0.0f);
            } else if (peacefulHunger.booleanValue() || difficulty != Difficulty.PEACEFUL) {
                foodStats.f_38696_ = Math.max(foodStats.f_38696_ - 1, 0);
            }
        }
        HealthRegenHunger.tick(foodStats, player, difficulty);
        return true;
    }

    public static boolean isPlayerHurt(Player player) {
        return player.m_21223_() > 0.0f && player.m_21223_() <= player.m_21233_() - 1.0f;
    }

    private static void tick(FoodData foodStats, Player player, Difficulty difficulty) {
        boolean naturalRegen;
        boolean bl = naturalRegen = player.m_9236_().m_46469_().m_46207_(GameRules.f_46139_) && !ModList.get().isLoaded("nohunger");
        if (naturalRegen && foodStats.f_38697_ > 0.0f && HealthRegenHunger.isPlayerHurt(player) && foodStats.f_38696_ >= 20 && !disableSaturationRegenBoost.booleanValue()) {
            ++foodStats.f_38699_;
            if (foodStats.f_38699_ >= 10) {
                float f = Math.min(foodStats.f_38697_, 6.0f);
                player.m_5634_(f / 6.0f);
                foodStats.m_38703_(f);
                foodStats.f_38699_ = 0;
            }
        } else if (naturalRegen && foodStats.f_38696_ > regenWhenFoodAbove && HealthRegenHunger.isPlayerHurt(player)) {
            ++foodStats.f_38699_;
            if (foodStats.f_38699_ >= HealthRegenHunger.getRegenSpeed(player)) {
                player.m_5634_(1.0f);
                if (consumeHungerOnly.booleanValue()) {
                    if (player.m_9236_().m_213780_().m_188500_() < hungerConsumptionChance) {
                        HealthRegenHunger.addHunger(foodStats, -1);
                    }
                } else {
                    foodStats.m_38703_(6.0f);
                }
                foodStats.f_38699_ = 0;
            }
        } else if (foodStats.f_38696_ <= starve$atHunger) {
            ++foodStats.f_38699_;
            int actualStarveSpeed = starve$speed;
            if (starve$fasterWhenReallyHungry.booleanValue() && foodStats.f_38696_ < starve$atHunger) {
                int pow = Mth.m_14040_((int)(foodStats.f_38696_ - starve$atHunger));
                actualStarveSpeed >>= pow;
            }
            if (foodStats.f_38699_ >= actualStarveSpeed) {
                if (player.m_21223_() > 10.0f || difficulty == Difficulty.HARD || player.m_21223_() > 1.0f && difficulty == Difficulty.NORMAL) {
                    player.m_6469_(player.m_269291_().m_269064_(), (float)starve$damage.intValue());
                }
                foodStats.f_38699_ = 0;
            }
        } else if (!ModList.get().isLoaded("nohunger")) {
            foodStats.f_38699_ = 0;
        }
    }

    public static void addHunger(FoodData foodStats, int hunger) {
        foodStats.f_38696_ = Mth.m_14045_((int)(foodStats.f_38696_ + hunger), (int)0, (int)20);
    }

    private static int getRegenSpeed(Player player) {
        return healthRegenSpeed;
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void debugScreen(CustomizeGuiOverlayEvent.DebugText event) {
        if (!this.isEnabled() || ModList.get().isLoaded("nohunger")) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer playerEntity = mc.f_91074_;
        if (playerEntity == null) {
            return;
        }
        if (mc.f_91066_.f_92063_ && !mc.m_91299_()) {
            FoodData foodStats = playerEntity.m_36324_();
            event.getLeft().add(String.format("Hunger: %d, Saturation: %s, Exhaustion: %s", foodStats.f_38696_, new DecimalFormat("#.#").format(foodStats.f_38697_), new DecimalFormat("0.00").format(foodStats.f_38698_)));
        }
    }

    static {
        passiveHealthRegen$enable = false;
        passiveHealthRegen$speed = new MinMax(120.0, 3600.0);
        healthRegenSpeed = 40;
        regenWhenFoodAbove = 6;
        disableSaturationRegenBoost = true;
        consumeHungerOnly = true;
        maxExhaustion = 6.0;
        hungerConsumptionChance = 0.5;
        starve$speed = 160;
        starve$damage = 1;
        starve$atHunger = 1;
        starve$fasterWhenReallyHungry = true;
        sprint$minHunger = 1;
        sprint$speedPenaltyBelowHunger = 7;
        sprint$speedReductionEachHunger = 0.025;
        peacefulHunger = true;
        foodHealMultiplier = 0.0;
    }
}

