/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.items;

import insane96mcp.iguanatweaksreborn.data.generator.ISOItemTagsProvider;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="iguanatweaksreborn:items", description="Make items not able to mine / attack")
public class DisabledItems
extends Feature {
    public static final TagKey<Item> NO_DAMAGE = ISOItemTagsProvider.create("no_damage");
    public static final String NO_DAMAGE_ITEM_LANG = "iguanatweaksreborn.no_damage_item";
    public static final TagKey<Item> NO_MINING = ISOItemTagsProvider.create("no_mining");
    public static final String NO_MINING_ITEM_LANG = "iguanatweaksreborn.no_mining_item";
    public static final TagKey<Item> NO_EQUIP = ISOItemTagsProvider.create("no_equip");
    public static final String NO_EQUIP_ITEM_LANG = "iguanatweaksreborn.no_equip_item";
    public static final TagKey<Item> DISABLED = ISOItemTagsProvider.create("disabled");
    public static final String DISABLED_ITEM_LANG = "iguanatweaksreborn.disabled_item";
    @Config(description="If set to true items in the 'no_damage', 'no_efficiency', 'no_equip' and 'disabled' item tags will get a tooltip.")
    public static Boolean addTooltip = true;

    public DisabledItems(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @SubscribeEvent
    public void processAttacking(LivingHurtEvent event) {
        Entity entity;
        if (!this.isEnabled() || !((entity = event.getSource().m_7640_()) instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        ItemStack stack = player.m_21205_();
        if (stack.m_204117_(NO_DAMAGE) || stack.m_204117_(DISABLED)) {
            event.setCanceled(true);
            if (stack.m_204117_(NO_DAMAGE)) {
                player.m_5661_((Component)Component.m_237115_((String)NO_DAMAGE_ITEM_LANG), true);
            }
        }
    }

    @SubscribeEvent
    public void processMining(PlayerEvent.BreakSpeed event) {
        if (!this.isEnabled()) {
            return;
        }
        Player player = event.getEntity();
        ItemStack stack = player.m_21205_();
        if (stack.m_204117_(NO_MINING) || stack.m_204117_(DISABLED)) {
            event.setCanceled(true);
            if (stack.m_204117_(NO_MINING)) {
                event.getEntity().m_5661_((Component)Component.m_237115_((String)NO_MINING_ITEM_LANG), true);
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void processInput(InputEvent.InteractionKeyMappingTriggered event) {
        if (!this.isEnabled()) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ItemStack stack = player.m_21120_(event.getHand());
        if (stack.m_204117_(DISABLED)) {
            event.setCanceled(true);
            event.setSwingHand(false);
            Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237115_((String)DISABLED_ITEM_LANG), true);
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!this.isEnabled() || event.player.m_9236_().f_46443_ || event.phase == TickEvent.Phase.START || event.player.f_19797_ % 20 != event.player.m_19879_() % 20) {
            return;
        }
        for (ItemStack stack : event.player.m_6168_()) {
            if (stack.m_41619_() || !stack.m_204117_(NO_EQUIP) && !stack.m_204117_(DISABLED)) continue;
            event.player.m_9236_().m_6269_(null, (Entity)event.player, SoundEvents.f_215675_, SoundSource.PLAYERS, 0.7f, 2.0f);
            EquipmentSlot equipmentSlot = Player.m_147233_((ItemStack)stack);
            if (!(stack.m_41720_() instanceof Equipable)) continue;
            event.player.m_8061_(equipmentSlot, ItemStack.f_41583_);
            if (event.player.m_36356_(stack)) continue;
            event.player.m_36176_(stack, true);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onTooltip(ItemTooltipEvent event) {
        if (!this.isEnabled() || !addTooltip.booleanValue()) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (stack.m_204117_(NO_DAMAGE)) {
            event.getToolTip().add(Component.m_237115_((String)NO_DAMAGE_ITEM_LANG).m_130940_(ChatFormatting.DARK_GRAY));
        }
        if (stack.m_204117_(NO_MINING)) {
            event.getToolTip().add(Component.m_237115_((String)NO_MINING_ITEM_LANG).m_130940_(ChatFormatting.DARK_GRAY));
        }
        if (stack.m_204117_(NO_EQUIP)) {
            event.getToolTip().add(Component.m_237115_((String)NO_EQUIP_ITEM_LANG).m_130940_(ChatFormatting.DARK_GRAY));
        }
        if (stack.m_204117_(DISABLED)) {
            event.getToolTip().add(Component.m_237115_((String)DISABLED_ITEM_LANG).m_130940_(ChatFormatting.DARK_GRAY));
        }
    }
}

