/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.items;

import insane96mcp.iguanatweaksreborn.data.generator.ISOItemTagsProvider;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.event.HurtItemStackEvent;
import insane96mcp.insanelib.util.MCUtils;
import insane96mcp.insanelib.util.MathHelper;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="iguanatweaksreborn:items", description="Wooden items have bonuses when used in sunlight.", enabledByDefault=false)
public class EcologicWood
extends Feature {
    public static final TagKey<Item> WOODEN_HAND_EQUIPMENT = ISOItemTagsProvider.create("equipment/hand/wooden");
    public static final TagKey<Item> WOODEN_SHIELD = ISOItemTagsProvider.create("equipment/shield/wooden");
    public static final UUID ATTACK_SPEED_MODIFIER_UUID = UUID.fromString("435317e9-0146-4f1b-bc21-67f466ee5f9c");
    @Config(min=0.0, max=1.0, description="Chance for the wooden item to not consume durability when >= 'Max sunlight'.")
    public static Double chanceAtMaxSunlight = 0.5;
    @Config(description="Bonus attack speed when >= 'Max sunlight'.")
    public static Double bonusAttackSpeed = 0.2;
    @Config(description="Percentage efficiency bonus when >= 'Max sunlight'.")
    public static Double bonusEfficiency = 1.0;
    @Config(description="Lower cooldown by this many ticks when >= 'Max sunlight'.")
    public static Double shieldCooldownReduction = 10.0;
    @Config(min=0.0, max=15.0)
    public static Integer maxSunlight = 12;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void processItemDamaging(HurtItemStackEvent event) {
        if (!this.isEnabled() || event.getPlayer() == null || !event.getStack().m_204117_(WOODEN_HAND_EQUIPMENT) && !event.getStack().m_204117_(WOODEN_SHIELD)) {
            return;
        }
        float skyLightRatio = EcologicWood.getCalculatedSkyLightRatio((Entity)event.getPlayer());
        float ratio = 1.0f - chanceAtMaxSunlight.floatValue() * skyLightRatio;
        float amount = (float)event.getAmount() * ratio;
        event.setAmount(MathHelper.getAmountWithDecimalChance((RandomSource)event.getRandom(), (float)amount));
    }

    @SubscribeEvent
    public void addAttackSpeed(LivingEvent.LivingTickEvent event) {
        if (!this.isEnabled() || bonusAttackSpeed == 0.0 || event.getEntity().f_19797_ % 2 != 1) {
            return;
        }
        Attribute attr = Attributes.f_22283_;
        AttributeInstance attributeInstance = event.getEntity().m_21051_(attr);
        if (attributeInstance == null) {
            return;
        }
        float calculatedSkyLightRatio = EcologicWood.getCalculatedSkyLightRatio((Entity)event.getEntity());
        float amount = bonusAttackSpeed.floatValue() * calculatedSkyLightRatio;
        AttributeModifier modifier = attributeInstance.m_22111_(ATTACK_SPEED_MODIFIER_UUID);
        if (!event.getEntity().m_21205_().m_204117_(WOODEN_HAND_EQUIPMENT) || amount == 0.0f) {
            attributeInstance.m_22120_(ATTACK_SPEED_MODIFIER_UUID);
            return;
        }
        if (modifier != null) {
            return;
        }
        MCUtils.applyModifier((LivingEntity)event.getEntity(), (Attribute)attr, (UUID)ATTACK_SPEED_MODIFIER_UUID, (String)"Ecologic wood boost", (double)amount, (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_BASE, (boolean)false);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEfficiency(PlayerEvent.BreakSpeed event) {
        if (!(this.isEnabled() && bonusEfficiency != 0.0 && event.getEntity().m_21205_().m_204117_(WOODEN_HAND_EQUIPMENT) && event.getEntity().m_21205_().m_41735_(event.getState()))) {
            return;
        }
        float calculatedSkyLightRatio = EcologicWood.getCalculatedSkyLightRatio((Entity)event.getEntity());
        float efficiencyMult = bonusEfficiency.floatValue() * calculatedSkyLightRatio;
        if (efficiencyMult == 0.0f) {
            return;
        }
        event.setNewSpeed(event.getOriginalSpeed() * (1.0f + efficiencyMult));
    }

    public static float getCalculatedSkyLight(Entity entity) {
        return EcologicWood.getCalculatedSkyLight(entity.m_9236_(), entity.m_20183_());
    }

    public static float getCalculatedSkyLight(Level level, BlockPos pos) {
        if (!level.m_46461_() || level.m_46470_()) {
            return 0.0f;
        }
        float skyLight = level.m_45517_(LightLayer.SKY, pos) - level.m_7445_();
        if (level.m_46471_()) {
            skyLight /= 3.0f;
        }
        return skyLight;
    }

    public static float getCalculatedSkyLightRatio(Entity entity) {
        return EcologicWood.getCalculatedSkyLightRatio(entity.m_9236_(), entity.m_20183_());
    }

    public static float getCalculatedSkyLightRatio(Level level, BlockPos pos) {
        return Math.min(EcologicWood.getCalculatedSkyLight(level, pos), (float)maxSunlight.intValue()) / (float)maxSunlight.intValue();
    }
}

