/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.items;

import insane96mcp.iguanatweaksreborn.InsaneSO;
import insane96mcp.iguanatweaksreborn.data.generator.ISOItemTagsProvider;
import insane96mcp.iguanatweaksreborn.module.misc.Packs;
import insane96mcp.iguanatweaksreborn.network.message.StackSizesSync;
import insane96mcp.iguanatweaksreborn.utils.MCUtils;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.JsonFeature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;

@LoadFeature(module="iguanatweaksreborn:items", description="Make food, items and blocks less stackable. Items and Blocks are disabled by default. Changing stuff requires a /reload, but might require a Minecraft restart.")
public class StackSizes
extends Feature {
    public static final TagKey<Item> NO_STACK_SIZE_CHANGES = ISOItemTagsProvider.create("no_stack_size_changes");
    @Config(description="The formula to calculate the stack size of a food item. Variables as hunger, saturation_modifier, effectiveness as numbers and fast_food as boolean can be used. Set to empty to disable this. This is evaluated with EvalEx https://ezylang.github.io/EvalEx/concepts/parsing_evaluation.html.")
    public static String foodStackReductionFormula = "ROUND(MAX(64 / MAX(hunger, 1), 1), 0)";
    @Config(min=0.01, max=64.0, name="Item Stack Multiplier", description="Items max stack sizes (excluding blocks) will be multiplied by this value. Foods will be overridden by 'Food Stack Reduction' or 'Food Stack Multiplier' if are active. Setting to 1 will disable this feature.")
    public static Double itemStackMultiplier = 1.0;
    @Config(min=0.01, max=64.0, description="All the blocks max stack sizes will be multiplied by this value to increase / decrease them.")
    public static Double blockStackMultiplier = 1.0;
    @Config(description="Enables a data pack that changes some item stacks.")
    public static Boolean dataPack = true;
    private static final Object mutex = new Object();
    static HashMap<Item, Integer> originalStackSizes = new HashMap();

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        InsaneSO.addServerPack("item_stacks", "Insane's Survival Overhaul Item Stacks", () -> this.isEnabled() && Packs.disableAllDataPacks == false && dataPack != false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processStackSizes(boolean isClientSide) {
        Object object = mutex;
        synchronized (object) {
            StackSizes.resetStackSizes();
            StackSizes.processItemStackSizes(isClientSide);
            StackSizes.processBlockStackSizes(isClientSide);
            StackSizes.processFoodStackSizes(isClientSide);
        }
    }

    public static void resetStackSizes() {
        if (originalStackSizes.isEmpty()) {
            for (Item item : ForgeRegistries.ITEMS.getValues()) {
                originalStackSizes.put(item, item.f_41370_);
            }
        } else {
            for (Map.Entry<Item, Integer> entry : originalStackSizes.entrySet()) {
                entry.getKey().f_41370_ = entry.getValue();
            }
        }
    }

    public static void processItemStackSizes(boolean isClientSide) {
        if (itemStackMultiplier == 1.0) {
            return;
        }
        for (Map.Entry<Item, Integer> entry : originalStackSizes.entrySet()) {
            Item item = entry.getKey();
            if (item instanceof BlockItem || item.f_41370_ == 1 || JsonFeature.isItemInTag((Item)item, NO_STACK_SIZE_CHANGES, (boolean)isClientSide)) continue;
            double stackSize = (double)entry.getValue().intValue() * itemStackMultiplier;
            stackSize = Mth.m_14008_((double)stackSize, (double)1.0, (double)64.0);
            item.f_41370_ = (int)Math.round(stackSize);
        }
    }

    public static void processBlockStackSizes(boolean isClientSide) {
        if (blockStackMultiplier == 1.0) {
            return;
        }
        for (Map.Entry<Item, Integer> entry : originalStackSizes.entrySet()) {
            Item item = entry.getKey();
            if (!(item instanceof BlockItem) || item.f_41370_ == 1 || JsonFeature.isItemInTag((Item)item, NO_STACK_SIZE_CHANGES, (boolean)isClientSide)) continue;
            double stackSize = (double)entry.getValue().intValue() * blockStackMultiplier;
            stackSize = Mth.m_14008_((double)stackSize, (double)1.0, (double)64.0);
            item.f_41370_ = (int)Math.round(stackSize);
        }
    }

    public static void processFoodStackSizes(boolean isClientSide) {
        if (foodStackReductionFormula.isEmpty()) {
            return;
        }
        for (Map.Entry<Item, Integer> entry : originalStackSizes.entrySet()) {
            Item item = entry.getKey();
            if (item.m_41473_() == null || JsonFeature.isItemInTag((Item)item, NO_STACK_SIZE_CHANGES, (boolean)isClientSide)) continue;
            FoodProperties food = item.m_41473_();
            int stackSize = (int)MCUtils.computeFoodFormula(food, foodStackReductionFormula);
            item.f_41370_ = Mth.m_14045_((int)stackSize, (int)1, (int)64);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void syncFeatureConfig(OnDatapackSyncEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (event.getPlayer() == null) {
            event.getPlayerList().m_11314_().forEach(player -> StackSizesSync.sync(foodStackReductionFormula, itemStackMultiplier, blockStackMultiplier, player));
        } else {
            StackSizesSync.sync(foodStackReductionFormula, itemStackMultiplier, blockStackMultiplier, event.getPlayer());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void applyFeature(TagsUpdatedEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        StackSizes.processStackSizes(event.getUpdateCause() == TagsUpdatedEvent.UpdateCause.CLIENT_PACKET_RECEIVED);
    }

    @SubscribeEvent
    public void fixUnstackableItemsEat(LivingEntityUseItemEvent.Finish event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        ItemStack original = event.getItem();
        ItemStack result = event.getResultStack();
        if (original.m_41613_() <= 1 || result.m_41720_() != Items.f_42399_ && result.m_41720_() != Items.f_42446_ && result.m_41720_() != Items.f_42590_) {
            return;
        }
        event.setResultStack(original.m_255036_(original.m_41613_() - result.m_41613_()));
        if (!player.m_36356_(result)) {
            player.m_36176_(result, true);
        }
    }
}

