/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.items.misc;

import com.google.common.collect.Multimap;
import insane96mcp.iguanatweaksreborn.data.generator.ISOItemTagsProvider;
import insane96mcp.iguanatweaksreborn.event.ISOEventFactory;
import insane96mcp.iguanatweaksreborn.module.items.misc.ItemDefinition;
import insane96mcp.iguanatweaksreborn.module.items.misc.ItemDefinitionsReloadListener;
import insane96mcp.insanelib.InsaneLib;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.config.Config;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="iguanatweaksreborn:items", description="Control Items properties via data packs. Add more tooltips.")
public class MiscItem
extends Feature {
    public static final TagKey<Item> HAS_TOOLTIP = ISOItemTagsProvider.create("has_tooltip");
    public static final String TOOL_MINING_SPEED_LANG = "iguanatweaksreborn.tool_mining_speed";
    @Config(description="Tools get a mining speed tooltip.")
    public static Boolean miningSpeedTooltip = true;
    @Config(description="If enabled items in the iguanatweaksreborn:has_tooltip item tag will get a tooltip with the vanilla name + .tooltip (e.g. item.minecraft.arrow.tooltip)")
    public static Boolean itemTooltips = true;

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onAttributeEvent(ItemAttributeModifierEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        for (ItemDefinition itemDefinition : ItemDefinitionsReloadListener.DEFINITIONS) {
            itemDefinition.applyAttributes(event, event.getItemStack(), (Multimap<Attribute, AttributeModifier>)event.getModifiers());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onTooltip(ItemTooltipEvent event) {
        if (!this.isEnabled() || !miningSpeedTooltip.booleanValue()) {
            return;
        }
        ItemStack stack = event.getItemStack();
        Item item = stack.m_41720_();
        if (item instanceof DiggerItem) {
            DiggerItem diggerItem = (DiggerItem)item;
            float toolEfficiency = ISOEventFactory.getMiningSpeedWithEnchantments((LivingEntity)event.getEntity(), null, stack, diggerItem.f_40980_, true);
            event.getToolTip().add(CommonComponents.m_264333_().m_7220_((Component)Component.m_237110_((String)TOOL_MINING_SPEED_LANG, (Object[])new Object[]{InsaneLib.ONE_DECIMAL_FORMATTER.format(toolEfficiency)})).m_130940_(ChatFormatting.DARK_GREEN));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onItemTooltips(ItemTooltipEvent event) {
        if (!(this.isEnabled() && itemTooltips.booleanValue() && event.getItemStack().m_204117_(HAS_TOOLTIP))) {
            return;
        }
        event.getToolTip().add(1, Component.m_237115_((String)(event.getItemStack().m_41720_().m_5524_() + ".tooltip")).m_130940_(ChatFormatting.GRAY));
    }
}

