/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.items.pouch;

import insane96mcp.iguanatweaksreborn.data.criterion.ISOTriggers;
import insane96mcp.iguanatweaksreborn.data.generator.ISOItemTagsProvider;
import insane96mcp.iguanatweaksreborn.module.items.pouch.PouchItem;
import insane96mcp.iguanatweaksreborn.setup.ISORegistries;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.util.MCUtils;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.RegistryObject;

@LoadFeature(module="iguanatweaksreborn:items", description="A new item that can let you carry more stuff around.")
public class Pouch
extends Feature {
    public static final TagKey<Item> POUCH_LIKE_WEIGHT = ISOItemTagsProvider.create("pouch_like_weight");
    public static final UUID CRATE_WEIGHT_UUID = UUID.fromString("4ce89c45-a011-43fa-b9a8-7f2bd0ea2fc3");
    public static final RegistryObject<PouchItem> ITEM = ISORegistries.ITEMS.register("pouch", () -> new PouchItem(new Item.Properties().m_41487_(1)));
    @Config(min=0.0)
    public static Integer maxPouchWithoutSlowdown = 2;
    @Config(min=0.0, max=1.0, description="When you have > 'Max pouch without slowdown' this is the base value for the slowdown. The slowdown is calculated as (pouch above 'Max pouch' ^ 2 * this)")
    public static Double baseSlownessPerPouchOverMax = 0.03;

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (baseSlownessPerPouchOverMax == 0.0 || event.phase == TickEvent.Phase.START) {
            return;
        }
        int pouchesInInventory = ContainerHelper.m_18956_((Container)event.player.m_150109_(), stack -> stack.m_150930_((Item)ITEM.get()) || stack.m_204117_(POUCH_LIKE_WEIGHT), (int)0, (boolean)true);
        event.player.m_21051_(Attributes.f_22279_).m_22120_(CRATE_WEIGHT_UUID);
        if (pouchesInInventory > maxPouchWithoutSlowdown) {
            Player player;
            double slowness = (double)(pouchesInInventory - maxPouchWithoutSlowdown) * baseSlownessPerPouchOverMax * (double)Math.max(1, pouchesInInventory - maxPouchWithoutSlowdown);
            MCUtils.applyModifier((LivingEntity)event.player, (Attribute)Attributes.f_22279_, (UUID)CRATE_WEIGHT_UUID, (String)"Crate weight penalty", (double)(-slowness), (AttributeModifier.Operation)AttributeModifier.Operation.MULTIPLY_BASE, (boolean)false);
            if (event.player.f_19797_ % 20 == 4 && (player = event.player) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ISOTriggers.OVERWEIGHT_POUCH_CARRY.trigger(serverPlayer);
            }
        }
    }
}

