/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.items.pouch;

import insane96mcp.iguanatweaksreborn.InsaneSO;
import insane96mcp.iguanatweaksreborn.module.items.pouch.PouchContainer;
import insane96mcp.iguanatweaksreborn.module.items.pouch.PouchMenu;
import insane96mcp.iguanatweaksreborn.module.items.pouch.PouchTooltip;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class PouchItem
extends Item {
    public PouchItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public boolean m_142095_() {
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (!level.f_46443_) {
            PouchItem.openMenu(player, player.m_21120_(hand));
        }
        return InteractionResultHolder.m_19092_((Object)player.m_21120_(hand), (boolean)level.m_5776_());
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        return Optional.of(new PouchTooltip(PouchItem.getContentsList(stack)));
    }

    public static NonNullList<ItemStack> getContentsList(ItemStack stack) {
        NonNullList list = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
        if (!stack.m_41782_()) {
            return list;
        }
        CompoundTag tag = stack.m_41783_();
        if (tag.m_128425_("Items", 9)) {
            ListTag nbtList = tag.m_128437_("Items", 10);
            nbtList.forEach(t -> {
                CompoundTag itemTag = (CompoundTag)t;
                int slot = itemTag.m_128451_("Slot");
                if (slot >= 0 && slot < list.size()) {
                    list.set(slot, (Object)ItemStack.m_41712_((CompoundTag)itemTag));
                }
            });
            return list;
        }
        return list;
    }

    public void m_142312_(CompoundTag tag) {
        CompoundTag bet;
        super.m_142312_(tag);
        if (tag.m_128425_("BlockEntityTag", 10) && (bet = tag.m_128469_("BlockEntityTag")).m_128425_("Items", 9)) {
            ListTag oldList = bet.m_128437_("Items", 10);
            tag.m_128365_("Items", (Tag)oldList.m_6426_());
            tag.m_128473_("BlockEntityTag");
        }
    }

    public boolean m_142207_(ItemStack pouchStack, Slot slot, ClickAction action, Player player) {
        if (pouchStack.m_41613_() != 1 || action != ClickAction.SECONDARY || !slot.m_150651_(player)) {
            return false;
        }
        ItemStack slotStack = slot.m_7993_();
        PouchContainer pouch = new PouchContainer(pouchStack);
        return this.insertIntoPouch(pouch, slotStack, player, false);
    }

    public boolean m_142305_(ItemStack pouchStack, ItemStack otherStack, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (pouchStack.m_41613_() != 1 || action != ClickAction.SECONDARY || !slot.m_150651_(player)) {
            return false;
        }
        PouchContainer pouch = new PouchContainer(pouchStack);
        if (otherStack.m_41619_()) {
            PouchItem.openMenu(player, pouchStack);
            return true;
        }
        return this.insertIntoPouch(pouch, otherStack, player, true);
    }

    private boolean insertIntoPouch(PouchContainer pouch, ItemStack stack, Player player, boolean openMenuIfEmpty) {
        ItemStack inside;
        int i;
        if (stack.m_41619_() || !stack.m_41720_().m_142095_()) {
            return false;
        }
        for (i = 0; i < pouch.m_6643_(); ++i) {
            int space;
            inside = pouch.m_8020_(i);
            if (inside.m_41619_() || !ItemStack.m_150942_((ItemStack)inside, (ItemStack)stack) || (space = inside.m_41741_() - inside.m_41613_()) <= 0) continue;
            int toMove = Math.min(space, stack.m_41613_());
            inside.m_41769_(toMove);
            stack.m_41774_(toMove);
            pouch.m_6596_();
            this.playInsertSound((Entity)player);
            if (!stack.m_41619_()) continue;
            return true;
        }
        for (i = 0; i < pouch.m_6643_(); ++i) {
            inside = pouch.m_8020_(i);
            if (!inside.m_41619_()) continue;
            int toMove = Math.min(stack.m_41613_(), stack.m_41741_());
            pouch.m_6836_(i, stack.m_41620_(toMove));
            this.playInsertSound((Entity)player);
            if (!stack.m_41619_()) continue;
            return true;
        }
        return !stack.m_41619_();
    }

    private void playInsertSound(Entity pEntity) {
        pEntity.m_5496_(SoundEvents.f_184215_, 0.8f, 0.8f + pEntity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    public static void openMenu(Player player, ItemStack pouchStack) {
        player.f_36096_.m_150444_();
        player.m_5893_((MenuProvider)new SimpleMenuProvider((id, inv, p) -> new PouchMenu(id, inv, new PouchContainer(pouchStack)), (Component)Component.m_237115_((String)InsaneSO.lang("pouch"))));
        player.f_36096_.m_150443_();
    }
}

