/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.items.repairkit;

import insane96mcp.iguanatweaksreborn.module.experience.anvils.AnvilRepair;
import insane96mcp.iguanatweaksreborn.module.experience.anvils.Anvils;
import insane96mcp.iguanatweaksreborn.module.items.repairkit.RepairKits;
import java.util.Optional;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class RepairKitRepairRecipe
extends CustomRecipe {
    public RepairKitRepairRecipe(ResourceLocation pId, CraftingBookCategory pCategory) {
        super(pId, pCategory);
    }

    public boolean matches(CraftingContainer container, Level pLevel) {
        ItemStack repairableItem = null;
        ItemStack repairKit = null;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack itemStack = container.m_8020_(i);
            if (itemStack.m_41619_()) continue;
            if (itemStack.m_41763_() && itemStack.m_41768_()) {
                if (repairableItem != null) {
                    return false;
                }
                repairableItem = itemStack;
            }
            if (!itemStack.m_41720_().equals(RepairKits.ITEM.get())) continue;
            if (!(repairKit == null || itemStack.m_41783_() != null && repairKit.m_41784_().m_128461_("repair_material").equals(itemStack.m_41783_().m_128461_("repair_material")))) {
                return false;
            }
            repairKit = itemStack;
        }
        return repairableItem != null && repairKit != null;
    }

    public ItemStack assemble(CraftingContainer container, RegistryAccess pRegistryAccess) {
        ItemStack repairableItem = null;
        ItemStack repairKit = null;
        int kitAmount = 0;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack itemStack = container.m_8020_(i);
            if (itemStack.m_41619_()) continue;
            if (itemStack.m_41763_()) {
                repairableItem = itemStack;
            }
            if (!itemStack.m_41720_().equals(RepairKits.ITEM.get())) continue;
            if (repairKit == null) {
                repairKit = itemStack;
            }
            ++kitAmount;
        }
        if (repairableItem != null && repairKit != null) {
            float repairSteps;
            Item repairItem = (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.m_135820_((String)repairKit.m_41784_().m_128461_("repair_material")));
            if (repairItem == null) {
                return ItemStack.f_41583_;
            }
            ItemStack repairItemStack = new ItemStack((ItemLike)repairItem);
            Optional<AnvilRepair.RepairData> oRepairData = Anvils.getCustomAnvilRepair(repairableItem, repairItemStack);
            ItemStack resultStack = repairableItem.m_41777_();
            if (!resultStack.m_41720_().m_6832_(resultStack, repairItemStack) && oRepairData.isEmpty()) {
                return ItemStack.f_41583_;
            }
            int repairCount = RepairKits.repairKitMaterialRatio * kitAmount;
            int maxPartialRepairDmg = Mth.m_14165_((double)((double)resultStack.m_41776_() * (1.0 - RepairKits.maxRepair)));
            float amountRequired = 4.0f;
            if (oRepairData.isPresent()) {
                AnvilRepair.RepairData repairData = oRepairData.get();
                maxPartialRepairDmg = Math.max(maxPartialRepairDmg, Mth.m_14167_((float)((float)resultStack.m_41776_() * (1.0f - repairData.maxRepair()))));
                amountRequired = repairData.amountRequired();
            }
            if (Anvils.materialCost$increaseMaterialsRequiredWithEnchantments > 0.0 && repairableItem.m_41793_()) {
                float increase = 0.0f;
                for (Integer lvl : EnchantmentHelper.m_44831_((ItemStack)repairableItem).values()) {
                    increase += Anvils.materialCost$increaseMaterialsRequiredWithEnchantments.floatValue() * (float)lvl.intValue();
                }
                amountRequired *= 1.0f + increase;
            }
            if (Anvils.materialCost$increaseMaterialsRequiredWithEnchantmentsFlat > 0.0 && repairableItem.m_41793_()) {
                float increase = 0.0f;
                for (Integer lvl : EnchantmentHelper.m_44831_((ItemStack)repairableItem).values()) {
                    increase += Anvils.materialCost$increaseMaterialsRequiredWithEnchantmentsFlat.floatValue() * (float)lvl.intValue();
                }
                amountRequired += increase * oRepairData.get().costMultiplier();
            }
            if ((repairSteps = Math.min((float)resultStack.m_41773_(), (float)resultStack.m_41776_() / amountRequired)) <= 0.0f || resultStack.m_41773_() <= maxPartialRepairDmg) {
                return ItemStack.f_41583_;
            }
            float damageValue = resultStack.m_41773_();
            for (int repairItemCountCost = 0; repairSteps > 0.0f && repairItemCountCost < repairCount && damageValue > (float)maxPartialRepairDmg; ++repairItemCountCost) {
                repairSteps = Math.min(damageValue -= repairSteps, (float)resultStack.m_41776_() / amountRequired);
            }
            resultStack.m_41721_((int)Math.max((float)maxPartialRepairDmg, damageValue));
            return resultStack;
        }
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return pWidth * pHeight >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RepairKits.REPAIR_RECIPE_SERIALIZER.get();
    }
}

