/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.mining;

import com.teamabnormals.caverns_and_chasms.core.CCConfig;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.InfestedBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;

@LoadFeature(module="iguanatweaksreborn:mining", description="Various mining changes")
public class MiningMisc
extends Feature {
    @Config(name="Insta-Mine Silverfish", description="Silverfish blocks will insta-mine like pre-1.17")
    public static Boolean instaMineSilverfish = true;
    @Config(name="Insta-Mine Heads", description="Heads will insta-break")
    public static Boolean instaMineHeads = true;
    @Config(name="Faster slabs, stairs and walls", description="Makes slabs, stairs and walls take less time to break")
    public static Boolean fastSlabsStairsWalls = true;
    @Config(description="In vanilla there's a 5 tick delay (0.25 secs) between breaking blocks. The tick delay is reduced by 1 tick every 2 tool mining speed.")
    public static Boolean efficiencyBasedDestroyDelay = true;
    @Config(description="Changes some Caverns and Chasms config options.")
    public static Boolean cavernsChasmsIntegration = false;

    public MiningMisc(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    public void readConfig(ModConfigEvent event) {
        super.readConfig(event);
        for (Block block : ForgeRegistries.BLOCKS.getValues()) {
            if ((!instaMineHeads.booleanValue() || !(block instanceof AbstractSkullBlock)) && (!instaMineSilverfish.booleanValue() || !(block instanceof InfestedBlock))) continue;
            block.m_49965_().m_61056_().forEach(blockState -> {
                blockState.f_60599_ = 0.0f;
            });
        }
        if (ModList.get().isLoaded("caverns_and_chasms") && cavernsChasmsIntegration.booleanValue()) {
            CCConfig.COMMON.chainmailArmorIncreasesDamage.set((Object)false);
            CCConfig.COMMON.goldenArmorIncreasesSpeed.set((Object)false);
            CCConfig.COMMON.creeperExplosionNerf.set((Object)false);
        }
    }

    @SubscribeEvent
    public void onBreak(PlayerEvent.BreakSpeed event) {
        if (!this.isEnabled() || !fastSlabsStairsWalls.booleanValue()) {
            return;
        }
        if (event.getState().m_60734_() instanceof SlabBlock && (event.getState().m_61143_((Property)SlabBlock.f_56353_) == SlabType.TOP || event.getState().m_61143_((Property)SlabBlock.f_56353_) == SlabType.BOTTOM)) {
            event.setNewSpeed(event.getOriginalSpeed() * 2.0f);
        }
        if (event.getState().m_60734_() instanceof StairBlock) {
            event.setNewSpeed(event.getOriginalSpeed() * 1.3333333f);
        }
        if (event.getState().m_60734_() instanceof WallBlock) {
            event.setNewSpeed(event.getOriginalSpeed() * 1.5f);
        }
    }

    public static int destroyDelay(ItemStack stack, DiggerItem item, BlockState state) {
        if (!MiningMisc.isEnabled(MiningMisc.class) || !efficiencyBasedDestroyDelay.booleanValue()) {
            return 5;
        }
        float delay = 5.0f - (float)((int)(item.f_40980_ / 2.5f));
        int efficiency = stack.getEnchantmentLevel(Enchantments.f_44984_);
        if (efficiency > 0) {
            delay -= (float)efficiency / 2.0f;
        }
        return (int)Math.max(delay, 1.0f);
    }
}

