/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.mining.blockdefinition;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import insane96mcp.iguanatweaksreborn.module.mining.blockdefinition.BlockDefinition;
import insane96mcp.iguanatweaksreborn.network.message.BlockDefinitionSync;
import insane96mcp.iguanatweaksreborn.utils.ISOLogHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="iguanatweaksreborn")
public class BlockDefinitionReloadListener
extends SimpleJsonResourceReloadListener {
    public static final List<BlockDefinition> DEFINITIONS = new ArrayList<BlockDefinition>();
    public static final List<BlockDefinition> ORIGINAL_DEFINITIONS = new ArrayList<BlockDefinition>();
    public static final BlockDefinitionReloadListener INSTANCE;
    private static final Gson GSON;

    public BlockDefinitionReloadListener() {
        super(GSON, "block_definitions");
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        BlockDefinitionReloadListener.restoreOriginalDefinitionsAndClear();
        DEFINITIONS.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
            try {
                ResourceLocation name = entry.getKey();
                String[] split = name.m_135815_().split("/");
                if (split[split.length - 1].startsWith("_")) continue;
                BlockDefinition blockDefinition = (BlockDefinition)GSON.fromJson(entry.getValue(), BlockDefinition.class);
                if (blockDefinition == null) {
                    return;
                }
                DEFINITIONS.add(blockDefinition);
            }
            catch (JsonSyntaxException e) {
                ISOLogHelper.error("Parsing error loading Block Definition %s: %s", entry.getKey(), e.getMessage());
            }
            catch (Exception e) {
                ISOLogHelper.error("Failed loading Block Definition %s: %s", entry.getKey(), e.getMessage());
            }
        }
        ISOLogHelper.info("Loaded %s Block Definitions", DEFINITIONS.size());
    }

    public static void restoreOriginalDefinitionsAndClear() {
        for (BlockDefinition definition : ORIGINAL_DEFINITIONS) {
            definition.apply(true);
        }
        ISOLogHelper.info("Restored %s Block Definitions", ORIGINAL_DEFINITIONS.size());
        ORIGINAL_DEFINITIONS.clear();
    }

    @SubscribeEvent
    public static void onDataPackSync(OnDatapackSyncEvent event) {
        if (event.getPlayer() == null) {
            event.getPlayerList().m_11314_().forEach(player -> BlockDefinitionSync.sync(DEFINITIONS, player));
        } else {
            BlockDefinitionSync.sync(DEFINITIONS, event.getPlayer());
        }
    }

    @SubscribeEvent
    public static void onTagsUpdatedEvent(TagsUpdatedEvent event) {
        for (BlockDefinition definition : DEFINITIONS) {
            definition.apply(false);
        }
    }

    public String m_7812_() {
        return "Block Definitions Reload Listener";
    }

    static {
        GSON = new GsonBuilder().create();
        INSTANCE = new BlockDefinitionReloadListener();
    }
}

