/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.mining.blockhardness;

import insane96mcp.iguanatweaksreborn.InsaneSO;
import insane96mcp.iguanatweaksreborn.data.generator.ISOBlockTagsProvider;
import insane96mcp.iguanatweaksreborn.module.mining.blockhardness.DepthHardnessDimension;
import insane96mcp.iguanatweaksreborn.module.mining.blockhardness.DimensionHardnessMultiplier;
import insane96mcp.iguanatweaksreborn.network.message.GlobalHardnessSync;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.JsonFeature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.data.IdTagValue;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="iguanatweaksreborn:mining", description="Change blocks hardness. Dimension Hardness and Depth Hardness are controlled via json in this feature's folder. Block hardness can be changed with Block Definitions via data packs")
public class BlockHardness
extends JsonFeature {
    public static final TagKey<Block> HARDNESS_BLACKLIST = ISOBlockTagsProvider.create("hardness_blacklist");
    public static final TagKey<Block> DEPTH_MULTIPLIER_BLACKLIST = ISOBlockTagsProvider.create("depth_multiplier_blacklist");
    public static final ArrayList<DimensionHardnessMultiplier> DIMENSION_HARDNESS_MULTIPLIERS_DEFAULT = new ArrayList<DimensionHardnessMultiplier>(List.of(new DimensionHardnessMultiplier("minecraft:the_nether", 1.5)));
    public static final ArrayList<DimensionHardnessMultiplier> dimensionHardnessMultiplier = new ArrayList();
    public static final ArrayList<DepthHardnessDimension> DEPTH_MULTIPLIER_DIMENSION_DEFAULT = new ArrayList(List.of());
    public static final ArrayList<DepthHardnessDimension> depthMultiplierDimension = new ArrayList();
    @Config(min=0.0, max=128.0, description="Multiplier applied to the hardness of blocks. E.g. with this set to 2.0 blocks will take 2 times longer to break.")
    public static Double hardnessMultiplier = 1.0;
    private static final Object mutex = new Object();

    public BlockHardness(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
        BlockHardness.addSyncType((ResourceLocation)InsaneSO.location("dimension_hardness"), (JsonFeature.SyncType)new JsonFeature.SyncType(json -> BlockHardness.loadAndReadJson((String)json, dimensionHardnessMultiplier, DIMENSION_HARDNESS_MULTIPLIERS_DEFAULT, (Type)DimensionHardnessMultiplier.LIST_TYPE)));
        this.JSON_CONFIGS.add(new JsonFeature.JsonConfig("dimension_hardness.json", dimensionHardnessMultiplier, DIMENSION_HARDNESS_MULTIPLIERS_DEFAULT, DimensionHardnessMultiplier.LIST_TYPE, true, InsaneSO.location("dimension_hardness")));
        BlockHardness.addSyncType((ResourceLocation)InsaneSO.location("depth_multipliers"), (JsonFeature.SyncType)new JsonFeature.SyncType(json -> BlockHardness.loadAndReadJson((String)json, depthMultiplierDimension, DEPTH_MULTIPLIER_DIMENSION_DEFAULT, (Type)DepthHardnessDimension.LIST_TYPE)));
        this.JSON_CONFIGS.add(new JsonFeature.JsonConfig("depth_multipliers.json", depthMultiplierDimension, DEPTH_MULTIPLIER_DIMENSION_DEFAULT, DepthHardnessDimension.LIST_TYPE, true, InsaneSO.location("depth_multipliers")));
    }

    public String getModConfigFolder() {
        return "config/insanesurvivaloverhaul";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processBlockHardness(List<IdTagValue> list, boolean isClientSide) {
        if (list.isEmpty()) {
            return;
        }
        Object object = mutex;
        synchronized (object) {
            for (IdTagValue blockHardness : list) {
                List blocksToProcess = blockHardness.id.getAllBlocks();
                for (Block block : blocksToProcess) {
                    block.m_49965_().m_61056_().forEach(blockState -> {
                        blockState.f_60599_ = (float)blockHardness.value;
                    });
                }
            }
        }
    }

    @SubscribeEvent
    public void syncHardness(OnDatapackSyncEvent event) {
        if (event.getPlayer() == null) {
            event.getPlayerList().m_11314_().forEach(player -> GlobalHardnessSync.sync(player, hardnessMultiplier.floatValue()));
        } else {
            GlobalHardnessSync.sync(event.getPlayer(), hardnessMultiplier.floatValue());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void processGlobalHardness(PlayerEvent.BreakSpeed event) {
        if (!this.isEnabled() || event.getPosition().isEmpty()) {
            return;
        }
        BlockPos pos = (BlockPos)event.getPosition().get();
        Level level = event.getEntity().m_9236_();
        ResourceLocation dimensionId = level.m_46472_().m_135782_();
        BlockState blockState = level.m_8055_(pos);
        double blockHardnessMultiplier = BlockHardness.getBlockHardnessMultiplier(blockState, dimensionId, pos);
        if (blockHardnessMultiplier == 1.0) {
            return;
        }
        double multiplier = 1.0 / blockHardnessMultiplier;
        event.setNewSpeed((float)((double)event.getNewSpeed() * multiplier));
    }

    public static double getBlockHardnessMultiplier(BlockState state, ResourceLocation dimensionId, BlockPos pos) {
        double blockHardness = BlockHardness.getBlockGlobalHardnessMultiplier(state, dimensionId);
        return blockHardness += BlockHardness.getDepthHardnessMultiplier(state, dimensionId, pos);
    }

    public static double getBlockGlobalHardnessMultiplier(BlockState state, ResourceLocation dimensionId) {
        if (state.m_204336_(HARDNESS_BLACKLIST)) {
            return 1.0;
        }
        for (DimensionHardnessMultiplier dimensionHardnessMultiplier : BlockHardness.dimensionHardnessMultiplier) {
            if (!dimensionId.equals((Object)dimensionHardnessMultiplier.dimension)) continue;
            return dimensionHardnessMultiplier.multiplier;
        }
        return hardnessMultiplier;
    }

    public static double getDepthHardnessMultiplier(BlockState state, ResourceLocation dimensionId, BlockPos pos) {
        if (!Feature.isEnabled(BlockHardness.class)) {
            return 0.0;
        }
        if (state.m_204336_(DEPTH_MULTIPLIER_BLACKLIST)) {
            return 0.0;
        }
        double hardness = 0.0;
        for (DepthHardnessDimension depthHardnessDimension : depthMultiplierDimension) {
            if (!dimensionId.equals((Object)depthHardnessDimension.dimension)) continue;
            hardness += depthHardnessDimension.multiplier * (double)Math.max(depthHardnessDimension.applyBelowY - Math.max(pos.m_123342_(), depthHardnessDimension.stopAt), 0);
        }
        return hardness;
    }
}

