/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.misc;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.loading.FMLLoader;

@LoadFeature(module="iguanatweaksreborn:misc", description="Various Nerfs")
public class Nerfs
extends Feature {
    public static ResourceLocation LAST_FISHING_POS_TAG;
    public static ResourceLocation LAST_FISHING_COUNT_TAG;
    @Config(description="If true, Iron golems will only drop Iron when killed by the player.")
    public static Boolean ironFromGolemsRequiresPlayer;
    @Config(description="If true, renderDebugInfo is enabled by default. Requires a world restart.")
    public static Boolean noCoordinates;
    @Config(description="If true, maxEntityCramming game rule is set to 6 from 24")
    public static Boolean reducedMobCramming;
    @Config(description="Kelp blocks smelt 16 items instead of 20")
    public static Boolean lessBurnTimeForKelpBlock;
    @Config(description="Prevents duping falling blocks when they travel across dimensions. (If quark is present this is disabled)")
    public static Boolean removeFallingBlockDupe;
    @Config(description="Fixes several piston physics exploits like TNT duping. (If quark is present this is disabled)")
    public static Boolean removePistonPhysicsExploit;
    @Config(min=0.0, max=1.0, description="When an entity is hit and on a mount they have this chance to fall")
    public static Double fallFromMountChance;
    @Config(description="If true, only players are affected by 'Fall from mount chance'")
    public static Boolean fallFromMountPlayerOnly;
    @Config(min=0.0, name="Prone mining speed multiplier", description="When prone your mining speed is multiplied by this")
    public static Double proneMiningSpeedMultiplier;

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        LAST_FISHING_POS_TAG = this.createDataKey("last_fishing_pos");
        LAST_FISHING_COUNT_TAG = this.createDataKey("last_fishing_count");
    }

    public void readConfig(ModConfigEvent event) {
        super.readConfig(event);
    }

    public static boolean isFallingBlockDupeRemoved() {
        return Nerfs.isEnabled(Nerfs.class) && removeFallingBlockDupe != false;
    }

    public static boolean isPistonPhysicsExploitEnabled() {
        return Nerfs.isEnabled(Nerfs.class) && removePistonPhysicsExploit != false;
    }

    @SubscribeEvent
    public void onLivingDrop(LivingDropsEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (ironFromGolemsRequiresPlayer.booleanValue() && event.getEntity() instanceof IronGolem && !(event.getSource().m_7640_() instanceof Player)) {
            event.getDrops().removeIf(itemEntity -> itemEntity.m_32055_().m_150930_(Items.f_42416_));
        }
    }

    @SubscribeEvent
    public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (!this.isEnabled() || proneMiningSpeedMultiplier == 0.0 || event.getEntity().m_20089_() != Pose.SWIMMING) {
            return;
        }
        event.setNewSpeed(event.getNewSpeed() * proneMiningSpeedMultiplier.floatValue());
    }

    @SubscribeEvent
    public void onPlayerHit(LivingDamageEvent event) {
        if (!this.isEnabled() || !event.getEntity().m_20159_() || !(event.getSource().m_7639_() instanceof LivingEntity) && !event.getEntity().m_9236_().f_46443_ || fallFromMountChance == 0.0) {
            return;
        }
        if (fallFromMountPlayerOnly.booleanValue() && !(event.getEntity() instanceof Player)) {
            return;
        }
        if ((double)event.getEntity().m_217043_().m_188501_() < fallFromMountChance) {
            event.getEntity().m_8127_();
            event.getEntity().m_9236_().m_6269_(null, (Entity)event.getEntity(), SoundEvents.f_11675_, event.getEntity().m_5720_(), 1.0f, 0.5f);
        }
    }

    @SubscribeEvent
    public void onServerStarted(ServerStartedEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (noCoordinates.booleanValue() && FMLLoader.isProduction()) {
            ((GameRules.BooleanValue)event.getServer().m_129900_().m_46170_(GameRules.f_46145_)).m_46246_(true, event.getServer());
        }
        if (reducedMobCramming.booleanValue()) {
            ((GameRules.IntegerValue)event.getServer().m_129900_().m_46170_(GameRules.f_46149_)).m_151489_(6, event.getServer());
        }
    }

    @SubscribeEvent
    public void onFuelBurnTime(FurnaceFuelBurnTimeEvent event) {
        if (!(this.isEnabled() && lessBurnTimeForKelpBlock.booleanValue() && event.getItemStack().m_150930_(Items.f_42515_))) {
            return;
        }
        event.setBurnTime(3200);
    }

    static {
        ironFromGolemsRequiresPlayer = true;
        noCoordinates = true;
        reducedMobCramming = true;
        lessBurnTimeForKelpBlock = true;
        removeFallingBlockDupe = true;
        removePistonPhysicsExploit = true;
        fallFromMountChance = 0.2;
        fallFromMountPlayerOnly = true;
        proneMiningSpeedMultiplier = 0.5;
    }
}

