/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.misc;

import insane96mcp.iguanatweaksreborn.module.misc.tweaks.Tweaks;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.config.Config;
import net.minecraft.world.effect.AttackDamageMobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@LoadFeature(module="iguanatweaksreborn:misc", description="Various changes to potions and effects")
public class PotionsAndEffects
extends Feature {
    @Config(min=1.0, description="Poison will damage the player every this ticks at level I. Vanilla is 25.")
    public static Integer poisonDamageSpeed = 60;
    @Config(description="Changes Strength and Weakness +/-3 damage per level to +/-20% damage per level. (Requires a Minecraft restart)")
    public static Boolean betterStrengthAndWeakness = true;
    @Config(description="Changes Mining fatigue and haste to no longer affects attack speed. (Requires a Minecraft restart)")
    public static Boolean betterHasteAndMiningFatigue = true;
    @Config(description="Changes Healing potions to work like pre 1.6.1 by healing 3 health per level")
    public static Boolean betterHealingPotion = true;
    @Config(description="Regeneration will regenerate health every this ticks at level I. Vanilla is 50.")
    public static Integer regenerationBaseSpeed = 50;
    @Config(description="The strength used to throw splash potions. Vanilla is 0.5")
    public static Double splashPotionThrowStrength = 0.8;
    @Config(description="If true, entities will no longer be set on fire if have Fire Resistance (like bedrock edition)")
    public static Boolean preventFireWithResistance = false;
    @Config(description="Splash potions will always be 2/3 effective compared to drinkable ones but will also apply the full effect duration when thrown")
    public static Boolean streamlineSplashPotions = true;
    public static float STREAMLINE_SPLASH_POTION_MULTIPLIER = 0.667f;

    public void readConfig(ModConfigEvent event) {
        super.readConfig(event);
        if (betterStrengthAndWeakness.booleanValue()) {
            MobEffects.f_19600_.f_19446_.remove(Attributes.f_22281_);
            MobEffects.f_19600_.m_19472_(Attributes.f_22281_, "648D7064-6A60-4F59-8ABE-C2C23A6DD7A9", 0.0, AttributeModifier.Operation.MULTIPLY_BASE);
            ((AttackDamageMobEffect)MobEffects.f_19600_).f_19424_ = 0.2;
        }
        if (betterStrengthAndWeakness.booleanValue()) {
            MobEffects.f_19613_.f_19446_.remove(Attributes.f_22281_);
            MobEffects.f_19613_.m_19472_(Attributes.f_22281_, "22653B89-116E-49DC-9B6B-9971489B5BE5", 0.0, AttributeModifier.Operation.MULTIPLY_BASE);
            ((AttackDamageMobEffect)MobEffects.f_19613_).f_19424_ = -0.2;
        }
        if (betterHasteAndMiningFatigue.booleanValue()) {
            MobEffects.f_19598_.f_19446_.remove(Attributes.f_22283_);
            MobEffects.f_19599_.f_19446_.remove(Attributes.f_22283_);
        }
    }

    public static boolean isFireImmune(Entity entity) {
        if (!(PotionsAndEffects.isEnabled(Tweaks.class) && preventFireWithResistance.booleanValue() && entity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        return livingEntity.m_21023_(MobEffects.f_19607_);
    }

    public static int getRegenSpeed(int original) {
        return PotionsAndEffects.isEnabled(PotionsAndEffects.class) ? regenerationBaseSpeed : original;
    }

    public static int getPoisonDamageSpeed(int original) {
        return PotionsAndEffects.isEnabled(PotionsAndEffects.class) ? poisonDamageSpeed : original;
    }

    public static boolean streamlineSplashPotions() {
        return Feature.isEnabled(PotionsAndEffects.class) && streamlineSplashPotions != false;
    }
}

