/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.misc.beaconconduit;

import insane96mcp.iguanatweaksreborn.InsaneSO;
import insane96mcp.iguanatweaksreborn.module.misc.Packs;
import insane96mcp.iguanatweaksreborn.module.misc.beaconconduit.BeaconEffect;
import insane96mcp.iguanatweaksreborn.module.misc.beaconconduit.ISOBeaconBlock;
import insane96mcp.iguanatweaksreborn.module.misc.beaconconduit.ISOBeaconBlockEntity;
import insane96mcp.iguanatweaksreborn.module.misc.beaconconduit.ISOBeaconMenu;
import insane96mcp.iguanatweaksreborn.setup.ISORegistries;
import insane96mcp.iguanatweaksreborn.setup.registry.SimpleBlockWithItem;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.JsonFeature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.data.IdTagMatcher;
import insane96mcp.insanelib.data.IdTagValue;
import insane96mcp.insanelib.world.effect.ILMobEffect;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

@LoadFeature(module="iguanatweaksreborn:misc", name="Beacon & Conduit", description="Beacon has been redesigned to have more effects and range based off blocks used for pyramid. Effects and blocks ranges are controlled via json config in this feature's folder.")
public class BeaconConduit
extends JsonFeature {
    public static final SimpleBlockWithItem BEACON = SimpleBlockWithItem.register("beacon", () -> new ISOBeaconBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50273_)));
    public static final RegistryObject<BlockEntityType<ISOBeaconBlockEntity>> BEACON_BLOCK_ENTITY_TYPE = ISORegistries.BLOCK_ENTITY_TYPES.register("beacon", () -> BlockEntityType.Builder.m_155273_(ISOBeaconBlockEntity::new, (Block[])new Block[]{(Block)BEACON.block().get()}).m_58966_(null));
    public static final RegistryObject<MenuType<ISOBeaconMenu>> BEACON_MENU_TYPE = ISORegistries.MENU_TYPES.register("beacon", () -> new MenuType(ISOBeaconMenu::new, FeatureFlags.f_244377_));
    public static final RegistryObject<MobEffect> BLOCK_REACH = ISORegistries.MOB_EFFECTS.register("block_reach", () -> new ILMobEffect(MobEffectCategory.BENEFICIAL, 8489108).m_19472_((Attribute)ForgeMod.BLOCK_REACH.get(), "bd0c6709-4b67-43d5-ae51-c6180d848978", 0.5, AttributeModifier.Operation.ADDITION));
    public static final RegistryObject<MobEffect> ENTITY_REACH = ISORegistries.MOB_EFFECTS.register("entity_reach", () -> new ILMobEffect(MobEffectCategory.BENEFICIAL, 8489108).m_19472_((Attribute)ForgeMod.ENTITY_REACH.get(), "fb23063a-c676-4da0-8d75-574ab8f3ee30", (double)0.075f, AttributeModifier.Operation.MULTIPLY_BASE));
    public static final ArrayList<IdTagValue> BLOCKS_LIST_DEFAULT = new ArrayList<IdTagValue>(List.of(new IdTagValue(IdTagMatcher.Type.ID, "minecraft:iron_block", 1.0), new IdTagValue(IdTagMatcher.Type.ID, "minecraft:emerald_block", 1.0), new IdTagValue(IdTagMatcher.Type.ID, "minecraft:gold_block", 2.0), new IdTagValue(IdTagMatcher.Type.ID, "minecraft:diamond_block", 3.0), new IdTagValue(IdTagMatcher.Type.ID, "minecraft:netherite_block", 4.0), new IdTagValue(IdTagMatcher.Type.ID, "iguanatweaksexpanded:durium_block", 3.0), new IdTagValue(IdTagMatcher.Type.ID, "iguanatweaksexpanded:soul_steel_block", 1.5), new IdTagValue(IdTagMatcher.Type.ID, "iguanatweaksexpanded:quaron_block", 1.5), new IdTagValue(IdTagMatcher.Type.ID, "caverns_and_chasms:sanguine_block", 1.5), new IdTagValue(IdTagMatcher.Type.ID, "iguanatweaksexpanded:keego_block", 3.0), new IdTagValue(IdTagMatcher.Type.ID, "caverns_and_chasms:silver_block", 2.0), new IdTagValue(IdTagMatcher.Type.ID, "caverns_and_chasms:necromium_block", 4.0)));
    public static final ArrayList<IdTagValue> blocksList = new ArrayList();
    public static final ArrayList<IdTagValue> PAYMENT_TIMES_DEFAULT = new ArrayList<IdTagValue>(List.of(new IdTagValue(IdTagMatcher.Type.ID, "minecraft:iron_ingot", 6000.0), new IdTagValue(IdTagMatcher.Type.ID, "minecraft:gold_ingot", 18000.0), new IdTagValue(IdTagMatcher.Type.ID, "minecraft:diamond", 72000.0), new IdTagValue(IdTagMatcher.Type.ID, "minecraft:emerald", 72000.0), new IdTagValue(IdTagMatcher.Type.ID, "minecraft:netherite_ingot", 115200.0), new IdTagValue(IdTagMatcher.Type.ID, "iguanatweaksexpanded:durium_ingot", 12000.0), new IdTagValue(IdTagMatcher.Type.ID, "iguanatweaksexpanded:keego", 96000.0), new IdTagValue(IdTagMatcher.Type.ID, "iguanatweaksexpanded:quaron_ingot", 96000.0), new IdTagValue(IdTagMatcher.Type.ID, "caverns_and_chasms:living_flesh", 96000.0), new IdTagValue(IdTagMatcher.Type.ID, "iguanatweaksexpanded:soul_steel_ingot", 96000.0), new IdTagValue(IdTagMatcher.Type.ID, "caverns_and_chasms:silver_ingot", 18000.0), new IdTagValue(IdTagMatcher.Type.ID, "caverns_and_chasms:necromium_ingot", 115200.0), new IdTagValue(IdTagMatcher.Type.ID, "minecraft:nether_star", 576000.0)));
    public static final ArrayList<IdTagValue> paymentTimes = new ArrayList();
    public static final ArrayList<BeaconEffect> EFFECTS_DEFAULT = new ArrayList<BeaconEffect>(List.of(new BeaconEffect(MobEffects.f_19596_, new int[]{1, 2, 4}), new BeaconEffect(MobEffects.f_19603_, new int[]{1, 2, 3}), new BeaconEffect("iguanatweaksreborn:block_reach", new int[]{1, 3, 9}), new BeaconEffect(MobEffects.f_19598_, new int[]{1, 2, 4}, 2), new BeaconEffect(MobEffects.f_19607_, new int[]{3}, 2), new BeaconEffect("stamina:vigour", new int[]{2, 5}, 2), new BeaconEffect(MobEffects.f_19609_, new int[]{2}, 2), new BeaconEffect(MobEffects.f_19600_, new int[]{1, 3, 9}, 3), new BeaconEffect(MobEffects.f_19606_, new int[]{1, 3, 9}, 3), new BeaconEffect(MobEffects.f_19611_, new int[]{3}, 3), new BeaconEffect(MobEffects.f_19591_, new int[]{2}, 3), new BeaconEffect(MobEffects.f_19605_, new int[]{8}, 4), new BeaconEffect("iguanatweaksreborn:regenerating_absorption", new int[]{2, 4}, 4), new BeaconEffect("iguanatweaksreborn:entity_reach", new int[]{1, 3, 9}, 4)));
    public static final ArrayList<BeaconEffect> effects = new ArrayList();
    @Config
    public static Boolean beacon$requiresPayment = false;
    @Config
    public static Integer beacon$baseRange = 16;
    @Config(description="Greatly increases the range and damage of the conduit")
    public static Boolean conduit$betterProtection = true;
    @Config(min=0.0, max=64.0, description="Distance multiplier (formula is `blocks_around / 7 * this_multiplier`) from the conduit at which it will deal damage to enemies.")
    public static Double conduit$protectionDistanceMultiplier = 8.0;
    @Config(min=0.0, max=96.0, description="If a mob is within this radius from the conduit, it will be dealt the maximum amount of damage.")
    public static Double conduit$protectionMaxDamageDistance = 8.0;
    @Config(description="If true, conduit effect will no longer speed up mining speed.")
    public static Boolean conduit$removeHaste = true;
    @Nullable
    static BeaconEffect cachedBeaconEffect;
    static float MIN_DAMAGE;
    static float MAX_DAMAGE;

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        this.JSON_CONFIGS.add(new JsonFeature.JsonConfig("beacon_blocks_ranges.json", blocksList, BLOCKS_LIST_DEFAULT, IdTagValue.LIST_TYPE));
        this.JSON_CONFIGS.add(new JsonFeature.JsonConfig("beacon_payment_times.json", paymentTimes, PAYMENT_TIMES_DEFAULT, IdTagValue.LIST_TYPE));
        BeaconConduit.addSyncType((ResourceLocation)InsaneSO.location("beacon_effects"), (JsonFeature.SyncType)new JsonFeature.SyncType(json -> BeaconConduit.loadAndReadJson((String)json, effects, EFFECTS_DEFAULT, (Type)BeaconEffect.LIST_TYPE)));
        this.JSON_CONFIGS.add(new JsonFeature.JsonConfig("beacon_effects.json", effects, EFFECTS_DEFAULT, BeaconEffect.LIST_TYPE, (list, isClientSide) -> list.removeIf(beaconEffect -> beaconEffect.getEffect() == null), true, InsaneSO.location("beacon_effects")));
        InsaneSO.addServerPack("better_beacon", "Insane's Survival Overhaul Better Beacon", () -> this.isEnabled() && Packs.disableAllDataPacks == false);
    }

    public String getModConfigFolder() {
        return "config/insanesurvivaloverhaul";
    }

    public static int getPaymentTime(ItemStack stack) {
        for (IdTagValue idTagValue : paymentTimes) {
            if (!idTagValue.id.matchesItem(stack.m_41720_())) continue;
            return (int)idTagValue.value;
        }
        return 0;
    }

    public static int getEffectTimeScale(@Nullable MobEffect mobEffect, int amplifier) {
        if (cachedBeaconEffect != null && Objects.equals(mobEffect, cachedBeaconEffect.getEffect())) {
            return cachedBeaconEffect.getTimeCostForAmplifier(amplifier);
        }
        for (BeaconEffect beaconEffect : effects) {
            if (!beaconEffect.location.equals((Object)ForgeRegistries.MOB_EFFECTS.getKey((Object)mobEffect))) continue;
            cachedBeaconEffect = beaconEffect;
            return beaconEffect.getTimeCostForAmplifier(amplifier);
        }
        return 1;
    }

    public static boolean isValidEffect(MobEffect mobEffect) {
        for (BeaconEffect beaconEffect : effects) {
            if (!beaconEffect.location.equals((Object)ForgeRegistries.MOB_EFFECTS.getKey((Object)mobEffect))) continue;
            return true;
        }
        return false;
    }

    public static boolean conduitUpdateDestroyEnemies(Level level, BlockPos blockPos, List<BlockPos> blocks) {
        if (!BeaconConduit.isEnabled(BeaconConduit.class) || !conduit$betterProtection.booleanValue()) {
            return false;
        }
        LivingEntity nearestEntity = level.m_45963_(LivingEntity.class, TargetingConditions.m_148353_().m_26888_(livingEntity -> livingEntity instanceof Enemy && livingEntity.m_20070_()), null, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), BeaconConduit.getDamageAABB(blockPos, blocks));
        if (nearestEntity == null) {
            return true;
        }
        level.m_6263_(null, nearestEntity.m_20185_(), nearestEntity.m_20186_(), nearestEntity.m_20189_(), SoundEvents.f_11823_, SoundSource.BLOCKS, 1.0f, 1.0f);
        double distance = nearestEntity.m_20182_().m_82554_(new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()));
        float damage = distance < conduit$protectionMaxDamageDistance ? MAX_DAMAGE : (float)(1.0 - (distance - conduit$protectionMaxDamageDistance) / (BeaconConduit.maxRangeRadius() - conduit$protectionMaxDamageDistance)) * (MAX_DAMAGE - MIN_DAMAGE) + MIN_DAMAGE;
        nearestEntity.m_6469_(nearestEntity.m_269291_().m_269425_(), damage);
        return true;
    }

    private static AABB getDamageAABB(BlockPos blockPos, List<BlockPos> blocks) {
        double range = (double)blocks.size() / 7.0 * conduit$protectionDistanceMultiplier;
        int x = blockPos.m_123341_();
        int y = blockPos.m_123342_();
        int z = blockPos.m_123343_();
        return new AABB((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)).m_82400_(range);
    }

    private static double maxRange() {
        return 6.0 * conduit$protectionDistanceMultiplier;
    }

    private static double maxRangeRadius() {
        return Math.sqrt(BeaconConduit.maxRange() * BeaconConduit.maxRange() + BeaconConduit.maxRange() * BeaconConduit.maxRange());
    }

    public static boolean shouldRemoveConduitHaste() {
        return Feature.isEnabled(BeaconConduit.class) && conduit$removeHaste != false;
    }

    static {
        MIN_DAMAGE = 2.0f;
        MAX_DAMAGE = 6.0f;
    }
}

