/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.misc.beaconconduit;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.reflect.TypeToken;
import insane96mcp.insanelib.data.IdTagMatcher;
import insane96mcp.insanelib.util.LogHelper;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraftforge.registries.ForgeRegistries;

@JsonAdapter(value=Serializer.class)
public class BeaconEffect
extends IdTagMatcher {
    int[] timeCost;
    int heightRequired;
    public static final Type LIST_TYPE = new TypeToken<ArrayList<BeaconEffect>>(){}.getType();

    public BeaconEffect(String location, int[] timeCost, int heightRequired) {
        super(IdTagMatcher.Type.ID, ResourceLocation.parse((String)location), null);
        this.timeCost = timeCost;
        this.heightRequired = heightRequired;
    }

    public BeaconEffect(MobEffect mobEffect, int[] timeCost, int heightRequired) {
        super(IdTagMatcher.Type.ID, Objects.requireNonNull(ForgeRegistries.MOB_EFFECTS.getKey((Object)mobEffect)), null);
        this.timeCost = timeCost;
        this.heightRequired = heightRequired;
    }

    public BeaconEffect(String location, int[] timeCost) {
        this(location, timeCost, 1);
    }

    public BeaconEffect(MobEffect mobEffect, int[] timeCost) {
        this(mobEffect, timeCost, 1);
    }

    @Nullable
    public MobEffect getEffect() {
        if (!ForgeRegistries.MOB_EFFECTS.containsKey(this.location)) {
            LogHelper.warn((String)"No mob effect found with id %s", (Object[])new Object[]{this.location});
            return null;
        }
        return (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(this.location);
    }

    public int getMaxAmplifier() {
        return this.timeCost.length - 1;
    }

    public int getHeightRequired() {
        return this.heightRequired;
    }

    public int getTimeCostForAmplifier(int amplifier) {
        if (this.timeCost.length <= amplifier) {
            return 1;
        }
        return this.timeCost[amplifier];
    }

    static class Serializer
    implements JsonSerializer<BeaconEffect>,
    JsonDeserializer<BeaconEffect> {
        Serializer() {
        }

        public BeaconEffect deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jObject = json.getAsJsonObject();
            int heightRequired = GsonHelper.m_13824_((JsonObject)jObject, (String)"height_required", (int)1);
            JsonArray jArray = jObject.getAsJsonArray("time_cost");
            if (jArray.size() > 8) {
                throw new JsonParseException("time_cost size cannot be greater than 8");
            }
            ArrayList timeCost = new ArrayList();
            jArray.forEach(jsonElement -> timeCost.add(jsonElement.getAsInt()));
            return new BeaconEffect(GsonHelper.m_13906_((JsonObject)jObject, (String)"id"), timeCost.stream().mapToInt(i -> i).toArray(), heightRequired);
        }

        public JsonElement serialize(BeaconEffect src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jObject = new JsonObject();
            jObject.addProperty("id", src.location.toString());
            if (src.heightRequired > 1) {
                jObject.addProperty("height_required", (Number)src.heightRequired);
            }
            jObject.addProperty("id", src.location.toString());
            JsonArray jArray = new JsonArray();
            for (int i = 0; i < src.timeCost.length; ++i) {
                jArray.add((Number)src.timeCost[i]);
            }
            jObject.add("time_cost", (JsonElement)jArray);
            return jObject;
        }
    }
}

