/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.misc.debuffs;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraftforge.registries.ForgeRegistries;

@JsonAdapter(value=Serializer.class)
public class DeBuff {
    public Stat stat;
    public double min;
    public double max;
    public MobEffect effect;
    public int amplifier;
    public static final Type LIST_TYPE = new TypeToken<ArrayList<DeBuff>>(){}.getType();

    public DeBuff() {
    }

    public DeBuff(Stat stat, double min, double max, MobEffect effect, int amplifier) {
        this.stat = stat;
        this.min = min;
        this.max = max;
        this.effect = effect;
        this.amplifier = amplifier;
    }

    public static enum Stat {
        HUNGER,
        HEALTH,
        EXPERIENCE_LEVEL;

    }

    public static class Serializer
    implements JsonDeserializer<DeBuff>,
    JsonSerializer<DeBuff> {
        public DeBuff deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            DeBuff deBuff = new DeBuff();
            deBuff.stat = (Stat)((Object)context.deserialize(json.getAsJsonObject().get("stat"), Stat.class));
            if (deBuff.stat == null) {
                throw new JsonParseException("Failed to parse stat: %s".formatted(json.getAsJsonObject().get("stat")));
            }
            deBuff.min = GsonHelper.m_144742_((JsonObject)json.getAsJsonObject(), (String)"min", (double)Double.MIN_VALUE);
            deBuff.max = GsonHelper.m_144742_((JsonObject)json.getAsJsonObject(), (String)"max", (double)Double.MAX_VALUE);
            String sMobEffect = GsonHelper.m_13906_((JsonObject)json.getAsJsonObject(), (String)"effect");
            MobEffect mobEffect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(ResourceLocation.m_135820_((String)sMobEffect));
            if (mobEffect == null) {
                throw new JsonParseException("%s effect doesn't exist".formatted(sMobEffect));
            }
            deBuff.effect = mobEffect;
            deBuff.amplifier = GsonHelper.m_13824_((JsonObject)json.getAsJsonObject(), (String)"amplifier", (int)0);
            return deBuff;
        }

        public JsonElement serialize(DeBuff src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.add("stat", context.serialize((Object)src.stat));
            if (src.min != Double.MIN_VALUE) {
                jsonObject.addProperty("min", (Number)src.min);
            }
            if (src.max != Double.MAX_VALUE) {
                jsonObject.addProperty("max", (Number)src.max);
            }
            String sMobEffect = ForgeRegistries.MOB_EFFECTS.getKey((Object)src.effect).toString();
            jsonObject.addProperty("effect", sMobEffect);
            if (src.amplifier > 0) {
                jsonObject.addProperty("amplifier", (Number)src.amplifier);
            }
            return jsonObject;
        }
    }
}

