/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.misc.fishing;

import insane96mcp.iguanatweaksreborn.module.misc.fishing.LowFish;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.saveddata.SavedData;

public class FishingData
extends SavedData {
    List<Entry> entries = new ArrayList<Entry>();

    public int getCountForPos(BlockPos pos, long gameTime) {
        ArrayList<Entry> toRemove = new ArrayList<Entry>();
        int range = LowFish.fishingSpotRange * LowFish.fishingSpotRange;
        for (Entry entry : this.entries) {
            if (gameTime - entry.lastFished > 36000L) {
                toRemove.add(entry);
                continue;
            }
            if (!(entry.pos.m_123331_((Vec3i)pos) <= (double)range)) continue;
            return entry.count;
        }
        toRemove.forEach(this.entries::remove);
        return 0;
    }

    public void addOrIncrementPos(BlockPos pos, long gameTime) {
        int range = LowFish.fishingSpotRange * LowFish.fishingSpotRange;
        for (Entry entry : this.entries) {
            if (!(entry.pos.m_123331_((Vec3i)pos) <= (double)range)) continue;
            entry.increment(gameTime);
            return;
        }
        this.entries.add(new Entry(pos, 1, gameTime));
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag listTag = new ListTag();
        this.entries.forEach(entry -> {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128356_("pos", entry.pos.m_121878_());
            compoundTag.m_128405_("count", entry.count);
            compoundTag.m_128356_("lastFished", entry.lastFished);
            listTag.add((Object)compoundTag);
        });
        tag.m_128365_("fishedPos", (Tag)listTag);
        return tag;
    }

    public static FishingData create() {
        return new FishingData();
    }

    public static FishingData load(CompoundTag tag) {
        FishingData data = new FishingData();
        tag.m_128437_("fishedPos", 10).forEach(compound -> {
            BlockPos pos = BlockPos.m_122022_((long)((CompoundTag)compound).m_128454_("pos"));
            int count = ((CompoundTag)compound).m_128451_("count");
            long lastFished = ((CompoundTag)compound).m_128454_("lastFished");
            data.entries.add(new Entry(pos, count, lastFished));
        });
        return data;
    }

    public static class Entry {
        BlockPos pos;
        int count;
        long lastFished;

        public Entry(BlockPos pos, int count, long lastFished) {
            this.pos = pos;
            this.count = count;
            this.lastFished = lastFished;
        }

        public void increment(long gameTime) {
            ++this.count;
            this.lastFished = gameTime;
        }
    }
}

