/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.misc.tweaks;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import insane96mcp.iguanatweaksreborn.InsaneSO;
import insane96mcp.iguanatweaksreborn.data.generator.ISOBlockTagsProvider;
import insane96mcp.iguanatweaksreborn.data.generator.ISOItemTagsProvider;
import insane96mcp.iguanatweaksreborn.integration.TConstruct;
import insane96mcp.iguanatweaksreborn.module.misc.tweaks.ScuteBlock;
import insane96mcp.iguanatweaksreborn.network.message.SyncDiscreteNameTags;
import insane96mcp.iguanatweaksreborn.setup.ISORegistries;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.MinMax;
import insane96mcp.insanelib.util.MathHelper;
import insane96mcp.insanelib.util.ModNBTData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingBreatheEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDrownEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingUseTotemEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.RegistryObject;

@LoadFeature(module="iguanatweaksreborn:misc", description="Various stuff that doesn't fit in any other Feature.")
public class Tweaks
extends Feature {
    public static ResourceLocation WAS_BREATHING;
    public static ResourceLocation TICK_SINCE_OUT_OF_WATER;
    public static ResourceLocation TIMES_DROWNED;
    public static final GameRules.Key<GameRules.IntegerValue> RULE_PAINFUL_WORLD_BORDER;
    public static final GameRules.Key<GameRules.BooleanValue> RULE_DISCRETE_NAME_TAGS;
    public static final RegistryObject<Block> SCUTE;
    public static final TagKey<Block> BREAK_ON_FALL;
    public static final TagKey<Item> WORLD_IMMUNE;
    public static ResourceKey<DamageType> COLLIDE_WITH_WALL;
    @Config(description="Falling on glass has a chance of breaking it. The higher the fall, the higher the chance. iguanatweaksreborn:fall_on_break block tag can be used to add more blocks that break when falling onto them.")
    public static Boolean fallingBreakingGlass;
    @Config(description="The maximum amount of blocks a sponge can soak. (Vanilla is 64, disabled if quark is installed)")
    public static Integer sponge$maxSoakBlocks;
    @Config(description="The maximum range at which sponges will check for soakable blocks. (Vanilla is 5, disabled if quark is installed)")
    public static Integer sponge$maxSoakRange;
    @Config(description="If exposed to the sun sponges may dry and if exposed to rain sponges might get wet")
    public static Boolean sponges$dryWetWeather;
    @Config(description="When you die in hardcore, your spawn point is set to where you died and a lightning strike is summoned")
    public static Boolean betterHardcoreDeath;
    @Config(min=0.0, max=100.0, description="The amount of ticks the entities consumes when underwater. In vanilla it's 1 without Respiration enchantment. For non integer numbers the decimal part will count as a chance to have a +1")
    public static Double breathe$airTicksConsumed;
    @Config(min=0.0, max=100.0, description="Every how many ticks will entities drown")
    public static Integer breathe$drownSpeed;
    @Config(description="The amount of air ticks the entities regains each tick when out of water. Min is the amount as soon as you exit water, Max is a few seconds out of water. For non integer numbers the decimal part will count as a chance to have a +1. Vanilla is 4.")
    public static MinMax breathe$airTicksRefilled;
    @Config
    public static Boolean breathe$increaseDrownDamageTheMoreDrowning;
    @Config(description="If enabled, the Totem of Undying will give Resistance IV for 5.5 seconds")
    public static Boolean totemResistance;
    @Config(description="The ticks of Water Breathing given by the Turtle Helmet. Vanilla is 200")
    public static Integer turtle$helmetWaterBreathingTime;
    @Config(description="If true scutes will drop as a block and not as item")
    public static Boolean turtle$scuteDropsAsBlock;
    @Config(min=0.0, description="If set higher than 0 it will enable damage when colliding with walls at a high speed (e.g. with explosions or knockback). Higher = more damage. Set to 0 to disable. Please note that even if set to 0, might still show up in performance profilers.")
    public static Double collideWithWallsDamage;
    @Config(min=0.0, description="Vanilla is 10")
    public static Double leashMaxDistance;
    @Config(min=-1.0, max=0.0, description="The speed modifier when frozen. Vanilla is -0.05")
    public static Double frozenMovementSpeedModifier;
    @Config(description="Plays a sound effect when a mob is hit at least from this distance.")
    public static Integer dingDistance;
    @Config
    public static Boolean blindnessNoLongerPreventsSprinting;
    @Config(min=0.0, description="The speed divider when off ground. Vanilla is 5")
    public static Double offGroundSpeedDivider;
    public static boolean discreteNameTags;
    boolean appliedResistance = false;

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        WAS_BREATHING = this.createDataKey("was_breathing");
        TICK_SINCE_OUT_OF_WATER = this.createDataKey("tick_since_out_of_water");
        TIMES_DROWNED = this.createDataKey("times_drowned");
    }

    public void readConfig(ModConfigEvent event) {
        super.readConfig(event);
        Blocks.f_50057_.f_60445_ = sponges$dryWetWeather;
        Blocks.f_50056_.f_60445_ = sponges$dryWetWeather;
    }

    public static boolean doesBlindnessPreventSprint() {
        return Feature.isEnabled(Tweaks.class) && blindnessNoLongerPreventsSprinting != false;
    }

    public static int changeMaxSpongeSoakBlocks(int soakableBlocks) {
        if (!Tweaks.isEnabled(Tweaks.class)) {
            return soakableBlocks;
        }
        return sponge$maxSoakBlocks + 1;
    }

    public static int changeSpongeMaxRange(int range) {
        if (!Tweaks.isEnabled(Tweaks.class)) {
            return range;
        }
        return sponge$maxSoakRange + 1;
    }

    public static void onSpongeTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!Feature.isEnabled(Tweaks.class)) {
            return;
        }
        if (!level.m_45527_(pos.m_7494_())) {
            return;
        }
        if (state.m_60713_(Blocks.f_50056_) && level.m_46471_()) {
            level.m_46597_(pos, Blocks.f_50057_.m_49966_());
        } else if (state.m_60713_(Blocks.f_50057_) && !level.m_46471_() && level.m_46461_()) {
            int chance = 5;
            for (Direction direction : Direction.values()) {
                if (!level.m_8055_(pos.m_121945_(direction)).m_60713_(Blocks.f_50057_)) continue;
                chance *= 4;
                break;
            }
            if (random.m_188503_(chance) == 0) {
                level.m_46597_(pos, Blocks.f_50056_.m_49966_());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerDeath(LivingDeathEvent event) {
        ServerPlayer player;
        block3: {
            block2: {
                LivingEntity livingEntity;
                if (!this.isEnabled() || !betterHardcoreDeath.booleanValue() || event.getEntity().m_9236_().f_46443_ || !((livingEntity = event.getEntity()) instanceof ServerPlayer)) break block2;
                player = (ServerPlayer)livingEntity;
                if (!(event.getEntity() instanceof FakePlayer) && event.getEntity().m_9236_().m_6106_().m_5466_() && player.f_8941_.m_9290_() != GameType.CREATIVE && player.f_8941_.m_9290_() != GameType.SPECTATOR) break block3;
            }
            return;
        }
        player.m_9158_(player.m_9236_().m_46472_(), player.m_20183_(), player.m_146909_(), true, false);
        LightningBolt lightningBolt = new LightningBolt(EntityType.f_20465_, player.m_9236_());
        lightningBolt.m_20874_(true);
        lightningBolt.m_146884_(player.m_20182_());
        player.m_9236_().m_7967_((Entity)lightningBolt);
        player.m_9236_().m_7731_(player.m_20183_(), Blocks.f_50016_.m_49966_(), 2);
    }

    @SubscribeEvent
    public void onTotemUse(LivingUseTotemEvent event) {
        if (!this.isEnabled() || !totemResistance.booleanValue()) {
            return;
        }
        event.getEntity().m_7292_(new MobEffectInstance(MobEffects.f_19606_, 110, 3));
        this.appliedResistance = true;
    }

    @SubscribeEvent
    public void onDamageEvent(LivingDamageEvent event) {
        LivingEntity livingEntity;
        if (!this.isEnabled() || !((livingEntity = event.getEntity()) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        int painfulWorldBorder = player.m_9236_().m_46469_().m_46215_(RULE_PAINFUL_WORLD_BORDER);
        if (painfulWorldBorder == 0) {
            return;
        }
        WorldBorder worldBorder = player.m_20194_().m_129783_().m_6857_();
        double currentSize = worldBorder.m_61961_();
        double newSize = currentSize + (double)((float)painfulWorldBorder * Math.min(event.getAmount(), player.m_21223_()));
        worldBorder.m_61919_(currentSize, newSize, 2000L);
    }

    @SubscribeEvent
    public void onEffectRemoved(MobEffectEvent.Remove event) {
        if (!(this.isEnabled() && this.appliedResistance && event.getEffect().equals(MobEffects.f_19606_))) {
            return;
        }
        event.setCanceled(true);
        this.appliedResistance = false;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onFalling(LivingFallEvent event) {
        if (!this.isEnabled() || !fallingBreakingGlass.booleanValue() || event.getEntity().m_9236_().f_46443_) {
            return;
        }
        LivingEntity entity = event.getEntity();
        AABB bb = entity.m_20191_();
        int mX = Mth.m_14107_((double)bb.f_82288_);
        int mZ = Mth.m_14107_((double)bb.f_82290_);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        float distance = event.getDistance() - 3.0f;
        if (distance <= 0.0f) {
            return;
        }
        float chance = (float)(Math.pow(distance, 1.25) * (double)0.05f);
        if (entity.m_217043_().m_188501_() >= chance) {
            return;
        }
        int x2 = mX;
        while ((double)x2 < bb.f_82291_) {
            int z2 = mZ;
            while ((double)z2 < bb.f_82293_) {
                pos.m_122169_((double)x2, entity.m_20182_().f_82480_ - (double)1.0E-5f, (double)z2);
                BlockState state = entity.m_9236_().m_8055_((BlockPos)pos);
                if (state.m_204336_(BREAK_ON_FALL)) {
                    BlockEntity blockEntity = state.m_155947_() ? entity.m_9236_().m_7702_((BlockPos)pos) : null;
                    LootParams.Builder lootcontext$builder = new LootParams.Builder((ServerLevel)entity.m_9236_()).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_287286_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_287289_(LootContextParams.f_81462_, (Object)blockEntity).m_287289_(LootContextParams.f_81455_, (Object)entity);
                    state.m_287290_(lootcontext$builder).forEach(stack -> entity.m_9236_().m_7967_((Entity)new ItemEntity(entity.m_9236_(), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, stack)));
                    entity.m_9236_().m_46961_((BlockPos)pos, false);
                }
                ++z2;
            }
            ++x2;
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        SyncDiscreteNameTags.sync(event.getEntity().m_9236_().m_46469_().m_46207_(RULE_DISCRETE_NAME_TAGS), (ServerPlayer)event.getEntity());
    }

    @SubscribeEvent
    public void onBreathe(LivingBreatheEvent event) {
        if (!this.isEnabled() || event.getEntity().m_9236_().f_46443_) {
            return;
        }
        boolean wasBreathing = (Boolean)ModNBTData.get((Entity)event.getEntity(), (ResourceLocation)WAS_BREATHING, Boolean.class);
        long ticksSinceOutOfWater = event.getEntity().m_9236_().m_46467_() - (Long)ModNBTData.get((Entity)event.getEntity(), (ResourceLocation)TICK_SINCE_OUT_OF_WATER, Long.class);
        if (!wasBreathing && event.canBreathe()) {
            ticksSinceOutOfWater = 0L;
            ModNBTData.put((Entity)event.getEntity(), (ResourceLocation)TICK_SINCE_OUT_OF_WATER, (Object)event.getEntity().m_9236_().m_46467_());
        }
        int airConsumed = MathHelper.getAmountWithDecimalChance((RandomSource)event.getEntity().m_217043_(), (double)breathe$airTicksConsumed);
        int respiration = EnchantmentHelper.m_44918_((LivingEntity)event.getEntity());
        int n = airConsumed = respiration > 0 && event.getEntity().m_217043_().m_188503_(respiration + 1) > 0 ? 0 : airConsumed;
        if (event.getEntity().m_20146_() <= 0) {
            airConsumed = 1;
        }
        event.setConsumeAirAmount(airConsumed);
        int refillAmount = MathHelper.getAmountWithDecimalChance((RandomSource)event.getEntity().m_217043_(), (double)Tweaks.breathe$airTicksRefilled.min);
        if (ticksSinceOutOfWater > 75L) {
            refillAmount = MathHelper.getAmountWithDecimalChance((RandomSource)event.getEntity().m_217043_(), (double)Tweaks.breathe$airTicksRefilled.max);
            if (event.canBreathe()) {
                Tweaks.setTimesDrowned(event.getEntity(), 0);
            }
        }
        event.setRefillAirAmount(refillAmount);
        ModNBTData.put((Entity)event.getEntity(), (ResourceLocation)WAS_BREATHING, (Object)event.canBreathe());
    }

    @SubscribeEvent
    public void onDrown(LivingDrownEvent event) {
        if (!(this.isEnabled() && breathe$increaseDrownDamageTheMoreDrowning.booleanValue() && event.getEntity().canDrownInFluidType(event.getEntity().getEyeInFluidType()))) {
            return;
        }
        event.setDrowning(event.getEntity().m_20146_() <= -breathe$drownSpeed.intValue());
        if (event.isDrowning()) {
            int timesDrowned = Tweaks.getTimesDrowned(event.getEntity());
            Tweaks.setTimesDrowned(event.getEntity(), ++timesDrowned);
            event.setDamageAmount(event.getDamageAmount() * (float)timesDrowned * 0.5f);
            event.setBubbleCount((int)((float)(event.getBubbleCount() * timesDrowned) * 0.5f));
        }
    }

    public static void setTimesDrowned(LivingEntity entity, int timesDrowned) {
        ModNBTData.put((Entity)entity, (ResourceLocation)TIMES_DROWNED, (Object)timesDrowned);
    }

    public static int getTimesDrowned(LivingEntity entity) {
        return (Integer)ModNBTData.get((Entity)entity, (ResourceLocation)TIMES_DROWNED, Integer.class);
    }

    public static Vec3 onCollideWithWall(LivingEntity living, Vec3 pTravelVector, float pFriction, Operation<Vec3> originalOperation) {
        double length;
        Mob mob;
        if (!Feature.isEnabled(Tweaks.class) || collideWithWallsDamage == 0.0 || living instanceof Mob && (mob = (Mob)living).m_21523_() || ModList.get().isLoaded("tconstruct") && TConstruct.hasBouncy(living)) {
            return (Vec3)originalOperation.call(new Object[]{living, pTravelVector, Float.valueOf(pFriction)});
        }
        Vec3 oldDeltaMovement = living.m_20184_();
        double horizontalDistance = oldDeltaMovement.m_165924_();
        Vec3 originalResult = (Vec3)originalOperation.call(new Object[]{living, pTravelVector, Float.valueOf(pFriction)});
        if (living.f_19862_ && !living.m_9236_().f_46443_ && (length = horizontalDistance - living.m_20184_().m_165924_()) > (double)0.6f) {
            living.m_6469_(living.m_269291_().m_269298_(COLLIDE_WITH_WALL, null), (float)((length - (double)0.6f) * collideWithWallsDamage));
            if (!living.m_9236_().f_46443_) {
                double x = living.m_20185_();
                double y = living.m_20186_();
                double z = living.m_20189_();
                Direction direction = Direction.m_122366_((double)oldDeltaMovement.f_82479_, (double)oldDeltaMovement.f_82480_, (double)oldDeltaMovement.f_82481_);
                BlockPos pos = BlockPos.m_274561_((double)x, (double)y, (double)z).m_121945_(direction);
                BlockState state = living.m_9236_().m_8055_(pos);
                if (state.m_60795_()) {
                    int height = Mth.m_14167_((float)living.m_20206_());
                    for (int i = 1; i < height; ++i) {
                        pos = pos.m_7494_();
                        state = living.m_9236_().m_8055_(pos);
                        if (!state.m_60795_()) break;
                    }
                }
                if (state.m_60795_()) {
                    return originalResult;
                }
                int particleCount = 150;
                living.m_5496_(living.m_196493_().f_196627_(), 1.0f, 0.7f);
                ((ServerLevel)living.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state).setPos(pos), x, living.m_20186_() + (double)(living.m_20206_() / 2.0f), z, particleCount, 0.0, 0.0, 0.0, (double)0.15f);
            }
        }
        return originalResult;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (!this.isEnabled() || offGroundSpeedDivider == 5.0 || event.getEntity().m_20096_()) {
            return;
        }
        event.setNewSpeed(event.getNewSpeed() * 5.0f / offGroundSpeedDivider.floatValue());
    }

    static {
        RULE_PAINFUL_WORLD_BORDER = GameRules.m_46189_((String)"iguanatweaks:painfulWorldBorder", (GameRules.Category)GameRules.Category.MISC, (GameRules.Type)GameRules.IntegerValue.m_46312_((int)0));
        RULE_DISCRETE_NAME_TAGS = GameRules.m_46189_((String)"iguanatweaks:discreteNameTags", (GameRules.Category)GameRules.Category.PLAYER, (GameRules.Type)GameRules.BooleanValue.m_46252_((boolean)true, (server, booleanValue) -> {
            for (ServerPlayer serverPlayer : server.m_6846_().m_11314_()) {
                SyncDiscreteNameTags.sync(booleanValue.m_46223_(), serverPlayer);
            }
        }));
        SCUTE = ISORegistries.BLOCKS.register("scute", () -> new ScuteBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283784_).m_60913_(0.2f, 0.5f).m_222979_(BlockBehaviour.OffsetType.XZ).m_60988_().m_60918_(SoundType.f_56724_)));
        BREAK_ON_FALL = ISOBlockTagsProvider.create("break_on_fall");
        WORLD_IMMUNE = ISOItemTagsProvider.create("world_immune");
        COLLIDE_WITH_WALL = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)InsaneSO.location("collide_with_wall"));
        fallingBreakingGlass = true;
        sponge$maxSoakBlocks = 256;
        sponge$maxSoakRange = 10;
        sponges$dryWetWeather = true;
        betterHardcoreDeath = true;
        breathe$airTicksConsumed = 1.5;
        breathe$drownSpeed = 30;
        breathe$airTicksRefilled = new MinMax(1.0, 2.5);
        breathe$increaseDrownDamageTheMoreDrowning = true;
        totemResistance = true;
        turtle$helmetWaterBreathingTime = 900;
        turtle$scuteDropsAsBlock = true;
        collideWithWallsDamage = 3.0;
        leashMaxDistance = 16.0;
        frozenMovementSpeedModifier = -0.1;
        dingDistance = 40;
        blindnessNoLongerPreventsSprinting = true;
        offGroundSpeedDivider = 3.0;
        discreteNameTags = true;
    }
}

