/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.mobs.equipment;

import insane96mcp.iguanatweaksreborn.module.mobs.equipment.EquipmentDropChance;
import insane96mcp.insanelib.base.JsonFeature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.data.IdTagMatcher;
import insane96mcp.insanelib.module.base.TagsFeature;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="iguanatweaksreborn:mobs", description="Changes to mobs equipment")
public class Equipment
extends JsonFeature {
    public static final ArrayList<EquipmentDropChance> EQUIPMENT_DROP_CHANCES_DEFAULT = new ArrayList<EquipmentDropChance>(List.of(new EquipmentDropChance(IdTagMatcher.newTag((String)"minecraft:skeletons"), EquipmentSlot.MAINHAND), new EquipmentDropChance(IdTagMatcher.newId((String)"minecraft:zombie"), EquipmentSlot.OFFHAND), new EquipmentDropChance(IdTagMatcher.newId((String)"minecraft:zombified_piglin"), EquipmentSlot.MAINHAND), new EquipmentDropChance(IdTagMatcher.newId((String)"minecraft:piglin"), EquipmentSlot.MAINHAND), new EquipmentDropChance(IdTagMatcher.newId((String)"minecraft:piglin_brute"), EquipmentSlot.MAINHAND), new EquipmentDropChance(IdTagMatcher.newId((String)"minecraft:drowned"), EquipmentSlot.OFFHAND), new EquipmentDropChance(IdTagMatcher.newId((String)"minecraft:zombie_villager"), EquipmentSlot.OFFHAND), new EquipmentDropChance(IdTagMatcher.newId((String)"minecraft:vex"), EquipmentSlot.MAINHAND), new EquipmentDropChance(IdTagMatcher.newId((String)"minecraft:pillager"), EquipmentSlot.MAINHAND), new EquipmentDropChance(IdTagMatcher.newId((String)"progressivebosses:wither_minion"), EquipmentSlot.MAINHAND)));
    public static final ArrayList<EquipmentDropChance> equipmentDropChances = new ArrayList();
    @Config(description="Set the drop chance for mobs equipment.")
    public static Double dropChance = 0.5;
    @Config(description="Set the drop chance for mobs equipment when spawned from spawners.")
    public static Double dropChanceFromSpawners = 0.2;
    @Config(min=0.0, max=1.0, description="Max durability of items dropped by mobs. This also fixes https://bugs.mojang.com/browse/MC-136374. Setting to 0 will disable this feature.")
    public static Double maxDurability = 0.6;
    @Config(description="All drops from mobs will be disenchanted.")
    public static Boolean disenchantEquipment = false;

    public Equipment(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
        this.JSON_CONFIGS.add(new JsonFeature.JsonConfig("custom_drop_chances.json", equipmentDropChances, EQUIPMENT_DROP_CHANCES_DEFAULT, EquipmentDropChance.LIST_TYPE));
    }

    public String getModConfigFolder() {
        return "config/insanesurvivaloverhaul";
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onMobSpawn(EntityJoinLevelEvent event) {
        EquipmentSlot[] equipmentSlotArray;
        if (!this.isEnabled() || !((equipmentSlotArray = event.getEntity()) instanceof Mob)) {
            return;
        }
        Mob entity = (Mob)equipmentSlotArray;
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            boolean customDropChance = false;
            for (EquipmentDropChance edc : equipmentDropChances) {
                if (!edc.entity.matchesEntity((Entity)entity) || !edc.slot.equals((Object)slot)) continue;
                edc.apply(entity);
                customDropChance = true;
            }
            if (customDropChance) continue;
            if (TagsFeature.isSpawnType((MobSpawnType)MobSpawnType.SPAWNER, (LivingEntity)entity)) {
                entity.m_21409_(slot, dropChanceFromSpawners.floatValue());
                continue;
            }
            entity.m_21409_(slot, dropChance.floatValue());
        }
    }

    @SubscribeEvent
    public void onLivingDrop(LivingDropsEvent event) {
        if (!this.isEnabled() || !disenchantEquipment.booleanValue() || event.getEntity() instanceof Player) {
            return;
        }
        event.getDrops().forEach(itemEntity -> {
            if (!itemEntity.m_32055_().m_150930_(Items.f_42690_)) {
                itemEntity.m_32055_().m_41749_("Enchantments");
            }
        });
    }
}

