/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.mobs.spawning;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.reflect.TypeToken;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.JsonFeature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.util.json.ILGsonHelper;
import insane96mcp.insanelib.util.json.validator.IntMinMaxValidator;
import insane96mcp.insanelib.util.json.validator.Validator;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonChangedEvent;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.init.ModConfig;

@LoadFeature(module="iguanatweaksreborn:mobs", requiresMods={"sereneseasons"}, description="Changes to mob spawn with Serene Seasons installed. Check this feature's json config folder for all the configuration options")
public class SeasonSpawning
extends JsonFeature {
    public static final ArrayList<SeasonSettings> SEASON_SETTINGS_DEFAULT = new ArrayList<SeasonSettings>(List.of(new SeasonSettings(List.of(Season.SubSeason.EARLY_WINTER, Season.SubSeason.MID_WINTER, Season.SubSeason.LATE_WINTER), 112, 70, 0, 0), new SeasonSettings(List.of(Season.SubSeason.EARLY_SPRING, Season.SubSeason.MID_SPRING, Season.SubSeason.LATE_SPRING), 128, 60, 30, 20), new SeasonSettings(List.of(Season.SubSeason.EARLY_SUMMER, Season.SubSeason.MID_SUMMER, Season.SubSeason.LATE_SUMMER), 128, 55, 50, 20), new SeasonSettings(List.of(Season.SubSeason.EARLY_AUTUMN, Season.SubSeason.MID_AUTUMN, Season.SubSeason.LATE_AUTUMN), 128, 70, 15, 10)));
    public static final ArrayList<SeasonSettings> seasonSettings = new ArrayList();

    public SeasonSpawning(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
        this.JSON_CONFIGS.add(new JsonFeature.JsonConfig("season_settings.json", seasonSettings, SEASON_SETTINGS_DEFAULT, SeasonSettings.LIST_TYPE));
    }

    public String getModConfigFolder() {
        return "config/insanesurvivaloverhaul";
    }

    public boolean isEnabled() {
        return super.isEnabled() && ModList.get().isLoaded("sereneseasons");
    }

    @SubscribeEvent
    public void onServerStarted(ServerStartedEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        SeasonSpawning.tryApply(seasonSettings, SeasonHelper.getSeasonState((Level)event.getServer().m_129783_()).getSubSeason());
    }

    public static void onSeasonChanged(SeasonChangedEvent.Standard event) {
        if (!Feature.isEnabled(SeasonSpawning.class) || !ModConfig.seasons.isDimensionWhitelisted(event.getLevel().m_46472_())) {
            return;
        }
        SeasonSpawning.tryApply(seasonSettings, (Season.SubSeason)event.getNewSeason());
    }

    public static void tryApply(List<SeasonSettings> seasonSettings, Season.SubSeason subSeason) {
        seasonSettings.forEach(seasonSetting -> seasonSetting.tryApply(subSeason));
    }

    @JsonAdapter(value=Serializer.class)
    public static class SeasonSettings {
        public List<Season.SubSeason> seasons;
        @Nullable
        public Integer despawnDistance;
        @Nullable
        public Integer hostileCap;
        @Nullable
        public Integer animalCap;
        @Nullable
        public Integer waterAmbientCap;
        public static final Type LIST_TYPE = new TypeToken<ArrayList<SeasonSettings>>(){}.getType();

        public SeasonSettings(List<Season.SubSeason> seasons, @Nullable Integer despawnDistance, @Nullable Integer hostileCap, @Nullable Integer animalCap, @Nullable Integer waterAmbientCap) {
            this.seasons = seasons;
            this.despawnDistance = despawnDistance;
            this.hostileCap = hostileCap;
            this.animalCap = animalCap;
            this.waterAmbientCap = waterAmbientCap;
        }

        public void tryApply(Season.SubSeason subSeason) {
            if (this.seasons.contains(subSeason)) {
                this.apply();
            }
        }

        public void apply() {
            MobCategory.MONSTER.f_21591_ = Objects.requireNonNullElse(this.despawnDistance, 128);
            MobCategory.MONSTER.f_21586_ = Objects.requireNonNullElse(this.hostileCap, 70);
            MobCategory.CREATURE.f_21586_ = Objects.requireNonNullElse(this.animalCap, 10);
            MobCategory.WATER_AMBIENT.f_21586_ = Objects.requireNonNullElse(this.waterAmbientCap, 20);
        }

        public static class Serializer
        implements JsonDeserializer<SeasonSettings>,
        JsonSerializer<SeasonSettings> {
            public SeasonSettings deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                ArrayList<Season.SubSeason> subSeasons = new ArrayList<Season.SubSeason>();
                JsonArray aSeasons = GsonHelper.m_13933_((JsonObject)json.getAsJsonObject(), (String)"seasons");
                if (aSeasons.isEmpty()) {
                    throw new JsonParseException("seasons list must contain at least one entry");
                }
                for (JsonElement jsonElement : aSeasons) {
                    subSeasons.add(Season.SubSeason.valueOf((String)jsonElement.getAsString().toUpperCase(Locale.ROOT)));
                }
                Integer despawnDistance = ILGsonHelper.getAsNullableInt((JsonObject)json.getAsJsonObject(), (String)"despawn_distance", (Validator)IntMinMaxValidator.atLeast((int)0));
                Integer hostileCap = ILGsonHelper.getAsNullableInt((JsonObject)json.getAsJsonObject(), (String)"hostile_cap", (Validator)IntMinMaxValidator.atLeast((int)0));
                Integer animalCap = ILGsonHelper.getAsNullableInt((JsonObject)json.getAsJsonObject(), (String)"animal_cap", (Validator)IntMinMaxValidator.atLeast((int)0));
                Integer waterAmbientCap = ILGsonHelper.getAsNullableInt((JsonObject)json.getAsJsonObject(), (String)"water_ambient_cap", (Validator)IntMinMaxValidator.atLeast((int)0));
                return new SeasonSettings(subSeasons, despawnDistance, hostileCap, animalCap, waterAmbientCap);
            }

            public JsonElement serialize(SeasonSettings src, Type typeOfSrc, JsonSerializationContext context) {
                JsonObject jsonObject = new JsonObject();
                JsonArray aSeasons = new JsonArray();
                for (Season.SubSeason subSeason : src.seasons) {
                    aSeasons.add(subSeason.name().toLowerCase(Locale.ROOT));
                }
                jsonObject.add("seasons", (JsonElement)aSeasons);
                if (src.despawnDistance != null) {
                    jsonObject.addProperty("despawn_distance", (Number)src.despawnDistance);
                }
                if (src.hostileCap != null) {
                    jsonObject.addProperty("hostile_cap", (Number)src.hostileCap);
                }
                if (src.animalCap != null) {
                    jsonObject.addProperty("animal_cap", (Number)src.animalCap);
                }
                if (src.waterAmbientCap != null) {
                    jsonObject.addProperty("water_ambient_cap", (Number)src.waterAmbientCap);
                }
                return jsonObject;
            }
        }
    }
}

