/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.mobs.villager;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.reflect.TypeToken;
import insane96mcp.iguanatweaksreborn.utils.ISOLogHelper;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.loot.functions.ExplorationMapFunction;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;
import org.jetbrains.annotations.NotNull;

@JsonAdapter(value=SerializableTradeSerializer.class)
public class SerializableTrade
implements VillagerTrades.ItemListing {
    public Stack itemA;
    @Nullable
    public Stack itemB;
    public Stack result;
    private int maxUses = 1;
    private int xp = 0;
    @Nullable
    private EnchantRandomly enchantRandomly;
    private final List<EnchantmentInstance> enchantments = new ArrayList<EnchantmentInstance>();
    @Nullable
    private ExplorationMap explorationMap;
    private boolean invalid = false;
    public static final Type LIST_TYPE = new TypeToken<ArrayList<SerializableTrade>>(){}.getType();

    public static SerializableTrade itemToEmeralds(Item item, Count count, Count emeraldCount) {
        return new SerializableTrade().setItemA(item, count, null).setResult(Items.f_42616_, emeraldCount, null);
    }

    public static SerializableTrade itemToEmeralds(TagKey<Item> tag, Count count, Count emeraldCount) {
        return new SerializableTrade().setItemA(tag, count, null).setResult(Items.f_42616_, emeraldCount, null);
    }

    public static SerializableTrade emeraldToItems(Count emeraldCount, Item item, Count count) {
        return new SerializableTrade().setItemA(Items.f_42616_, emeraldCount, null).setResult(item, count, null);
    }

    public static SerializableTrade emeraldToItems(Count emeraldCount, TagKey<Item> item, Count count) {
        return new SerializableTrade().setItemA(Items.f_42616_, emeraldCount, null).setResult(item, count, null);
    }

    public SerializableTrade setItemA(Item item, Count count, CompoundTag nbt) {
        return this.setItemA(new Stack(item, null, count, nbt));
    }

    public SerializableTrade setItemA(TagKey<Item> tag, Count count, CompoundTag nbt) {
        return this.setItemA(new Stack(null, tag, count, nbt));
    }

    public SerializableTrade setItemA(Stack stack) {
        this.itemA = stack;
        return this;
    }

    public SerializableTrade setItemB(Item item, Count count, CompoundTag nbt) {
        return this.setItemB(new Stack(item, null, count, nbt));
    }

    public SerializableTrade setItemB(TagKey<Item> tag, Count count, CompoundTag nbt) {
        return this.setItemB(new Stack(null, tag, count, nbt));
    }

    public SerializableTrade setItemB(Stack stack) {
        this.itemB = stack;
        return this;
    }

    public SerializableTrade setResult(Item item, Count count, CompoundTag nbt) {
        return this.setResult(new Stack(item, null, count, nbt));
    }

    public SerializableTrade setResult(TagKey<Item> tag, Count count, CompoundTag nbt) {
        return this.setResult(new Stack(null, tag, count, nbt));
    }

    public SerializableTrade setResult(Stack stack) {
        this.result = stack;
        return this;
    }

    public SerializableTrade setMaxUses(int maxUses) {
        this.maxUses = maxUses;
        return this;
    }

    public SerializableTrade setXp(int xp) {
        this.xp = xp;
        return this;
    }

    public SerializableTrade enchant(Enchantment enchantment, int level) {
        this.enchantments.add(new EnchantmentInstance(enchantment, level));
        return this;
    }

    public SerializableTrade enchantResult(int minLevel, int maxLevel, boolean treasure) {
        this.enchantRandomly = new EnchantRandomly(minLevel, maxLevel, treasure);
        return this;
    }

    public SerializableTrade explorationMap(TagKey<Structure> destination, MapDecoration.Type mapDecoration, byte zoom, int searchRadius, boolean skipKnownStructures) {
        this.explorationMap = new ExplorationMap(destination, mapDecoration, zoom, searchRadius, skipKnownStructures);
        return this;
    }

    @Nullable
    public MerchantOffer m_213663_(@NotNull Entity entity, @NotNull RandomSource random) {
        if (this.invalid || entity.m_9236_().f_46443_) {
            return null;
        }
        ItemStack result = this.result.get(random);
        if (this.enchantRandomly != null) {
            result = EnchantmentHelper.m_220292_((RandomSource)random, (ItemStack)result, (int)random.m_216339_(this.enchantRandomly.minLevel, this.enchantRandomly.maxLevel + 1), (boolean)this.enchantRandomly.treasure);
        }
        for (EnchantmentInstance enchantmentInstance : this.enchantments) {
            if (result.m_150930_(Items.f_42690_)) {
                EnchantedBookItem.m_41153_((ItemStack)result, (EnchantmentInstance)new EnchantmentInstance(enchantmentInstance.f_44947_, enchantmentInstance.f_44948_));
                continue;
            }
            if (result.m_150930_(Items.f_42517_)) {
                CompoundTag tag = result.m_41783_();
                result = new ItemStack((ItemLike)Items.f_42690_, result.m_41613_());
                result.m_41751_(tag);
                EnchantedBookItem.m_41153_((ItemStack)result, (EnchantmentInstance)new EnchantmentInstance(enchantmentInstance.f_44947_, enchantmentInstance.f_44948_));
                continue;
            }
            result.m_41663_(enchantmentInstance.f_44947_, enchantmentInstance.f_44948_);
        }
        if (this.explorationMap != null && result.m_150930_(Items.f_42676_)) {
            Vec3 vec3 = entity.m_20182_();
            ServerLevel serverlevel = (ServerLevel)entity.m_9236_();
            BlockPos blockpos = serverlevel.m_215011_(this.explorationMap.destination, BlockPos.m_274446_((Position)vec3), this.explorationMap.searchRadius, this.explorationMap.skipKnownStructures);
            if (blockpos != null) {
                ItemStack mapResult = MapItem.m_42886_((Level)serverlevel, (int)blockpos.m_123341_(), (int)blockpos.m_123343_(), (byte)this.explorationMap.zoom, (boolean)true, (boolean)true);
                MapItem.m_42850_((ServerLevel)serverlevel, (ItemStack)mapResult);
                MapItemSavedData.m_77925_((ItemStack)mapResult, (BlockPos)blockpos, (String)"+", (MapDecoration.Type)this.explorationMap.mapDecoration);
                if (result.m_41788_()) {
                    mapResult.m_41714_(result.m_41786_());
                }
                result = mapResult;
            }
        }
        ItemStack stackA = this.itemA.get(random);
        ItemStack stackB = ItemStack.f_41583_;
        if (this.itemB != null) {
            stackB = this.itemB.get(random);
        }
        return new MerchantOffer(stackA, stackB, result, this.maxUses, this.xp, 1.0f);
    }

    public boolean isValid() {
        return !this.invalid;
    }

    private static ItemStack stackFromJson(String name, JsonObject jObject, JsonDeserializationContext context) throws JsonParseException {
        if (!jObject.has(name)) {
            return ItemStack.f_41583_;
        }
        String itemString = GsonHelper.m_13906_((JsonObject)jObject, (String)name);
        int count = GsonHelper.m_13824_((JsonObject)jObject, (String)(name + "_count"), (int)1);
        Item item = (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.parse((String)itemString));
        if (item == Items.f_41852_) {
            ISOLogHelper.warn("Item %s for SerializableTrade does not exist, ignoring".formatted(itemString), new Object[0]);
            return ItemStack.f_41583_;
        }
        ItemStack stack = new ItemStack((ItemLike)item, count);
        if (!jObject.has(name + "_tag")) {
            return stack;
        }
        String tagString = GsonHelper.m_13906_((JsonObject)jObject, (String)(name + "_tag"));
        try {
            CompoundTag compoundTag = TagParser.m_129359_((String)tagString);
            stack.m_41751_(compoundTag);
        }
        catch (Exception e) {
            throw new JsonParseException("Failed to parse %s_tag %s".formatted(name, e.getMessage()));
        }
        return stack;
    }

    private static void stackToJson(JsonObject jObject, String name, ItemStack stack, JsonSerializationContext context) throws JsonParseException {
        if (stack.m_41619_()) {
            return;
        }
        jObject.addProperty(name, ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString());
        if (stack.m_41613_() > 1) {
            jObject.addProperty(name + "_count", (Number)stack.m_41613_());
        }
        if (stack.m_41783_() != null) {
            jObject.addProperty(name + "_tag", stack.m_41783_().toString());
        }
    }

    @JsonAdapter(value=Serializer.class)
    public static class Count {
        public static Count ONE = new Count(1);
        public int min;
        public int max;

        public Count(int count) {
            this(count, count);
        }

        public Count(int min, int max) {
            this.min = min;
            this.max = max;
        }

        public static Count of(int min, int max) {
            return new Count(min, max);
        }

        public static Count of(int count) {
            return new Count(count);
        }

        public int get(RandomSource random) {
            if (this.min == this.max) {
                return this.min;
            }
            return Mth.m_216271_((RandomSource)random, (int)this.min, (int)this.max);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Count)) return false;
            Count count = (Count)obj;
            if (this.min != count.min) return false;
            if (this.max != count.max) return false;
            return true;
        }

        public static class Serializer
        implements JsonDeserializer<Count>,
        JsonSerializer<Count> {
            public Count deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                if (json.isJsonPrimitive()) {
                    return new Count(json.getAsInt(), json.getAsInt());
                }
                JsonObject jObject = json.getAsJsonObject();
                return new Count(GsonHelper.m_13927_((JsonObject)jObject, (String)"min"), GsonHelper.m_13927_((JsonObject)jObject, (String)"max"));
            }

            public JsonElement serialize(Count src, Type typeOfSrc, JsonSerializationContext context) {
                if (src.min == src.max) {
                    return new JsonPrimitive((Number)src.min);
                }
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty("min", (Number)src.min);
                jsonObject.addProperty("max", (Number)src.max);
                return jsonObject;
            }
        }
    }

    @JsonAdapter(value=Serializer.class)
    public static class Stack {
        @Nullable
        Item item;
        @Nullable
        TagKey<Item> tag;
        private List<Item> tagCache = new ArrayList<Item>();
        Count count;
        @Nullable
        CompoundTag nbt;

        public Stack(@Nullable Item item, @Nullable TagKey<Item> tag) {
            this(item, tag, Count.ONE);
        }

        public Stack(@Nullable Item item, @Nullable TagKey<Item> tag, Count count) {
            this(item, tag, count, null);
        }

        public Stack(@Nullable Item item, @Nullable TagKey<Item> tag, Count count, @Nullable CompoundTag nbt) {
            this.item = item;
            this.tag = tag;
            this.count = count;
            this.nbt = nbt;
        }

        public ItemStack get(RandomSource random) {
            Item resultItem = this.getItem(random);
            if (resultItem == null || resultItem.equals(Items.f_41852_)) {
                return ItemStack.f_41583_;
            }
            ItemStack itemStack = new ItemStack((ItemLike)resultItem, this.count.get(random));
            if (this.nbt != null) {
                itemStack.m_41751_(this.nbt);
            }
            return itemStack;
        }

        public Item getItem(RandomSource random) {
            if (this.item != null) {
                return this.item;
            }
            if (this.tagCache.isEmpty()) {
                ITag itemTag = ForgeRegistries.ITEMS.tags().getTag(this.tag);
                this.tagCache = itemTag.stream().toList();
            }
            if (this.tagCache.isEmpty()) {
                ISOLogHelper.warn("Tag {} does not exist or is empty", this.tag.f_203868_());
                return Items.f_41852_;
            }
            return this.tagCache.get(random.m_188503_(this.tagCache.size()));
        }

        public static class Serializer
        implements JsonDeserializer<Stack>,
        JsonSerializer<Stack> {
            public Stack deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                TagKey tag = null;
                Item item = null;
                if (json.isJsonPrimitive()) {
                    String itemString = json.getAsString();
                    if (itemString.startsWith("#")) {
                        tag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)ResourceLocation.parse((String)itemString.substring(1)));
                    } else {
                        item = (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.parse((String)itemString));
                        if (item == Items.f_41852_) {
                            ISOLogHelper.warn("Item %s does not exist".formatted(itemString), new Object[0]);
                            return null;
                        }
                    }
                    return new Stack(item, (TagKey<Item>)tag);
                }
                JsonObject jObject = json.getAsJsonObject();
                String itemString = GsonHelper.m_13906_((JsonObject)jObject, (String)"item");
                if (itemString.startsWith("#")) {
                    tag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)ResourceLocation.parse((String)itemString.substring(1)));
                } else {
                    item = (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.parse((String)itemString));
                    if (item == Items.f_41852_) {
                        ISOLogHelper.warn("Item %s does not exist".formatted(itemString), new Object[0]);
                        return null;
                    }
                }
                Count count = (Count)GsonHelper.m_13845_((JsonObject)jObject, (String)"count", (Object)Count.ONE, (JsonDeserializationContext)context, Count.class);
                String tagString = GsonHelper.m_13851_((JsonObject)jObject, (String)"nbt", (String)"");
                Stack stack = new Stack(item, (TagKey<Item>)tag, count);
                if (!tagString.isEmpty()) {
                    try {
                        stack.nbt = TagParser.m_129359_((String)tagString);
                    }
                    catch (Exception e) {
                        throw new JsonParseException("Failed to parse tag %s".formatted(e.getMessage()));
                    }
                }
                return stack;
            }

            public JsonElement serialize(Stack src, Type typeOfSrc, JsonSerializationContext context) {
                if (src.count.equals(Count.ONE) && src.nbt == null) {
                    if (src.item != null) {
                        return new JsonPrimitive(ForgeRegistries.ITEMS.getKey((Object)src.item).toString());
                    }
                    return new JsonPrimitive("#" + String.valueOf(src.tag.f_203868_()));
                }
                JsonObject jsonObject = new JsonObject();
                if (src.item != null) {
                    jsonObject.add("item", (JsonElement)new JsonPrimitive(ForgeRegistries.ITEMS.getKey((Object)src.item).toString()));
                } else {
                    jsonObject.add("item", (JsonElement)new JsonPrimitive("#" + String.valueOf(src.tag.f_203868_())));
                }
                if (!src.count.equals(Count.ONE)) {
                    jsonObject.add("count", context.serialize((Object)src.count));
                }
                if (src.nbt != null) {
                    jsonObject.add("nbt", (JsonElement)new JsonPrimitive(src.nbt.m_7916_()));
                }
                return jsonObject;
            }
        }
    }

    private record EnchantRandomly(int minLevel, int maxLevel, boolean treasure) {
    }

    @JsonAdapter(value=ExplorationMapSerializer.class)
    private record ExplorationMap(TagKey<Structure> destination, MapDecoration.Type mapDecoration, byte zoom, int searchRadius, boolean skipKnownStructures) {
        private static TagKey<Structure> readStructure(JsonObject pJson) {
            String s = GsonHelper.m_13906_((JsonObject)pJson, (String)"destination");
            return TagKey.m_203882_((ResourceKey)Registries.f_256944_, (ResourceLocation)ResourceLocation.parse((String)s));
        }

        public static class ExplorationMapSerializer
        implements JsonDeserializer<ExplorationMap>,
        JsonSerializer<ExplorationMap> {
            public ExplorationMap deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                TagKey<Structure> tagkey = ExplorationMap.readStructure(json.getAsJsonObject());
                String s = json.getAsJsonObject().has("decoration") ? GsonHelper.m_13906_((JsonObject)json.getAsJsonObject(), (String)"decoration") : "mansion";
                MapDecoration.Type mapdecoration$type = ExplorationMapFunction.f_80522_;
                try {
                    mapdecoration$type = MapDecoration.Type.valueOf((String)s.toUpperCase(Locale.ROOT));
                }
                catch (IllegalArgumentException illegalargumentexception) {
                    ISOLogHelper.error("Error while parsing loot table decoration entry. Found {}. Defaulting to {}", s, ExplorationMapFunction.f_80522_);
                }
                byte b0 = GsonHelper.m_13816_((JsonObject)json.getAsJsonObject(), (String)"zoom", (byte)2);
                int i = GsonHelper.m_13824_((JsonObject)json.getAsJsonObject(), (String)"search_radius", (int)50);
                boolean flag = GsonHelper.m_13855_((JsonObject)json.getAsJsonObject(), (String)"skip_existing_chunks", (boolean)true);
                return new ExplorationMap(tagkey, mapdecoration$type, b0, i, flag);
            }

            public JsonElement serialize(ExplorationMap src, Type typeOfSrc, JsonSerializationContext context) {
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty("destination", src.destination.f_203868_().toString());
                if (src.mapDecoration != ExplorationMapFunction.f_80522_) {
                    jsonObject.add("decoration", context.serialize((Object)src.mapDecoration.toString().toLowerCase(Locale.ROOT)));
                }
                if (src.zoom != 2) {
                    jsonObject.addProperty("zoom", (Number)src.zoom);
                }
                if (src.searchRadius != 50) {
                    jsonObject.addProperty("search_radius", (Number)src.searchRadius);
                }
                if (!src.skipKnownStructures) {
                    jsonObject.addProperty("skip_existing_chunks", Boolean.valueOf(src.skipKnownStructures));
                }
                return jsonObject;
            }
        }
    }

    public static class SerializableTradeSerializer
    implements JsonDeserializer<SerializableTrade>,
    JsonSerializer<SerializableTrade> {
        public SerializableTrade deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonArray enchantments;
            JsonObject enchantRandomly;
            JsonObject jObject = json.getAsJsonObject();
            SerializableTrade serializableTrade = new SerializableTrade();
            serializableTrade.itemA = (Stack)GsonHelper.m_13836_((JsonObject)jObject, (String)"item_a", (JsonDeserializationContext)context, Stack.class);
            if (serializableTrade.itemA.item != null && serializableTrade.itemA.item.equals(Items.f_41852_)) {
                serializableTrade.invalid = false;
            }
            serializableTrade.itemB = (Stack)GsonHelper.m_13845_((JsonObject)jObject, (String)"item_b", null, (JsonDeserializationContext)context, Stack.class);
            if (serializableTrade.itemB != null && serializableTrade.itemB.item != null && serializableTrade.itemB.item.equals(Items.f_41852_)) {
                serializableTrade.invalid = false;
            }
            serializableTrade.result = (Stack)GsonHelper.m_13836_((JsonObject)jObject, (String)"result", (JsonDeserializationContext)context, Stack.class);
            if (serializableTrade.result.item != null && serializableTrade.result.item.equals(Items.f_41852_)) {
                serializableTrade.invalid = false;
            }
            if ((enchantRandomly = GsonHelper.m_13841_((JsonObject)jObject, (String)"enchant_randomly", null)) != null) {
                serializableTrade.enchantRandomly = new EnchantRandomly(GsonHelper.m_13927_((JsonObject)enchantRandomly, (String)"min_levels"), GsonHelper.m_13927_((JsonObject)enchantRandomly, (String)"max_levels"), GsonHelper.m_13912_((JsonObject)enchantRandomly, (String)"treasure"));
            }
            if ((enchantments = GsonHelper.m_13832_((JsonObject)jObject, (String)"enchantments", null)) != null) {
                enchantments.asList().forEach(jsonElement -> {
                    String id = GsonHelper.m_13906_((JsonObject)jsonElement.getAsJsonObject(), (String)"id");
                    int level = GsonHelper.m_13824_((JsonObject)jsonElement.getAsJsonObject(), (String)"level", (int)1);
                    serializableTrade.enchantments.add(new EnchantmentInstance((Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(ResourceLocation.m_135820_((String)id)), level));
                });
            }
            if (jObject.has("exploration_map")) {
                serializableTrade.explorationMap = (ExplorationMap)context.deserialize(jObject.get("exploration_map"), ExplorationMap.class);
            }
            serializableTrade.maxUses = GsonHelper.m_13824_((JsonObject)jObject, (String)"max_uses", (int)1);
            serializableTrade.xp = GsonHelper.m_13824_((JsonObject)jObject, (String)"xp", (int)0);
            return serializableTrade;
        }

        public JsonElement serialize(SerializableTrade src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jObject = new JsonObject();
            jObject.add("item_a", context.serialize((Object)src.itemA));
            if (src.itemB != null) {
                jObject.add("item_b", context.serialize((Object)src.itemB));
            }
            jObject.add("result", context.serialize((Object)src.result));
            if (src.enchantRandomly != null) {
                JsonObject enchantRandomly = new JsonObject();
                enchantRandomly.addProperty("min_levels", (Number)src.enchantRandomly.minLevel);
                enchantRandomly.addProperty("max_levels", (Number)src.enchantRandomly.maxLevel);
                enchantRandomly.addProperty("treasure", Boolean.valueOf(src.enchantRandomly.treasure));
                jObject.add("enchant_randomly", (JsonElement)enchantRandomly);
            }
            if (!src.enchantments.isEmpty()) {
                JsonArray jsonArray = new JsonArray();
                src.enchantments.forEach(enchantmentInstance -> {
                    JsonObject enchantmentsObject = new JsonObject();
                    enchantmentsObject.addProperty("id", ForgeRegistries.ENCHANTMENTS.getKey((Object)enchantmentInstance.f_44947_).toString());
                    if (enchantmentInstance.f_44948_ > 1) {
                        enchantmentsObject.addProperty("level", (Number)enchantmentInstance.f_44948_);
                    }
                    jsonArray.add((JsonElement)enchantmentsObject);
                });
                jObject.add("enchantments", (JsonElement)jsonArray);
            }
            if (src.explorationMap != null) {
                jObject.add("exploration_map", context.serialize((Object)src.explorationMap));
            }
            if (src.maxUses != 1) {
                jObject.addProperty("max_uses", (Number)src.maxUses);
            }
            jObject.addProperty("xp", (Number)src.xp);
            return jObject;
        }
    }
}

