/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.mobs.villager.villagers;

import insane96mcp.iguanatweaksreborn.InsaneSO;
import insane96mcp.iguanatweaksreborn.mixin.VillagerDataAccessor;
import insane96mcp.iguanatweaksreborn.module.misc.Packs;
import insane96mcp.iguanatweaksreborn.module.mobs.villager.villagers.VillagerTrade;
import insane96mcp.iguanatweaksreborn.module.mobs.villager.villagers.VillagerTradesReloadListener;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.util.ModNBTData;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.gossip.GossipType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@LoadFeature(module="iguanatweaksreborn:mobs", description="Nerfs to villagers + change their trades via json config")
public class Villagers
extends Feature {
    public static ResourceLocation CURE_DISCOUNT_REMOVED;
    public static ResourceLocation WAS_CONVERTED_ZOMBIE;
    private static final int[] VANILLA_LEVEL_UP_XP;
    @Config(description="If true, villagers will be given 1 trading experience as soon as they choose their job to lock the trades.")
    public static Boolean lockTrades;
    @Config(description="If true, villagers will always be transformed into Zombies no matter the difficulty.")
    public static Boolean alwaysConvertZombie;
    @Config(min=0.0, max=1.0, description="Define a max percentage discount that villagers can give.")
    public static Double maxDiscount;
    @Config(description="If true, discount from curing zombie villagers will only be applied to zombie villagers that were naturally spawned.")
    public static Boolean preventCureDiscount;
    @Config(description="When villagers restock, they update the 'demand'. Demand is a trade modifier that increases the price whenever a trade is done many times, BUT when a trade is not performed, at each restock the 'demand' goes negative, making possible for a trade to never increase it's price due to high negative demand. With this to true, negative demand will be capped at -max_uses of the trade (e.g. Carrot trade from a farmer will have it's minimum demand set to -16).")
    public static Boolean clampNegativeDemand;
    @Config(min=0.0, max=1.0, description="Chance for a nitwit to spawn when two villagers breed")
    public static Double nitwitChance;
    @Config(description="If true, the effect can no longer be applied to entities")
    public static Boolean removeBadOmen;
    @Config(description="Multiplier to experience required by villagers to level up")
    public static Double experienceToLevelUpMultiplier;
    @Config(description="Enables a data pack that changes villagers trades")
    public static Boolean tradesDataPack;
    @Config(description="Disable the loading of villager trades from data packs. This is useful for mods like Numismatic Overhaul that has the same folder structure as ISO")
    public static Boolean loadVillagerTradesFromDataPacks;

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        InsaneSO.addServerPack("villager_trades", "Insane's Survival Overhaul Villager Trades", () -> this.isEnabled() && Packs.disableAllDataPacks == false && tradesDataPack != false);
        CURE_DISCOUNT_REMOVED = this.createDataKey("cure_discount_removed");
        WAS_CONVERTED_ZOMBIE = this.createDataKey("was_converted_zombie");
    }

    public void readConfig(ModConfigEvent event) {
        super.readConfig(event);
        int[] newLevelUpXp = new int[5];
        for (int i = 0; i < newLevelUpXp.length; ++i) {
            newLevelUpXp[i] = (int)((double)VANILLA_LEVEL_UP_XP[i] * experienceToLevelUpMultiplier);
        }
        VillagerDataAccessor.setNextLevelXpThresholds(newLevelUpXp);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onVillagerTradesHighPriority(VillagerTradesEvent event) {
        this.processVillagerTrades(event, false);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onVillagerTradesLowPriority(VillagerTradesEvent event) {
        this.processVillagerTrades(event, true);
    }

    private void processVillagerTrades(VillagerTradesEvent event, boolean isLowPriority) {
        if (!this.isEnabled()) {
            return;
        }
        Int2ObjectMap itemListing = event.getTrades();
        itemListing.forEach((level, value) -> {
            VillagerTrade trades = VillagerTradesReloadListener.INSTANCE.getTradesOfLevel(event.getType(), (int)level);
            if (trades == null || trades.lowPriority != isLowPriority) {
                return;
            }
            if (trades.remove) {
                value.clear();
            }
            value.addAll(trades.trades);
        });
    }

    @SubscribeEvent
    public void onEffectAdded(MobEffectEvent.Applicable event) {
        if (!this.isEnabled() || !removeBadOmen.booleanValue() || event.getEffectInstance().m_19544_() != MobEffects.f_19594_) {
            return;
        }
        event.setResult(Event.Result.DENY);
    }

    @SubscribeEvent
    public void onLivingTick(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity;
        if (!this.isEnabled() || !((livingEntity = event.getEntity()) instanceof Villager)) {
            return;
        }
        Villager villager = (Villager)livingEntity;
        this.tryRemovingCureDiscount(villager);
    }

    public void tryRemovingCureDiscount(Villager villager) {
        if (!preventCureDiscount.booleanValue() || ((Boolean)ModNBTData.get((Entity)villager, (ResourceLocation)CURE_DISCOUNT_REMOVED, Boolean.class)).booleanValue() || !((Boolean)ModNBTData.get((Entity)villager, (ResourceLocation)WAS_CONVERTED_ZOMBIE, Boolean.class)).booleanValue()) {
            return;
        }
        Map gossips = villager.m_35517_().m_148159_();
        gossips.forEach((uuid, gossipTypeObject2IntMap) -> {
            villager.m_35517_().m_148168_(uuid, GossipType.MAJOR_POSITIVE);
            villager.m_35517_().m_148168_(uuid, GossipType.MINOR_POSITIVE);
        });
        ModNBTData.put((Entity)villager, (ResourceLocation)CURE_DISCOUNT_REMOVED, (Object)true);
    }

    public static int clampSpecialPrice(int specialPriceDiff, ItemStack baseCostA) {
        if (!Villagers.isEnabled(Villagers.class) || maxDiscount == 1.0) {
            return specialPriceDiff;
        }
        if (specialPriceDiff < 0 && (double)Mth.m_14040_((int)specialPriceDiff) > (double)baseCostA.m_41613_() * maxDiscount) {
            return Mth.m_14045_((int)specialPriceDiff, (int)((int)((double)baseCostA.m_41613_() * -maxDiscount.doubleValue())), (int)0);
        }
        return specialPriceDiff;
    }

    public static int clampDemand(int demand, int maxUses) {
        if (!Villagers.isEnabled(Villagers.class) || !clampNegativeDemand.booleanValue()) {
            return demand;
        }
        return Math.max(demand, -maxUses);
    }

    public static void lockTrades(Villager villager) {
        if (!Villagers.isEnabled(Villagers.class) || !lockTrades.booleanValue()) {
            return;
        }
        if (villager.m_7809_() == 0) {
            villager.m_35546_(1);
        }
    }

    public static boolean shouldConvertVillagerToZombie() {
        return Villagers.isEnabled(Villagers.class) && alwaysConvertZombie != false;
    }

    public static boolean shouldSpawnAsNitwit(Villager villager) {
        return Feature.isEnabled(Villagers.class) && villager.m_217043_().m_188500_() < nitwitChance;
    }

    static {
        VANILLA_LEVEL_UP_XP = new int[]{0, 10, 70, 150, 250};
        lockTrades = true;
        alwaysConvertZombie = true;
        maxDiscount = 0.5;
        preventCureDiscount = true;
        clampNegativeDemand = true;
        nitwitChance = 0.1;
        removeBadOmen = false;
        experienceToLevelUpMultiplier = 1.3;
        tradesDataPack = true;
        loadVillagerTradesFromDataPacks = true;
    }
}

