/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.movement;

import insane96mcp.iguanatweaksreborn.InsaneSO;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.config.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="iguanatweaksreborn:movement", enabledByDefault=false, description="Prevents the player from placing blocks below him when in mid air.")
public class NoPillaring
extends Feature {
    public static final String NO_PILLARING_MONSTERS_LANG = InsaneSO.lang("no_pillaring_monsters");
    public static final String NO_PILLARING_LANG = InsaneSO.lang("no_pillaring");
    @Config(description="If true, pillaring will be negated only if the last mobs that hit you are nearby")
    public static Boolean engagedMobs = true;
    @Config(description="Range at which monsters must be in order to negate pillaring")
    public static Integer monstersRange = 24;

    @SubscribeEvent
    public void playerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (!this.isEnabled()) {
            return;
        }
        Player player = event.getEntity();
        if (player.m_7500_() || player.m_20069_() || player.m_6147_()) {
            return;
        }
        if (engagedMobs.booleanValue() && !NoPillaring.isAnyCombatEntryMobNearby(player)) {
            return;
        }
        BlockPos placedPos = event.getPos().m_121945_(event.getFace());
        Vec3 placedBlock = new Vec3((double)placedPos.m_123341_() + 0.5, (double)placedPos.m_123342_() + 0.5, (double)placedPos.m_123343_() + 0.5);
        double distance = placedBlock.m_82554_(player.m_20182_());
        double allowedDistance = 1.35;
        boolean isSolidBlock = true;
        if (event.getItemStack().m_41720_() instanceof BlockItem) {
            Block block = ((BlockItem)event.getItemStack().m_41720_()).m_40614_();
            BlockState state = block.m_5573_(new BlockPlaceContext(event.getEntity(), event.getHand(), event.getItemStack(), event.getHitVec()));
            if (state == null) {
                state = block.m_49966_();
            }
            isSolidBlock = state.m_280555_();
        }
        if (isSolidBlock && player.m_5686_(1.0f) > 40.0f && !player.m_20096_() && event.getItemStack().m_41720_() instanceof BlockItem && distance <= allowedDistance && player.m_20186_() > (double)placedPos.m_123342_()) {
            event.setCanceled(true);
            event.setResult(Event.Result.DENY);
            if (engagedMobs.booleanValue()) {
                event.getEntity().m_5661_((Component)Component.m_237115_((String)NO_PILLARING_MONSTERS_LANG), true);
            }
        }
    }

    public static boolean isAnyCombatEntryMobNearby(Player player) {
        return player.m_21231_().f_19276_.stream().anyMatch(entry -> {
            LivingEntity attacker;
            Entity patt3569$temp = entry.f_19250_().m_7639_();
            return patt3569$temp instanceof LivingEntity && player.m_20280_((Entity)(attacker = (LivingEntity)patt3569$temp)) <= (double)(monstersRange * monstersRange);
        });
    }
}

