/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.sleeprespawn;

import insane96mcp.iguanatweaksreborn.data.ISOMobEffectInstance;
import insane96mcp.iguanatweaksreborn.module.sleeprespawn.tiredness.Tiredness;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.JsonFeature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.level.SleepFinishedTimeEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;

@LoadFeature(module="iguanatweaksreborn:sleep_respawn", description="Prevents the player from sleeping if has not enough Hunger and gives him effects on wake up. Effects on wake up are controlled via json in this feature's folder")
public class SleepingEffects
extends JsonFeature {
    public static final List<ISOMobEffectInstance> EFFECTS_ON_WAKE_UP_DEFAULT = List.of();
    public static final ArrayList<ISOMobEffectInstance> effectsOnWakeUp = new ArrayList();
    public static final String NO_FOOD_FOR_SLEEP_LANG = "iguanatweaksreborn.no_food_for_sleep";
    @Config(min=0.0, max=40.0, name="Hunger & Saturation Depleted on Wake Up", description="How much saturation and hunger are depleted when you wake up in the morning. Setting to 0 will disable this feature.")
    public static Integer hungerDepletedOnWakeUp = 12;
    @Config(min=0.0, max=20.0, name="Tired bonus Hunger & Saturation Depleted", description="How much more saturation and hunger are depleted per level of Tired.")
    public static Integer tiredBonusHungerSaturationDepleted = 2;
    @Config(description="If the player's hunger bar is below 'Hunger Depleted on Wake Up' he can't sleep.")
    public static Boolean noSleepIfHungry = true;
    @Config(description="If the player's has the hunger effect he can't sleep.")
    public static Boolean noSleepWithHungerEffect = true;
    @Config(description="If the player has no hunger on wake up, beneficial effects are not applied.")
    public static Boolean noBeneficialEffectWhenHungry = true;
    @Config(min=-1.0, max=255.0, description="Apply the bad effects only when the Tired effect is equal or above this amplifier. -1 to disable")
    public static Integer dizzyWhenToTired = 1;

    public SleepingEffects(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
        this.JSON_CONFIGS.add(new JsonFeature.JsonConfig("effects_on_wake_up.json", effectsOnWakeUp, EFFECTS_ON_WAKE_UP_DEFAULT, ISOMobEffectInstance.LIST_TYPE));
    }

    public String getModConfigFolder() {
        return "config/insanesurvivaloverhaul";
    }

    @SubscribeEvent
    public void wakeUpHungerAndEffects(SleepFinishedTimeEvent event) {
        if (!this.isEnabled() || hungerDepletedOnWakeUp == 0 && effectsOnWakeUp.isEmpty()) {
            return;
        }
        event.getLevel().m_6907_().stream().filter(LivingEntity::m_5803_).toList().forEach(player -> {
            int tiredAmplifier;
            int n = tiredAmplifier = player.m_21124_((MobEffect)Tiredness.TIRED.get()) != null ? player.m_21124_((MobEffect)Tiredness.TIRED.get()).m_19564_() : -1;
            if (!ModList.get().isLoaded("nohunger")) {
                FoodData foodData = player.m_36324_();
                int hungerToDeplete = Math.min(hungerDepletedOnWakeUp + (tiredAmplifier + 1) * tiredBonusHungerSaturationDepleted, 20);
                if (foodData.m_38722_() > 0.0f) {
                    float saturation = foodData.f_38697_;
                    int saturationToDeplete = (int)Math.min((float)hungerToDeplete, saturation);
                    foodData.m_38717_(saturation - (float)saturationToDeplete);
                    hungerToDeplete -= saturationToDeplete;
                }
                if (hungerToDeplete > 0) {
                    int foodToDeplete = Math.min(hungerToDeplete, foodData.f_38696_);
                    foodData.m_38705_(foodData.f_38696_ - foodToDeplete);
                    hungerToDeplete -= foodToDeplete;
                }
            }
            for (ISOMobEffectInstance mobEffectInstance : effectsOnWakeUp) {
                if (noBeneficialEffectWhenHungry.booleanValue() && mobEffectInstance.effect.get().m_19486_() && player.m_36324_().m_38702_() <= 0 || dizzyWhenToTired > -1 && !mobEffectInstance.effect.get().m_19486_() && Feature.isEnabled(Tiredness.class) && tiredAmplifier < dizzyWhenToTired) continue;
                player.m_7292_(mobEffectInstance.getMobEffectInstance());
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void tooHungryToSleep(PlayerSleepInBedEvent event) {
        ServerPlayer player;
        block5: {
            block4: {
                Player player2;
                if (!this.isEnabled() || event.getResultStatus() != null || !noSleepIfHungry.booleanValue() || !((player2 = event.getEntity()) instanceof ServerPlayer)) break block4;
                player = (ServerPlayer)player2;
                if (!player.m_150110_().f_35937_) break block5;
            }
            return;
        }
        if (hungerDepletedOnWakeUp > 0 && player.m_36324_().m_38702_() < hungerDepletedOnWakeUp || noSleepWithHungerEffect.booleanValue() && player.m_21023_(MobEffects.f_19612_)) {
            event.setResult(Player.BedSleepingProblem.OTHER_PROBLEM);
            player.m_5661_((Component)Component.m_237115_((String)NO_FOOD_FOR_SLEEP_LANG), true);
            player.m_9158_(player.m_9236_().m_46472_(), event.getPos(), player.m_146908_(), false, true);
        }
    }
}

