/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.sleeprespawn.death;

import insane96mcp.iguanatweaksreborn.data.generator.ISODamageTypeTagsProvider;
import insane96mcp.iguanatweaksreborn.mixin.client.GuiAccessor;
import insane96mcp.iguanatweaksreborn.module.experience.PlayerExperience;
import insane96mcp.iguanatweaksreborn.module.sleeprespawn.death.GraveBlock;
import insane96mcp.iguanatweaksreborn.module.sleeprespawn.death.GraveBlockEntity;
import insane96mcp.iguanatweaksreborn.setup.ISORegistries;
import insane96mcp.iguanatweaksreborn.setup.registry.SimpleBlockWithItem;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.module.base.TagsFeature;
import insane96mcp.insanelib.util.ModNBTData;
import insane96mcp.insanelib.world.scheduled.ScheduledTasks;
import insane96mcp.insanelib.world.scheduled.ScheduledTickTask;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.RegistryObject;

@LoadFeature(module="iguanatweaksreborn:sleep_respawn", name="Death", description="Add graves on death, and lose items on death. Controlled via game rules. Also adds a bounty system for the mob that killed the player. Graves can be disabled with the iguanatweaks:deathGrave game rule. Items percentage lost can be configured with the iguanatweaks:deathLoseItemsPercentage and iguanatweaks:deathLoseItemsEnchanted game rules.")
public class Death
extends Feature {
    public static final SimpleBlockWithItem GRAVE = SimpleBlockWithItem.register("grave", () -> new GraveBlock(BlockBehaviour.Properties.m_284310_().m_278166_(PushReaction.BLOCK).m_284180_(MapColor.f_283947_).m_280658_(NoteBlockInstrument.BASEDRUM).m_280606_().m_60913_(1.5f, 4.5f)));
    public static final RegistryObject<BlockEntityType<?>> GRAVE_BLOCK_ENTITY_TYPE = ISORegistries.BLOCK_ENTITY_TYPES.register("grave", () -> BlockEntityType.Builder.m_155273_(GraveBlockEntity::new, (Block[])new Block[]{(Block)GRAVE.block().get()}).m_58966_(null));
    public static final GameRules.Key<GameRules.BooleanValue> RULE_DEATHGRAVE = GameRules.m_46189_((String)"iguanatweaks:deathGrave", (GameRules.Category)GameRules.Category.PLAYER, (GameRules.Type)GameRules.BooleanValue.m_46250_((boolean)true));
    public static final GameRules.Key<GameRules.IntegerValue> RULE_DEATHLOSEITEMSPERCENTAGE = GameRules.m_46189_((String)"iguanatweaks:deathLoseItemsPercentage", (GameRules.Category)GameRules.Category.PLAYER, (GameRules.Type)GameRules.IntegerValue.m_46312_((int)0));
    public static final GameRules.Key<GameRules.BooleanValue> RULE_DEATHLOSEITEMSENCHANTED = GameRules.m_46189_((String)"iguanatweaks:deathLoseItemsEnchanted", (GameRules.Category)GameRules.Category.PLAYER, (GameRules.Type)GameRules.BooleanValue.m_46250_((boolean)false));
    public static final TagKey<DamageType> DOESNT_SPAWN_GRAVE = ISODamageTypeTagsProvider.create("doesnt_spawn_grave");
    public static ResourceLocation KILLED_PLAYER;
    public static final String PLAYER_KILLER_LANG = "iguanatweaksreborn.player_killer";
    public static final TagKey<EntityType<?>> KILLER_BLACKLIST;
    @Config(name="Players' killer bounty", description="If true, the player's killer will not despawn and when killed will drop 4x more items and experience.")
    public static Boolean vindicationVsKiller;
    @Config(description="If true, the player's experience is stored in the grave.")
    public static Boolean graveKeepsExperience;
    @Config(description="If true, graves will be placed even if the player has no items/xp.")
    public static Boolean summonGraveEvenWithNoItems;
    @Config(description="In how many ticks will items despawn after dropping from a grave.")
    public static Integer despawnTime;
    @Config(description="If true, players can crouch right-click to take items from graves. Experience still requires breaking the grave.")
    public static Boolean crouchTakeItems;
    @Config(description="If true, only players that generated the grave can crouch right-click to take items from graves.")
    public static Boolean crouchTakeItemsOnlyOwner;

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        KILLED_PLAYER = this.createDataKey("killed_player");
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerDeathEarly(LivingDeathEvent event) {
        LivingEntity livingEntity;
        if (!this.isEnabled() || !((livingEntity = event.getEntity()) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        int lostItemsPercentage = player.m_9236_().m_46469_().m_46215_(RULE_DEATHLOSEITEMSPERCENTAGE);
        boolean lostItemsEnchanted = player.m_9236_().m_46469_().m_46207_(RULE_DEATHLOSEITEMSENCHANTED);
        if (lostItemsPercentage == 0) {
            return;
        }
        if (lostItemsPercentage == 100) {
            player.m_150109_().m_6211_();
        } else {
            Death.tryLoseItems(player.m_150109_(), (List<ItemStack>)player.m_150109_().f_35974_, player.m_217043_(), lostItemsPercentage, lostItemsEnchanted);
            Death.tryLoseItems(player.m_150109_(), (List<ItemStack>)player.m_150109_().f_35975_, player.m_217043_(), lostItemsPercentage, lostItemsEnchanted);
            Death.tryLoseItems(player.m_150109_(), (List<ItemStack>)player.m_150109_().f_35976_, player.m_217043_(), lostItemsPercentage, lostItemsEnchanted);
        }
    }

    private static void tryLoseItems(Inventory inventory, List<ItemStack> items, RandomSource random, int chance, boolean lostItemsEnchanted) {
        items.forEach(item -> {
            if (!lostItemsEnchanted && item.m_41793_()) {
                return;
            }
            if (random.m_188503_(100) < chance) {
                inventory.m_36057_(item);
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerDeath(LivingDeathEvent event) {
        LivingEntity livingEntity;
        if (!this.isEnabled() || !((livingEntity = event.getEntity()) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        Death.trySummonGrave(player, event.getSource());
        Death.vindication(player, event.getSource());
    }

    public static void trySummonGrave(ServerPlayer player, DamageSource source) {
        Death.dropOldGraveContent(player);
        if (!player.m_9236_().m_46469_().m_46207_(GameRules.f_46133_) && player.m_9236_().m_46469_().m_46207_(RULE_DEATHGRAVE) && !player.m_9236_().m_151562_(player.m_20183_().m_123342_())) {
            Death.summonGrave(player, source);
        }
    }

    public static void vindication(final ServerPlayer player, DamageSource source) {
        Mob killer;
        Entity entity;
        if (!vindicationVsKiller.booleanValue() || !((entity = source.m_7639_()) instanceof Mob) || ModNBTData.contains((Entity)(killer = (Mob)entity), (ResourceLocation)KILLED_PLAYER) || killer.m_213877_() || killer.m_21224_() || killer.m_6095_().m_204039_(KILLER_BLACKLIST)) {
            return;
        }
        ScheduledTasks.schedule((ScheduledTickTask)new ScheduledTickTask(1){

            public void run() {
                killer.m_21530_();
                double experienceMultiplier = 5.0;
                if (ModNBTData.contains((Entity)killer, (ResourceLocation)TagsFeature.EXPERIENCE_MULTIPLIER)) {
                    experienceMultiplier *= ((Double)ModNBTData.get((Entity)killer, (ResourceLocation)TagsFeature.EXPERIENCE_MULTIPLIER, Double.class)).doubleValue();
                }
                TagsFeature.setExperienceMultiplier((double)experienceMultiplier, (LivingEntity)killer);
                ModNBTData.put((Entity)killer, (ResourceLocation)KILLED_PLAYER, (Object)player.m_20148_());
                killer.m_6593_((Component)Component.m_237110_((String)Death.PLAYER_KILLER_LANG, (Object[])new Object[]{player.m_36316_().getName(), killer.m_7755_()}).m_130940_(ChatFormatting.GRAY));
            }
        });
    }

    public static void dropOldGraveContent(ServerPlayer player) {
        BlockEntity blockEntity;
        if (player.m_219759_().isEmpty()) {
            return;
        }
        GlobalPos pos = (GlobalPos)player.m_219759_().get();
        if (player.m_20194_() == null) {
            return;
        }
        ServerLevel level = player.m_20194_().m_129880_(pos.m_122640_());
        if (level == null) {
            return;
        }
        if (level.m_46749_(pos.m_122646_()) && (blockEntity = level.m_7702_(pos.m_122646_())) instanceof GraveBlockEntity) {
            GraveBlockEntity graveBlockEntity = (GraveBlockEntity)blockEntity;
            graveBlockEntity.dropContent(pos.m_122646_());
            int chunkX = SectionPos.m_123171_((int)pos.m_122646_().m_123341_());
            int chunkZ = SectionPos.m_123171_((int)pos.m_122646_().m_123343_());
            level.m_8602_(chunkX, chunkZ, false);
        }
    }

    public static void summonGrave(ServerPlayer player, DamageSource source) {
        if (source.m_269533_(DOESNT_SPAWN_GRAVE)) {
            return;
        }
        BlockPos pos = player.m_20183_();
        if (pos.m_123342_() < player.m_9236_().m_141937_()) {
            pos = pos.m_175288_(player.m_9236_().m_141937_() + 1);
        }
        if (player.m_9236_().m_8055_(pos.m_7495_()).m_247087_()) {
            player.m_9236_().m_7731_(pos.m_7495_(), Blocks.f_50546_.m_49966_(), 3);
        }
        BlockState grave = ((Block)GRAVE.block().get()).m_49966_();
        if (player.m_9236_().m_6425_(pos).m_76152_() == Fluids.f_76193_) {
            grave = (BlockState)grave.m_61124_((Property)GraveBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true));
        }
        player.m_9236_().m_46953_(pos, true, (Entity)player);
        player.m_9236_().m_7731_(pos, grave, 3);
        GraveBlockEntity graveBlockEntity = (GraveBlockEntity)player.m_9236_().m_7702_(pos);
        if (graveBlockEntity == null) {
            return;
        }
        if (!(graveBlockEntity.addPlayerItems((Player)player) || player.f_36078_ > 0 && graveKeepsExperience.booleanValue() || summonGraveEvenWithNoItems.booleanValue())) {
            return;
        }
        if (graveKeepsExperience.booleanValue() && player.f_36078_ > 0) {
            int xpDropped = PlayerExperience.getExperienceOnDeath((Player)player, true);
            if (xpDropped == -1) {
                xpDropped = player.m_213860_();
            }
            if (xpDropped > 0) {
                graveBlockEntity.setXpStored(xpDropped);
                player.m_9174_(0);
                player.m_8985_(0);
            }
        }
        graveBlockEntity.setOwner(player.m_20148_());
        graveBlockEntity.setDeathNumber(player.m_8951_().m_13015_(Stats.f_12988_.m_12902_((Object)Stats.f_12935_)) + 1);
        player.m_150109_().m_6211_();
        graveBlockEntity.setMessage(player.m_21231_().m_19293_());
        int chunkX = SectionPos.m_123171_((int)pos.m_123341_());
        int chunkZ = SectionPos.m_123171_((int)pos.m_123343_());
        ((ServerLevel)player.m_9236_()).m_8602_(chunkX, chunkZ, true);
    }

    @SubscribeEvent
    public void onPlayerKillerDeath(LivingDeathEvent event) {
        Mob mob;
        LivingEntity livingEntity;
        if (!(this.isEnabled() && (livingEntity = event.getEntity()) instanceof Mob && (mob = (Mob)livingEntity).m_9236_().m_46469_().m_46207_(GameRules.f_46142_) && ModNBTData.contains((Entity)mob, (ResourceLocation)KILLED_PLAYER) && !mob.m_9236_().f_46443_)) {
            return;
        }
        Component deathMessage = event.getEntity().m_21231_().m_19293_();
        mob.m_9236_().m_7654_().m_6846_().m_240416_(deathMessage, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        GraveBlockEntity graveBlockEntity;
        HitResult hitResult;
        if (event.phase == TickEvent.Phase.END || !event.player.m_9236_().f_46443_ || !((hitResult = Minecraft.m_91087_().f_91077_) instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult blockHitResult = (BlockHitResult)hitResult;
        BlockEntity blockEntity = event.player.m_9236_().m_7702_(blockHitResult.m_82425_());
        if (!(blockEntity instanceof GraveBlockEntity) || (graveBlockEntity = (GraveBlockEntity)blockEntity).getMessage() == null) {
            return;
        }
        event.player.m_5661_(graveBlockEntity.getMessage(), true);
        ((GuiAccessor)Minecraft.m_91087_().f_91065_).setOverlayMessageTime(20);
    }

    static {
        KILLER_BLACKLIST = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"iguanatweaksreborn", (String)"killer_blacklist"));
        vindicationVsKiller = true;
        graveKeepsExperience = true;
        summonGraveEvenWithNoItems = true;
        despawnTime = 3600;
        crouchTakeItems = false;
        crouchTakeItemsOnlyOwner = false;
    }
}

