/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.sleeprespawn.death;

import insane96mcp.iguanatweaksreborn.integration.CuriosIntegration;
import insane96mcp.iguanatweaksreborn.integration.ToolBeltIntegration;
import insane96mcp.iguanatweaksreborn.module.experience.DroppedExperience;
import insane96mcp.iguanatweaksreborn.module.sleeprespawn.death.Death;
import insane96mcp.insanelib.util.ModNBTData;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GraveBlockEntity
extends BlockEntity {
    public static final String ITEMS_TAG = "items";
    public static final String XP_STORED_TAG = "xp_stored";
    public static final String OWNER_TAG = "owner";
    public static final String DEATH_NUMBER_TAG = "death_number";
    public static final String MESSAGE_TAG = "message";
    private List<SlottedStack> items = new ArrayList<SlottedStack>();
    private int xpStored = 0;
    private UUID owner;
    private int deathNumber;
    @Nullable
    private Component message;

    public GraveBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Death.GRAVE_BLOCK_ENTITY_TYPE.get(), pos, state);
    }

    public List<SlottedStack> getItems() {
        return this.items;
    }

    public void setItems(List<SlottedStack> items) {
        this.items = items;
        this.m_6596_();
    }

    public void addItem(ItemStack stack) {
        this.items.add(new SlottedStack(stack));
        this.m_6596_();
    }

    public void addItem(byte slot, ItemStack stack) {
        this.items.add(new SlottedStack(slot, stack));
        this.m_6596_();
    }

    public boolean addPlayerItems(Player player) {
        ItemStack item;
        int i;
        NonNullList itemStacks = player.m_150109_().f_35974_;
        for (i = 0; i < itemStacks.size(); ++i) {
            item = (ItemStack)itemStacks.get(i);
            if (item.m_41619_() || item.getEnchantmentLevel(Enchantments.f_44963_) != 0) continue;
            this.addItem((byte)i, item);
        }
        itemStacks = player.m_150109_().f_35975_;
        for (i = 0; i < itemStacks.size(); ++i) {
            item = (ItemStack)itemStacks.get(i);
            if (item.m_41619_() || item.getEnchantmentLevel(Enchantments.f_44963_) != 0) continue;
            this.addItem((byte)(i + player.m_150109_().f_35974_.size()), item);
        }
        itemStacks = player.m_150109_().f_35976_;
        for (i = 0; i < itemStacks.size(); ++i) {
            item = (ItemStack)itemStacks.get(i);
            if (item.m_41619_() || item.getEnchantmentLevel(Enchantments.f_44963_) != 0) continue;
            this.addItem((byte)(i + player.m_150109_().f_35974_.size() + player.m_150109_().f_35975_.size()), item);
        }
        if (ModList.get().isLoaded("toolbelt")) {
            ToolBeltIntegration.onDeath(this.items, player);
        }
        if (ModList.get().isLoaded("curios")) {
            CuriosIntegration.onDeath(this.items, player);
        }
        this.m_6596_();
        return !this.items.isEmpty();
    }

    public int getXpStored() {
        return this.xpStored;
    }

    public void setXpStored(int xpStored) {
        this.xpStored = xpStored;
        this.m_6596_();
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    public int getDeathNumber() {
        return this.deathNumber;
    }

    public void setDeathNumber(int deathNumber) {
        this.deathNumber = deathNumber;
    }

    public Component getMessage() {
        return this.message;
    }

    public void setMessage(Component message) {
        this.message = message;
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        ListTag itemsList = compoundTag.m_128437_(ITEMS_TAG, 10);
        for (int i = 0; i < itemsList.size(); ++i) {
            CompoundTag slottedStackTag = itemsList.m_128728_(i);
            if (!slottedStackTag.m_128441_("Slot")) {
                this.items.add(new SlottedStack(ItemStack.m_41712_((CompoundTag)slottedStackTag)));
                continue;
            }
            byte j = slottedStackTag.m_128445_("Slot");
            this.items.add(new SlottedStack(j, ItemStack.m_41712_((CompoundTag)slottedStackTag)));
        }
        this.xpStored = compoundTag.m_128451_(XP_STORED_TAG);
        if (compoundTag.m_128441_(OWNER_TAG)) {
            this.owner = compoundTag.m_128342_(OWNER_TAG);
            this.deathNumber = compoundTag.m_128451_(DEATH_NUMBER_TAG);
        }
        if (compoundTag.m_128441_(MESSAGE_TAG)) {
            this.message = Component.Serializer.m_130701_((String)compoundTag.m_128461_(MESSAGE_TAG));
        }
    }

    protected void m_183515_(@NotNull CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        ListTag itemsList = new ListTag();
        for (SlottedStack slottedStack : this.items) {
            CompoundTag itemStackTag = new CompoundTag();
            if (slottedStack.slot != null) {
                itemStackTag.m_128344_("Slot", slottedStack.slot.byteValue());
            }
            slottedStack.stack.m_41739_(itemStackTag);
            itemsList.add((Object)itemStackTag);
        }
        compoundTag.m_128365_(ITEMS_TAG, (Tag)itemsList);
        compoundTag.m_128405_(XP_STORED_TAG, this.xpStored);
        if (this.owner != null) {
            compoundTag.m_128362_(OWNER_TAG, this.owner);
            compoundTag.m_128405_(DEATH_NUMBER_TAG, this.deathNumber);
        }
        if (this.message != null) {
            compoundTag.m_128359_(MESSAGE_TAG, Component.Serializer.m_130703_((Component)this.message));
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos pos, BlockState state, T t) {
        if (level.m_46467_() % 20L != 9L) {
            return;
        }
        GraveBlockEntity graveBlockEntity = (GraveBlockEntity)t;
        if (graveBlockEntity.owner == null) {
            return;
        }
        Optional<ServerPlayer> oPlayer = GraveBlockEntity.getPlayerOwner((ServerLevel)level, graveBlockEntity.owner);
        oPlayer.ifPresent(player -> {
            if (player.m_8951_().m_13015_(Stats.f_12988_.m_12902_((Object)Stats.f_12935_)) != graveBlockEntity.deathNumber) {
                graveBlockEntity.dropContent(pos);
            }
        });
    }

    public void giveContentToPlayer(Player player) {
        this.items.stream().filter(slottedStack -> slottedStack.slot != null).forEach(slottedStack -> {
            if (player.m_150109_().m_8020_((int)slottedStack.slot.byteValue()).m_41619_()) {
                player.m_150109_().m_6836_((int)slottedStack.slot.byteValue(), slottedStack.stack);
            } else {
                slottedStack.invalidateSlot();
            }
        });
        this.items.stream().filter(slottedStack -> slottedStack.slot == null).forEach(slottedStack -> player.m_150109_().m_36054_(slottedStack.stack));
        this.items.clear();
        player.m_9236_().m_6269_(null, (Entity)player, SoundEvents.f_12019_, SoundSource.PLAYERS, 1.0f, 1.0f);
        this.dropExperience(player.m_20183_());
        this.owner = null;
    }

    public void dropContent(BlockPos pos) {
        this.dropExperience(pos);
        this.dropItems(pos);
        this.owner = null;
    }

    public void dropExperience(BlockPos pos) {
        int amount;
        Level level = this.f_58857_;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (amount > 0) {
            int i;
            for (amount = this.getXpStored(); amount > 0; amount -= i) {
                i = ExperienceOrb.m_20782_((int)amount);
                if (ExperienceOrb.m_147096_((ServerLevel)serverLevel, (Vec3)pos.m_252807_(), (int)i)) continue;
                ExperienceOrb xpOrb = new ExperienceOrb(this.f_58857_, pos.m_252807_().f_82479_, pos.m_252807_().f_82480_, pos.m_252807_().f_82481_, i);
                this.f_58857_.m_7967_((Entity)xpOrb);
                ModNBTData.put((Entity)xpOrb, (ResourceLocation)DroppedExperience.XP_PROCESSED, (Object)true);
            }
            this.setXpStored(0);
        }
    }

    public void dropItems(BlockPos pos) {
        this.getItems().forEach(itemStack -> GraveBlockEntity.dropItem(this.f_58857_, itemStack.stack, pos));
        this.getItems().clear();
    }

    public static void dropItem(Level level, ItemStack stack, BlockPos pos) {
        if (stack.m_41619_()) {
            return;
        }
        ItemEntity itementity = new ItemEntity(level, pos.m_252807_().f_82479_, pos.m_252807_().f_82480_ + 0.8, pos.m_252807_().f_82481_, stack);
        itementity.m_32010_(5);
        itementity.lifespan = Death.despawnTime;
        float f = level.f_46441_.m_188501_() * 0.1f;
        float f1 = level.f_46441_.m_188501_() * ((float)Math.PI * 2);
        itementity.m_20334_((double)(-Mth.m_14031_((float)f1) * f), (double)0.1f, (double)(Mth.m_14089_((float)f1) * f));
        level.m_7967_((Entity)itementity);
    }

    public static Optional<ServerPlayer> getPlayerOwner(ServerLevel level, UUID playerUUID) {
        for (ServerPlayer player : level.m_6907_()) {
            UUID uuid = player.m_20148_();
            if (!uuid.equals(playerUUID)) continue;
            return Optional.of(player);
        }
        return Optional.empty();
    }

    public static final class SlottedStack {
        @Nullable
        private Byte slot;
        private final ItemStack stack;

        public SlottedStack(byte slot, ItemStack stack) {
            this.slot = slot;
            this.stack = stack;
        }

        public SlottedStack(ItemStack stack) {
            this.slot = null;
            this.stack = stack;
        }

        @Nullable
        public Byte slot() {
            return this.slot;
        }

        public void invalidateSlot() {
            this.slot = null;
        }

        public ItemStack stack() {
            return this.stack;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            SlottedStack that = (SlottedStack)obj;
            return Objects.equals(this.slot, that.slot) && Objects.equals(this.stack, that.stack);
        }

        public int hashCode() {
            return Objects.hash(this.slot, this.stack);
        }

        public String toString() {
            return "SlottedStack{slot=" + this.slot + ", stack=" + String.valueOf(this.stack) + "}";
        }
    }
}

