/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.sleeprespawn.respawn;

import insane96mcp.iguanatweaksreborn.InsaneSO;
import insane96mcp.iguanatweaksreborn.data.ISOMobEffectInstance;
import insane96mcp.iguanatweaksreborn.data.generator.ISOBlockTagsProvider;
import insane96mcp.iguanatweaksreborn.module.misc.Packs;
import insane96mcp.iguanatweaksreborn.module.sleeprespawn.respawn.RespawnObeliskBlock;
import insane96mcp.iguanatweaksreborn.setup.ISORegistries;
import insane96mcp.iguanatweaksreborn.setup.registry.SimpleBlockWithItem;
import insane96mcp.insanelib.base.JsonFeature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.MinMax;
import insane96mcp.insanelib.data.IdTagValue;
import insane96mcp.insanelib.util.LogHelper;
import insane96mcp.insanelib.world.effect.ILMobEffect;
import insane96mcp.insanelib.world.scheduled.ScheduledTasks;
import insane96mcp.insanelib.world.scheduled.ScheduledTickTask;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerSetSpawnEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.RegistryObject;

@LoadFeature(module="iguanatweaksreborn:sleep_respawn", description="Changes to respawning. Adds the doLooseRespawn gamerule that can disable the loose spawn range")
public class Respawn
extends JsonFeature {
    public static final TagKey<Block> RESPAWN_OBELISK_BLOCKS_TO_ROT = ISOBlockTagsProvider.create("structures/respawn_obelisk/blocks_to_rot");
    public static final RegistryObject<MobEffect> GHOSTLY = ISORegistries.MOB_EFFECTS.register("ghostly", () -> new ILMobEffect(MobEffectCategory.BENEFICIAL, 8747365, true));
    public static final String FAIL_RESPAWN_OBELISK_LANG = "iguanatweaksreborn.fail_respawn_obelisk";
    public static final String LOOSE_WORLD_RESPAWN_POINT = InsaneSO.lang("loose_world_respawn_point");
    public static final String LOOSE_BED_RESPAWN_POINT = InsaneSO.lang("loose_bed_respawn_point");
    public static final GameRules.Key<GameRules.BooleanValue> RULE_RANGEDRESPAWN = GameRules.m_46189_((String)"iguanatweaks:doLooseRespawn", (GameRules.Category)GameRules.Category.PLAYER, (GameRules.Type)GameRules.BooleanValue.m_46250_((boolean)true));
    public static final SimpleBlockWithItem RESPAWN_OBELISK = SimpleBlockWithItem.register("respawn_obelisk", () -> new RespawnObeliskBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60999_().m_60913_(50.0f, 1200.0f).m_60953_(RespawnObeliskBlock::lightLevel)));
    @Config(min=0.0, description="The range from world spawn where players will respawn.")
    public static MinMax looseWorldSpawnRange = new MinMax(128.0, 256.0);
    @Config(min=0.0, description="The range from beds where players will respawn.")
    public static MinMax looseBedSpawnRange = new MinMax(80.0, 160.0);
    @Config(min=0.0, description="How many ticks of the Ghostly effect is given to the player on respawn.")
    public static Integer ghostlyEffect = 120;
    @Config(description="If enabled, respawning will try to place you on land and not in fluids")
    public static Boolean dontRespawnOnFluid = true;
    @Config(description="Data pack that makes respawn obelisks generate in the world")
    public static Boolean respawnObelisks = true;
    @Config(description="If true, sleeping a bed when sneaking will overwrite obelisk spawn point")
    public static Boolean allowObeliskSpawnPointOverwriteWithBedsSneaking = true;
    @Config(description="If true, respawn obelisks will require (and consume) precious blocks to let you respawn")
    public static Boolean respawnObelisksRequireCatalystBlocks = false;
    public static final List<IdTagValue> RESPAWN_OBELISK_CATALYSTS_DEFAULT = List.of(IdTagValue.newId((String)"minecraft:iron_block", (double)0.75), IdTagValue.newId((String)"minecraft:gold_block", (double)0.3), IdTagValue.newId((String)"caverns_and_chasms:silver_block", (double)0.3), IdTagValue.newId((String)"caverns_and_chasms:sanguine_block", (double)0.25), IdTagValue.newId((String)"iguanatweaksexpanded:durium_block", (double)0.075), IdTagValue.newId((String)"minecraft:diamond_block", (double)0.05), IdTagValue.newId((String)"iguanatweaksexpanded:keego_block", (double)0.05), IdTagValue.newId((String)"iguanatweaksexpanded:quaron_block", (double)0.25), IdTagValue.newId((String)"iguanatweaksexpanded:soul_steel_block", (double)0.05), IdTagValue.newId((String)"minecraft:emerald_block", (double)0.35), IdTagValue.newId((String)"minecraft:netherite_block", (double)0.0), IdTagValue.newId((String)"caverns_and_chasms:necromium_block", (double)0.0));
    public static final ArrayList<IdTagValue> respawnObeliskCatalysts = new ArrayList();
    public static final List<ISOMobEffectInstance> RESPAWN_OBELISK_EFFECTS_DEFAULT = List.of(new ISOMobEffectInstance.Builder(MobEffects.f_19605_, 900).noParticles().build(), new ISOMobEffectInstance.Builder(MobEffects.f_19617_, 1200).setAmplifier(1).noParticles().build(), new ISOMobEffectInstance.Builder(MobEffects.f_19596_, 1200).noParticles().build(), new ISOMobEffectInstance.Builder(MobEffects.f_19618_, 400).noParticles().build(), new ISOMobEffectInstance.Builder(() -> GHOSTLY.get(), 1200).noParticles().build());
    public static final ArrayList<ISOMobEffectInstance> respawnObeliskEffects = new ArrayList();

    public Respawn(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
        this.JSON_CONFIGS.add(new JsonFeature.JsonConfig("respawn_obelisk_catalysts.json", respawnObeliskCatalysts, RESPAWN_OBELISK_CATALYSTS_DEFAULT, IdTagValue.LIST_TYPE));
        this.JSON_CONFIGS.add(new JsonFeature.JsonConfig("respawn_obelisk_effects.json", respawnObeliskEffects, RESPAWN_OBELISK_EFFECTS_DEFAULT, ISOMobEffectInstance.LIST_TYPE));
        InsaneSO.addServerPack("respawn_obelisk", "Insane's Survival Overhaul Respawn Obelisk", () -> this.isEnabled() && Packs.disableAllDataPacks == false && respawnObelisks != false);
    }

    public String getModConfigFolder() {
        return "config/insanesurvivaloverhaul";
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (!this.isEnabled() || event.isEndConquered()) {
            return;
        }
        this.tryRespawnObelisk(event);
    }

    public static Optional<Vec3> tryLooseRespawn(ServerLevel level, ServerPlayer player) {
        if (!level.m_46469_().m_46207_(RULE_RANGEDRESPAWN)) {
            return Optional.empty();
        }
        Optional<Vec3> newRespawn = Respawn.looseWorldSpawn(level, player);
        if (newRespawn.isEmpty()) {
            newRespawn = Respawn.looseBedSpawn(level, player);
        }
        return newRespawn;
    }

    private static Optional<Vec3> looseWorldSpawn(ServerLevel level, final ServerPlayer player) {
        if (Respawn.looseWorldSpawnRange.min == 0.0 || player.m_5833_()) {
            return Optional.empty();
        }
        BlockPos pos = player.m_8961_();
        if (pos != null) {
            return Optional.empty();
        }
        BlockPos respawnPos = Respawn.getSpawnPositionInRange(level.m_220360_(), looseWorldSpawnRange, (Level)level, level.f_46441_);
        if (respawnPos == null) {
            return Optional.empty();
        }
        ScheduledTasks.schedule((ScheduledTickTask)new ScheduledTickTask(2){

            public void run() {
                player.m_7292_(new MobEffectInstance((MobEffect)GHOSTLY.get(), ghostlyEffect * 20, 0, false, false, true));
                player.m_213846_((Component)Component.m_237115_((String)LOOSE_WORLD_RESPAWN_POINT));
            }
        });
        return Optional.of(new Vec3((double)respawnPos.m_123341_() + 0.5, (double)respawnPos.m_123342_() + 0.5, (double)respawnPos.m_123343_() + 0.5));
    }

    private static Optional<Vec3> looseBedSpawn(ServerLevel level, final ServerPlayer player) {
        if (Respawn.looseBedSpawnRange.min == 0.0 || player.m_5833_()) {
            return Optional.empty();
        }
        BlockPos pos = player.m_8961_();
        if (pos == null || !level.m_8055_(pos).m_204336_(BlockTags.f_13038_)) {
            return Optional.empty();
        }
        BlockPos respawnPos = Respawn.getSpawnPositionInRange(pos, looseBedSpawnRange, (Level)level, level.f_46441_);
        if (respawnPos == null) {
            return Optional.empty();
        }
        ScheduledTasks.schedule((ScheduledTickTask)new ScheduledTickTask(2){

            public void run() {
                player.m_7292_(new MobEffectInstance((MobEffect)GHOSTLY.get(), ghostlyEffect * 20, 0, false, false, true));
            }
        });
        return Optional.of(new Vec3((double)respawnPos.m_123341_() + 0.5, (double)respawnPos.m_123342_() + 0.5, (double)respawnPos.m_123343_() + 0.5));
    }

    @Nullable
    private static BlockPos getSpawnPositionInRange(BlockPos center, MinMax minMax, Level level, RandomSource random) {
        double minSqr = minMax.min * minMax.min;
        double maxSqr = minMax.max * minMax.max;
        BlockPos.MutableBlockPos respawn = new BlockPos.MutableBlockPos();
        boolean foundValidY = false;
        int triesLeft = 1024;
        while (true) {
            BlockState stateBelow;
            int z;
            int x;
            if ((double)((x = random.m_216339_((int)(-minMax.max), (int)minMax.max)) * x + (z = random.m_216339_((int)(-minMax.max), (int)minMax.max)) * z) > maxSqr || (double)(x * x + z * z) < minSqr) {
                continue;
            }
            int y = level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, center.m_123341_() + x, center.m_123343_() + z);
            if (y < level.m_5736_() + 2) {
                y = level.m_5736_() + 2;
            }
            while (level.m_8055_((BlockPos)respawn.m_122178_(x + center.m_123341_(), y, z + center.m_123343_())).m_280555_()) {
                ++y;
            }
            do {
                respawn.m_122178_(x + center.m_123341_(), y, z + center.m_123343_());
                stateBelow = level.m_8055_(respawn.m_7495_());
                if (stateBelow.m_60819_().m_205070_(FluidTags.f_13132_)) break;
                if (!stateBelow.m_280555_() && stateBelow.m_60819_().m_76178_()) continue;
                foundValidY = true;
                break;
            } while (--y > level.m_141937_());
            if (dontRespawnOnFluid.booleanValue() && !stateBelow.m_60819_().m_76178_()) {
                foundValidY = false;
            }
            if (foundValidY || --triesLeft <= 0) break;
        }
        if (triesLeft <= 0) {
            LogHelper.warn((String)"Failed to find a respawn point within %s", (Object[])new Object[]{center});
            return null;
        }
        return respawn.m_7949_();
    }

    private void tryRespawnObelisk(PlayerEvent.PlayerRespawnEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        BlockPos pos = player.m_8961_();
        if (pos == null || !player.m_9236_().m_8055_(pos).m_60713_((Block)RESPAWN_OBELISK.block().get())) {
            return;
        }
        if (!((Boolean)player.m_9236_().m_8055_(pos).m_61143_((Property)RespawnObeliskBlock.ENABLED)).booleanValue()) {
            player.m_213846_((Component)Component.m_237115_((String)FAIL_RESPAWN_OBELISK_LANG));
            RespawnObeliskBlock.trySetOldSpawn(player);
            return;
        }
        RespawnObeliskBlock.onObeliskRespawn((Player)player, player.m_9236_(), pos);
    }

    @SubscribeEvent
    public void onSetRespawn(PlayerSetSpawnEvent event) {
        if (!this.isEnabled() || event.isForced()) {
            return;
        }
        if (this.onSetSpawnPreventObeliskOverwrite(event)) {
            return;
        }
        this.onSetSpawnLooseMessage(event);
    }

    public void onSetSpawnLooseMessage(PlayerSetSpawnEvent event) {
        if (!event.getEntity().m_9236_().m_46469_().m_46207_(RULE_RANGEDRESPAWN) || Respawn.looseBedSpawnRange.min == 0.0 || event.getNewSpawn() == null || !event.getEntity().m_9236_().m_8055_(event.getNewSpawn()).m_204336_(BlockTags.f_13038_)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.getEntity();
        if (event.getNewSpawn().equals((Object)player.m_8961_())) {
            return;
        }
        player.m_5661_((Component)Component.m_237115_((String)LOOSE_BED_RESPAWN_POINT), false);
    }

    public boolean onSetSpawnPreventObeliskOverwrite(PlayerSetSpawnEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        if (player.m_8961_() == null || !player.m_9236_().m_46472_().equals((Object)player.m_8963_()) || !player.m_9236_().m_8055_(player.m_8961_()).m_60713_((Block)RESPAWN_OBELISK.block().get()) || !((Boolean)player.m_9236_().m_8055_(player.m_8961_()).m_61143_((Property)RespawnObeliskBlock.ENABLED)).booleanValue() || event.getNewSpawn() == null || player.m_9236_().m_8055_(event.getNewSpawn()).m_60713_((Block)RESPAWN_OBELISK.block().get())) {
            return false;
        }
        if (allowObeliskSpawnPointOverwriteWithBedsSneaking.booleanValue()) {
            if (!event.getEntity().m_6047_()) {
                player.m_213846_((Component)Component.m_237115_((String)"iguanatweaksreborn.sneak_to_overwrite"));
            } else {
                return false;
            }
        }
        if (RespawnObeliskBlock.saveOldSpawn(player, event.getNewSpawn(), event.isForced(), 0.0f, (ResourceKey<Level>)event.getSpawnLevel())) {
            player.m_213846_((Component)Component.m_237115_((String)"iguanatweaksreborn.set_old_respawn"));
        }
        event.setCanceled(true);
        return true;
    }

    @SubscribeEvent
    public void onFollowRange(LivingEvent.LivingVisibilityEvent event) {
        if (!event.getEntity().m_21023_((MobEffect)GHOSTLY.get())) {
            return;
        }
        event.modifyVisibility(0.0);
    }
}

