/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.sleeprespawn.respawnpenalties;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.Difficulty;
import insane96mcp.insanelib.util.ModNBTData;
import insane96mcp.insanelib.world.scheduled.ScheduledTasks;
import insane96mcp.insanelib.world.scheduled.ScheduledTickTask;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="iguanatweaksreborn:sleep_respawn", description="Health and hunger penalties on respawn")
public class RespawnPenalties
extends Feature {
    public static ResourceLocation HUNGER_ON_DEATH_TAG;
    public static ResourceLocation SATURATION_ON_DEATH_TAG;
    @Config(min=0.0, max=20.0, description="Min Health of respawning players")
    public static Difficulty health$minimum;
    @Config(min=0.0, max=20.0, description="How much health respawning players lose on respawn (not max health)")
    public static Difficulty health$perDeath;
    @Config(min=0.0, max=20.0, description="Min Hunger of respawning players. If below this value on death will be set to this value")
    public static Difficulty hunger$min;
    @Config(min=0.0, max=20.0, description="Max Hunger of respawning players. If above this value on death will be set to this value")
    public static Difficulty hunger$maximum;
    @Config(min=0.0, max=20.0, description="Min Saturation of respawning players. If below this value on death will be set to this value")
    public static Difficulty saturation$minimum;
    @Config(min=0.0, max=20.0, description="Max Saturation of respawning players. If above this value on death will be set to this value")
    public static Difficulty saturation$maximum;

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        HUNGER_ON_DEATH_TAG = this.createDataKey("hunger_on_death");
        SATURATION_ON_DEATH_TAG = this.createDataKey("saturation_on_death");
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent event) {
        LivingEntity livingEntity;
        if (!this.isEnabled() || !((livingEntity = event.getEntity()) instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        ModNBTData.putPersisted((Player)player, (ResourceLocation)HUNGER_ON_DEATH_TAG, (Object)player.m_36324_().f_38696_);
        ModNBTData.putPersisted((Player)player, (ResourceLocation)SATURATION_ON_DEATH_TAG, (Object)Float.valueOf(player.m_36324_().f_38697_));
    }

    @SubscribeEvent
    public void onPlayerRespawn(final PlayerEvent.PlayerRespawnEvent event) {
        if (!this.isEnabled() || event.isEndConquered()) {
            return;
        }
        ScheduledTasks.schedule((ScheduledTickTask)new ScheduledTickTask(2){

            public void run() {
                Player player = event.getEntity();
                if (!(player instanceof ServerPlayer)) {
                    return;
                }
                ServerPlayer player2 = (ServerPlayer)player;
                int hunger = (Integer)ModNBTData.getPersisted((Player)player2, (ResourceLocation)HUNGER_ON_DEATH_TAG, Integer.class);
                int maxHunger = (int)hunger$maximum.getByDifficulty(player2.m_9236_());
                int minHunger = (int)hunger$min.getByDifficulty(player2.m_9236_());
                player2.m_36324_().f_38696_ = hunger = Mth.m_14045_((int)hunger, (int)minHunger, (int)maxHunger);
                ModNBTData.removePersisted((Player)player2, (ResourceLocation)HUNGER_ON_DEATH_TAG);
                float saturation = ((Float)ModNBTData.getPersisted((Player)player2, (ResourceLocation)SATURATION_ON_DEATH_TAG, Float.class)).floatValue();
                float maxSaturation = (float)saturation$maximum.getByDifficulty(player2.m_9236_());
                float minSaturation = (float)saturation$minimum.getByDifficulty(player2.m_9236_());
                player2.m_36324_().f_38697_ = saturation = Mth.m_14036_((float)saturation, (float)minSaturation, (float)maxSaturation);
                ModNBTData.removePersisted((Player)player2, (ResourceLocation)SATURATION_ON_DEATH_TAG);
                double healthOnRespawn = (double)player2.m_21233_() - health$perDeath.getByDifficulty(player2.m_9236_()) * (double)player2.m_8951_().m_13015_(Stats.f_12988_.m_12902_((Object)Stats.f_12935_));
                double minHealth = health$minimum.getByDifficulty(player2.m_9236_());
                player2.m_21153_((float)Math.max(healthOnRespawn, minHealth));
            }
        });
    }

    static {
        health$minimum = new Difficulty(10.0, 10.0, 6.0);
        health$perDeath = new Difficulty(1.0, 2.0, 2.0);
        hunger$min = new Difficulty(6.0, 6.0, 6.0);
        hunger$maximum = new Difficulty(14.0, 14.0, 10.0);
        saturation$minimum = new Difficulty(6.0, 6.0, 6.0);
        saturation$maximum = new Difficulty(10.0, 10.0, 6.0);
    }
}

