/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.world;

import insane96mcp.iguanatweaksreborn.InsaneSO;
import insane96mcp.iguanatweaksreborn.module.misc.Packs;
import insane96mcp.iguanatweaksreborn.setup.ISORegistries;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.RegistryObject;

@LoadFeature(module="iguanatweaksreborn:world")
public class Berries
extends Feature {
    public static final RegistryObject<BlockItem> SWEET_BERRY_SEEDS = ISORegistries.ITEMS.register("sweet_berry_seeds", () -> new ItemNameBlockItem(Blocks.f_50685_, new Item.Properties()));
    @Config(description="Berry bushes no longer deal damage when walking in them with leggings and boots")
    public static Boolean noDamageIfDressed = true;
    @Config(description="\tMakes sweet berries not plantable, requiring seeds, and also enables a data pack that makes the following changes:\n\t* Makes sweet berry bushes drop seeds\n\t* Makes sweet berry patches has less plants and plants will not be all grown up\n\tIf berry good is present, a different datapack is enabled that integrates with the mod\n")
    public static Boolean dataPack = true;

    public Berries(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
        InsaneSO.addServerPack("berries", "Insane's Survival Overhaul Berries", () -> this.isEnabled() && Packs.disableAllDataPacks == false && dataPack != false && !ModList.get().isLoaded("berry_good"));
        InsaneSO.addServerPack("berries_berry_good", "Insane's Survival Overhaul Berries (Berry Good compat)", () -> this.isEnabled() && Packs.disableAllDataPacks == false && dataPack != false && ModList.get().isLoaded("berry_good"));
    }

    @SubscribeEvent
    public void onBushesDamage(LivingAttackEvent event) {
        if (!this.isEnabled() || !noDamageIfDressed.booleanValue() || !event.getSource().m_276093_(DamageTypes.f_268469_) || event.getEntity().m_6844_(EquipmentSlot.LEGS).m_41619_() || event.getEntity().m_6844_(EquipmentSlot.FEET).m_41619_()) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void onTryToPlant(PlayerInteractEvent.RightClickBlock event) {
        if (!this.isEnabled() || !dataPack.booleanValue()) {
            return;
        }
        BlockState stateClicked = event.getLevel().m_8055_(event.getHitVec().m_82425_());
        if (event.getItemStack().m_150930_(Items.f_42780_) && ((BushBlock)Blocks.f_50685_).m_7898_(stateClicked, (LevelReader)event.getLevel(), event.getPos())) {
            event.setCanceled(true);
        }
    }
}

