/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.world.coalfire;

import insane96mcp.iguanatweaksreborn.InsaneSO;
import insane96mcp.iguanatweaksreborn.module.misc.Packs;
import insane96mcp.iguanatweaksreborn.module.world.coalfire.FirestarterItem;
import insane96mcp.iguanatweaksreborn.setup.ISORegistries;
import insane96mcp.iguanatweaksreborn.setup.registry.SimpleBlockWithItem;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.event.BlockBurntEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.RegistryObject;

@LoadFeature(module="iguanatweaksreborn:world", name="Coal & Fire")
public class CoalFire
extends Feature {
    public static final SimpleBlockWithItem BURNT_LOG = SimpleBlockWithItem.register("burnt_log", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_284310_().m_284495_(p_152624_ -> MapColor.f_283771_).m_280658_(NoteBlockInstrument.BASS).m_60978_(1.0f).m_60918_(SoundType.f_56736_)));
    public static final RegistryObject<Item> FIRESTARTER = ISORegistries.ITEMS.register("firestarter", () -> new FirestarterItem(new Item.Properties().m_41487_(1).m_41499_(11)));
    public static final GameRules.Key<GameRules.IntegerValue> RULE_FIRESPEEDMULTIPLIER = GameRules.m_46189_((String)"iguanatweaks:fireSpeedMultiplier", (GameRules.Category)GameRules.Category.UPDATES, (GameRules.Type)GameRules.IntegerValue.m_46312_((int)4));
    @Config(min=0.0, max=1.0, description="Chance for logs to yield burnt logs when burnt")
    public static Double burntLogsChance = 0.8;
    @Config(description="If enabled, a data pack will be enabled that:\n* Removes the Charcoal recipe from smelting\n* Makes Coal Ore require an Iron Pickaxe or better to mine\n* Replaces Flint and Steel in the overworld with firestarter\n* Changes flint and steel recipe to require blaze powder")
    public static Boolean noCharcoalSmeltingAndIronCoal = true;
    @Config(description="If true, two flints (on per hand) can start a fire")
    public static Boolean twoFlintFireStarter$enabled = true;
    @Config(min=0.0, max=1.0, description="Chance to ignite a block when using two flints")
    public static Double twoFlintFireStarter$igniteChance = 0.35;
    @Config(min=0.0, max=1.0, description="Chance for the flint to break when using two flints")
    public static Double twoFlintFireStarter$breakChance = 0.3;
    @Config(description="If true, campfires must be lit")
    public static Boolean unlitCampfires = true;
    @Config(description="If true, campfires will be extinguished when it starts to rain")
    public static Boolean campfireTurnOffUnderRain = true;

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        InsaneSO.addServerPack("coal_fire", "Insane's Survival Overhaul No Charcoal Smelting and Iron Coal", () -> this.isEnabled() && Packs.disableAllDataPacks == false && noCharcoalSmeltingAndIronCoal != false);
    }

    public static boolean areCampfiresUnlit() {
        return Feature.isEnabled(CoalFire.class) && unlitCampfires != false;
    }

    public static boolean canRainTurnOffCampfires() {
        return Feature.isEnabled(CoalFire.class) && campfireTurnOffUnderRain != false;
    }

    @SubscribeEvent
    public void onBlockBurnt(BlockBurntEvent event) {
        if (!this.isEnabled() || burntLogsChance == 0.0) {
            return;
        }
        if (event.getLevel().m_213780_().m_188500_() < burntLogsChance && event.getState().m_204336_(BlockTags.f_13105_)) {
            FallingBlockEntity.m_201971_((Level)((Level)event.getLevel()), (BlockPos)event.getPos(), (BlockState)((Block)BURNT_LOG.block().get()).m_49966_());
        }
    }

    @SubscribeEvent
    public void onBlockRightClicked(PlayerInteractEvent.RightClickBlock event) {
        if (!this.isEnabled() || !twoFlintFireStarter$enabled.booleanValue() || event.getHand() != InteractionHand.MAIN_HAND || !event.getItemStack().m_150930_(Items.f_42484_) || !event.getEntity().m_21206_().m_150930_(Items.f_42484_) || event.getEntity().m_36335_().m_41519_(Items.f_42484_) || event.getLevel().f_46443_) {
            return;
        }
        double ignite = event.getEntity().m_217043_().m_188500_();
        event.getEntity().m_21011_(event.getHand(), true);
        event.setCanceled(true);
        event.getEntity().m_36335_().m_41524_(event.getItemStack().m_41720_(), 15);
        if (ignite < twoFlintFireStarter$igniteChance) {
            BlockPos blockpos;
            UseOnContext context = new UseOnContext(event.getEntity(), event.getHand(), new BlockHitResult(event.getHitVec().m_82450_(), event.getHitVec().m_82434_(), event.getPos(), event.getHitVec().m_82436_()));
            Player player = context.m_43723_();
            Level level = context.m_43725_();
            BlockState blockstate = level.m_8055_(blockpos = context.m_8083_());
            if (!(CampfireBlock.m_51321_((BlockState)blockstate) || CandleBlock.m_152845_((BlockState)blockstate) || CandleCakeBlock.m_152910_((BlockState)blockstate))) {
                BlockPos clickedPos = blockpos.m_121945_(context.m_43719_());
                if (BaseFireBlock.m_49255_((Level)level, (BlockPos)clickedPos, (Direction)context.m_8125_())) {
                    BlockState state = BaseFireBlock.m_49245_((BlockGetter)level, (BlockPos)clickedPos);
                    level.m_7731_(clickedPos, state, 11);
                    level.m_142346_((Entity)player, GameEvent.f_157797_, blockpos);
                }
            } else {
                level.m_7731_(blockpos, (BlockState)blockstate.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.TRUE), 11);
                level.m_142346_((Entity)player, GameEvent.f_157792_, blockpos);
            }
            event.getLevel().m_5594_(null, event.getPos(), SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, event.getLevel().m_213780_().m_188501_() * 0.4f + 0.8f);
        } else {
            event.getLevel().m_5594_(null, event.getPos(), SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, event.getLevel().m_213780_().m_188501_() * 0.4f + 1.5f);
        }
        if (!event.getEntity().m_7500_()) {
            CoalFire.tryBreakFlint(event.getEntity(), event.getHand(), event.getItemStack());
            CoalFire.tryBreakFlint(event.getEntity(), InteractionHand.OFF_HAND, event.getEntity().m_21206_());
        }
    }

    private static void tryBreakFlint(Player player, InteractionHand hand, ItemStack stack) {
        if (player.m_217043_().m_188500_() >= twoFlintFireStarter$breakChance) {
            return;
        }
        stack.m_41774_(1);
        player.m_21190_(hand);
        ForgeEventFactory.onPlayerDestroyItem((Player)player, (ItemStack)stack, (InteractionHand)hand);
    }
}

