/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.world.explosionoverhaul;

import com.teamabnormals.caverns_and_chasms.core.registry.CCEntityTypes;
import insane96mcp.iguanatweaksreborn.InsaneSO;
import insane96mcp.iguanatweaksreborn.data.generator.ISOBlockTagsProvider;
import insane96mcp.iguanatweaksreborn.module.world.explosionoverhaul.ISOExplosion;
import insane96mcp.iguanatweaksreborn.network.message.ExplodeParticles;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.util.ModNBTData;
import javax.annotation.Nullable;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;

@LoadFeature(module="iguanatweaksreborn:world", description="Various changes to explosions, like higher knockback and getting hit when behind blown up blocks.")
public class ExplosionOverhaul
extends Feature {
    public static ResourceLocation BASE_RESISTANCE_ADD_TAG;
    public static ResourceLocation RAY_STRENGTH_MULTIPLIER_TAG;
    public static ResourceLocation KNOCKBACK_MULTIPLIER_TAG;
    public static ResourceLocation DAMAGE_MULTIPLIER_TAG;
    public static final TagKey<EntityType<?>> KNOCKBACK_BLACKLIST;
    public static final TagKey<EntityType<?>> ENTITY_BLACKLIST;
    public static final TagKey<Block> FLYING_BLOCKS_EXPLOSION_BLACKLIST;
    public static final GameRules.Key<GameRules.BooleanValue> RULE_MOBGRIEFING;
    @Config(description="Vanilla Explosions use a random number that changes the explosion power. With this enabled the ray strength will be as the explosion size.")
    public static Boolean disableExplosionRandomness;
    @Config(description="Somewhere around 1.15 Mojang (for performance issues) removed the poof particles from Explosions. Keep them disabled if you have a low end PC.\nThese particles aren't shown when explosion power is <= 1")
    public static Boolean enablePoofParticles;
    @Config(description="Removes the particles spawned by the explosion.")
    public static Boolean disableEmitterParticles;
    @Config(description="While enabled knockback is greatly increased by explosion size")
    public static Boolean knockbackScalesWithSize;
    @Config(description="Explosions will generate from the middle of the entity instead of bottom of their bounding box.")
    public static Boolean explosionAtHalfEntity;
    @Config(description="EXPERIMENTAL! This will make explosion blast blocks away. Blocks that can't land will drop the block as a TNT would have destroyed it.")
    public static Boolean enableFlyingBlocks;
    @Config(description="If true, creepers explosions will drop no blocks.")
    public static Boolean creeperCollateral;
    @Config
    public static Double knockbackMultiplier;
    @Config(description="Number in the explosion damage calculation. Vanilla is 7. Higher = More damage")
    public static Double explosionDamageCalculationMultiplier;
    @Config(description="Disabled if set to 0.")
    public static Integer limitExplosionSize;
    @Config(name="Don't stack drops", description="Like pre-1.14")
    public static Boolean dontStackDrops;
    @Config(description="If true, potion effects from the exploder will be applied to the damaged entities")
    public static Boolean applyEffectFromExploder;
    @Config(name="Don't apply to non-entities", description="If true, the overhaul will not be applied for explosions generated by non-entities. E.g. Supplementaries gunpowder")
    public static Boolean dontApplyToNonEntities;
    @Config(description="If enabled and Caverns and Chasms is present, Deepers explosions will pierce through blocks more (like Breaching creepers and Angry Creepers in Enhanced AI), knockback and damage are reduced by 40%.")
    public static Boolean cavernsChasmsDeepers;

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        BASE_RESISTANCE_ADD_TAG = this.createDataKey("base_resistance_add");
        RAY_STRENGTH_MULTIPLIER_TAG = this.createDataKey("ray_strength_multiplier");
        KNOCKBACK_MULTIPLIER_TAG = this.createDataKey("knockback_multiplier");
        DAMAGE_MULTIPLIER_TAG = this.createDataKey("damage_multiplier");
    }

    @SubscribeEvent
    public void onDeeperSpawn(EntityJoinLevelEvent event) {
        if (!(this.isEnabled() && cavernsChasmsDeepers.booleanValue() && ModList.get().isLoaded("caverns_and_chasms") && event.getEntity().m_6095_() == CCEntityTypes.DEEPER.get())) {
            return;
        }
        ExplosionOverhaul.setBaseResistanceAdd(event.getEntity(), 0.0f);
        ExplosionOverhaul.setKnockbackMultiplier(event.getEntity(), 0.6f);
        ExplosionOverhaul.setDamageMultiplierTag(event.getEntity(), 0.75f);
    }

    @SubscribeEvent
    public void explosionPoofParticles(ExplosionEvent.Detonate event) {
        if (!this.isEnabled() || !enablePoofParticles.booleanValue()) {
            return;
        }
        Explosion e = event.getExplosion();
        Level level = e.f_46012_;
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (e instanceof ISOExplosion) {
                ISOExplosion isoExplosion = (ISOExplosion)e;
                if (!isoExplosion.poofParticles) {
                    return;
                }
                ExplodeParticles.sync(level2, isoExplosion);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void replaceExplosionWithITRExplosion(ExplosionEvent.Start event) {
        ServerLevel level;
        block6: {
            block5: {
                Level level2;
                if (!this.isEnabled() || !((level2 = event.getLevel()) instanceof ServerLevel)) break block5;
                level = (ServerLevel)level2;
                if (event.getExplosion().getExploder() == null || !event.getExplosion().getExploder().m_6095_().m_204039_(ENTITY_BLACKLIST)) break block6;
            }
            return;
        }
        if (event.getExplosion().getExploder() == null && dontApplyToNonEntities.booleanValue()) {
            return;
        }
        event.setCanceled(true);
        Explosion e = event.getExplosion();
        double y = e.getPosition().f_82480_;
        if (e.f_46016_ != null && explosionAtHalfEntity.booleanValue()) {
            y += (double)e.f_46016_.m_20206_() / 2.0;
        }
        ISOExplosion.explode(level, e.f_46016_, e.m_46077_(), e.f_46019_, e.getPosition().f_82479_, y, e.getPosition().f_82481_, e.f_46017_, e.f_46009_, e.f_46010_, true);
    }

    public static boolean shouldTakeReducedKnockback(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return true;
        }
        return entity.m_6095_().m_204039_(KNOCKBACK_BLACKLIST);
    }

    public static void setBaseResistanceAdd(Entity entity, float baseResistanceAdd) {
        ModNBTData.put((Entity)entity, (ResourceLocation)BASE_RESISTANCE_ADD_TAG, (Object)Float.valueOf(baseResistanceAdd));
    }

    public static float getBaseResistanceAdd(@Nullable Entity entity) {
        return entity != null && ModNBTData.contains((Entity)entity, (ResourceLocation)BASE_RESISTANCE_ADD_TAG) ? ((Float)ModNBTData.get((Entity)entity, (ResourceLocation)BASE_RESISTANCE_ADD_TAG, Float.class)).floatValue() : 0.3f;
    }

    public static void setRayStrengthMultiplier(Entity entity, float rayStrengthMultiplier) {
        ModNBTData.put((Entity)entity, (ResourceLocation)RAY_STRENGTH_MULTIPLIER_TAG, (Object)Float.valueOf(rayStrengthMultiplier));
    }

    public static float getRayStrengthMultiplier(@Nullable Entity entity) {
        return entity != null && ModNBTData.contains((Entity)entity, (ResourceLocation)RAY_STRENGTH_MULTIPLIER_TAG) ? ((Float)ModNBTData.get((Entity)entity, (ResourceLocation)RAY_STRENGTH_MULTIPLIER_TAG, Float.class)).floatValue() : 0.3f;
    }

    public static void setKnockbackMultiplier(Entity entity, float knockbackMultiplier) {
        ModNBTData.put((Entity)entity, (ResourceLocation)KNOCKBACK_MULTIPLIER_TAG, (Object)Float.valueOf(knockbackMultiplier));
    }

    public static float getKnockbackMultiplier(@Nullable Entity entity) {
        return entity != null && ModNBTData.contains((Entity)entity, (ResourceLocation)KNOCKBACK_MULTIPLIER_TAG) ? ((Float)ModNBTData.get((Entity)entity, (ResourceLocation)KNOCKBACK_MULTIPLIER_TAG, Float.class)).floatValue() : 1.0f;
    }

    public static void setDamageMultiplierTag(Entity entity, float damageMultiplier) {
        ModNBTData.put((Entity)entity, (ResourceLocation)DAMAGE_MULTIPLIER_TAG, (Object)Float.valueOf(damageMultiplier));
    }

    public static float getDamageMultiplier(@Nullable Entity entity) {
        return entity != null && ModNBTData.contains((Entity)entity, (ResourceLocation)DAMAGE_MULTIPLIER_TAG) ? ((Float)ModNBTData.get((Entity)entity, (ResourceLocation)DAMAGE_MULTIPLIER_TAG, Float.class)).floatValue() : 1.0f;
    }

    static {
        KNOCKBACK_BLACKLIST = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)InsaneSO.location("explosion_knockback_blacklist"));
        ENTITY_BLACKLIST = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)InsaneSO.location("explosion_entity_blacklist"));
        FLYING_BLOCKS_EXPLOSION_BLACKLIST = ISOBlockTagsProvider.create("flying_blocks_explosion_blacklist");
        RULE_MOBGRIEFING = GameRules.m_46189_((String)"iguanatweaks:explosionMobGriefing", (GameRules.Category)GameRules.Category.MISC, (GameRules.Type)GameRules.BooleanValue.m_46250_((boolean)true));
        disableExplosionRandomness = true;
        enablePoofParticles = true;
        disableEmitterParticles = true;
        knockbackScalesWithSize = true;
        explosionAtHalfEntity = true;
        enableFlyingBlocks = false;
        creeperCollateral = false;
        knockbackMultiplier = 1.0;
        explosionDamageCalculationMultiplier = 6.0;
        limitExplosionSize = 12;
        dontStackDrops = true;
        applyEffectFromExploder = true;
        dontApplyToNonEntities = true;
        cavernsChasmsDeepers = false;
    }
}

