/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.world.explosionoverhaul;

import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import insane96mcp.iguanatweaksreborn.entity.ISOFallingBlockEntity;
import insane96mcp.iguanatweaksreborn.event.ISOEventFactory;
import insane96mcp.iguanatweaksreborn.module.experience.enchantments.EnchantmentsFeature;
import insane96mcp.iguanatweaksreborn.module.world.explosionoverhaul.ExplosionOverhaul;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.piston.MovingPistonBlock;
import net.minecraft.world.level.block.piston.PistonMovingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.ForgeEventFactory;

public class ISOExplosion
extends Explosion {
    ObjectArrayList<Pair<ItemStack, BlockPos>> droppedItems = new ObjectArrayList();
    boolean creeperCollateral;
    public final boolean poofParticles;
    private float baseResistanceAdd = 0.3f;
    private float rayStrengthMultiplier = 0.3f;
    private List<Entity> affectedEntities = new ArrayList<Entity>();

    public ISOExplosion(Level level, @Nullable Entity source, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator damageCalculator, double x, double y, double z, float radius, boolean fire, Explosion.BlockInteraction blockInteraction, boolean creeperCollateral) {
        this(level, source, damageSource, damageCalculator, x, y, z, radius, fire, blockInteraction, creeperCollateral, true);
    }

    public ISOExplosion(Level level, @Nullable Entity source, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator damageCalculator, double x, double y, double z, float radius, boolean fire, Explosion.BlockInteraction blockInteraction, boolean creeperCollateral, boolean poofParticles) {
        super(level, source, damageSource, damageCalculator, x, y, z, radius, fire, blockInteraction);
        this.creeperCollateral = creeperCollateral;
        this.poofParticles = poofParticles;
        this.baseResistanceAdd = ExplosionOverhaul.getBaseResistanceAdd(source);
        this.rayStrengthMultiplier = Math.max(0.01f, ExplosionOverhaul.getRayStrengthMultiplier(source));
        if (ExplosionOverhaul.limitExplosionSize != 0) {
            this.f_46017_ = Math.min((float)ExplosionOverhaul.limitExplosionSize.intValue(), this.f_46017_);
        }
    }

    public void gatherAffectedBlocks(boolean randomize) {
        HashSet set = Sets.newHashSet();
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                for (int l = 0; l < 16; ++l) {
                    if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                    double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double x = this.getPosition().m_7096_();
                    double y = this.getPosition().m_7098_();
                    double z = this.getPosition().m_7094_();
                    for (float rayStrength = !randomize ? this.f_46017_ : this.f_46017_ * (0.7f + this.f_46012_.m_213780_().m_188501_() * 0.6f); rayStrength > 0.0f; rayStrength -= 0.22500001f) {
                        FluidState fluidstate;
                        BlockState blockstate;
                        BlockPos blockpos = BlockPos.m_274561_((double)x, (double)y, (double)z);
                        Optional optional = this.f_46019_.m_6617_((Explosion)this, (BlockGetter)this.f_46012_, blockpos, blockstate = this.f_46012_.m_8055_(blockpos), fluidstate = this.f_46012_.m_6425_(blockpos));
                        if (optional.isPresent()) {
                            float resistance = ((Float)optional.get()).floatValue();
                            rayStrength -= (resistance + this.baseResistanceAdd) * this.rayStrengthMultiplier;
                        }
                        if (rayStrength > 0.0f && this.f_46019_.m_6714_((Explosion)this, (BlockGetter)this.f_46012_, blockpos, blockstate, rayStrength)) {
                            set.add(blockpos);
                        }
                        x += d0 * (double)0.3f;
                        y += d1 * (double)0.3f;
                        z += d2 * (double)0.3f;
                    }
                }
            }
        }
        this.m_46081_().addAll(set);
        float affectedEntitiesRadius = this.f_46017_ * 2.0f;
        this.gatherAffectedEntities(affectedEntitiesRadius);
        ForgeEventFactory.onExplosionDetonate((Level)this.f_46012_, (Explosion)this, this.affectedEntities, (double)affectedEntitiesRadius);
    }

    public void fallingBlocks() {
        if (!this.m_254884_()) {
            return;
        }
        ArrayList<BlockPos> toClear = new ArrayList<BlockPos>();
        for (BlockPos blockpos : this.m_46081_()) {
            BlockState blockstate = this.f_46012_.m_8055_(blockpos);
            Block block = blockstate.m_60734_();
            if (blockstate.m_60795_() || blockstate.m_204336_(ExplosionOverhaul.FLYING_BLOCKS_EXPLOSION_BLACKLIST)) continue;
            if (block instanceof MovingPistonBlock) {
                PistonMovingBlockEntity tileEntity = (PistonMovingBlockEntity)this.f_46012_.m_7702_(blockpos);
                blockstate = tileEntity.m_60400_();
                block = blockstate.m_60734_();
            }
            block.m_7592_(this.f_46012_, BlockPos.m_274446_((Position)this.getPosition()), (Explosion)this);
            BlockPos blockpos1 = blockpos.m_7949_();
            this.f_46012_.m_46597_(blockpos1, Blocks.f_50016_.m_49966_());
            ISOFallingBlockEntity fallingBlockEntity = new ISOFallingBlockEntity(this.f_46012_, (float)blockpos1.m_123341_() + 0.5f, (float)blockpos1.m_123342_() + 2.0625f, (float)blockpos1.m_123343_() + 0.5f, blockstate);
            fallingBlockEntity.f_31942_ = 1;
            fallingBlockEntity.source = this.f_46016_;
            this.f_46012_.m_7967_((Entity)fallingBlockEntity);
            this.affectedEntities.add((Entity)fallingBlockEntity);
            toClear.add(blockpos);
        }
        this.f_46020_.removeAll(toClear);
    }

    public void processEntities() {
        float affectedEntitiesRadius = this.f_46017_ * 2.0f;
        for (Entity entity : this.affectedEntities) {
            Player player;
            Entity entity2;
            double zDistance;
            double yDistance;
            double xDistance;
            double d13;
            double distanceRatio;
            if (entity.f_19797_ == 0 && !(entity instanceof PartEntity) && !(entity instanceof ISOFallingBlockEntity) || entity.m_6128_() || (distanceRatio = (double)(Mth.m_14116_((float)((float)entity.m_20238_(this.getPosition()))) / affectedEntitiesRadius)) > 1.0 || (d13 = (double)Mth.m_14116_((float)((float)((xDistance = entity.m_20185_() - this.getPosition().f_82479_) * xDistance + (yDistance = entity.m_20188_() - this.getPosition().f_82480_) * yDistance + (zDistance = entity.m_20189_() - this.getPosition().f_82481_) * zDistance)))) == 0.0) continue;
            if (!(entity instanceof ISOFallingBlockEntity)) {
                yDistance /= d13;
            }
            double blockDensity = ISOExplosion.m_46064_((Vec3)this.getPosition(), (Entity)entity);
            double d10 = (1.0 - distanceRatio) * blockDensity;
            float damageAmount = (int)((d10 * d10 + d10) / 2.0 * ExplosionOverhaul.explosionDamageCalculationMultiplier * (double)affectedEntitiesRadius + 1.0);
            damageAmount *= ExplosionOverhaul.getDamageMultiplier(this.f_46016_);
            if (!(blockDensity > 0.0)) continue;
            DamageSource source = this.m_46077_();
            boolean isBlocking = false;
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                isBlocking = living.m_21275_(source) && living.m_21254_();
            }
            boolean isLiving = entity instanceof LivingEntity;
            if (!entity.m_6469_(source, damageAmount) && !isBlocking && isLiving) continue;
            double d11 = d10;
            if (isLiving) {
                d11 = ISOExplosion.getKnockbackReduction((LivingEntity)entity, d11);
            }
            if ((entity2 = this.m_46077_().m_7640_()) instanceof LivingEntity) {
                LivingEntity directExploder = (LivingEntity)entity2;
                if (ExplosionOverhaul.applyEffectFromExploder.booleanValue() && isLiving) {
                    directExploder.m_21220_().forEach(effect -> ((LivingEntity)entity).m_7292_(new MobEffectInstance(effect.m_19544_(), (int)((double)effect.m_19557_() * d10), effect.m_19564_(), effect.m_19571_(), effect.m_19572_(), effect.m_19575_())));
                }
            }
            if (ExplosionOverhaul.knockbackScalesWithSize.booleanValue()) {
                d11 *= (double)this.f_46017_;
            }
            d11 = Math.max(d11, (double)this.f_46017_ * 0.05);
            if (entity instanceof ISOFallingBlockEntity || ExplosionOverhaul.shouldTakeReducedKnockback(entity)) {
                d11 *= 0.2;
            }
            d11 *= (double)ExplosionOverhaul.getKnockbackMultiplier(this.f_46016_);
            d11 *= ExplosionOverhaul.knockbackMultiplier.doubleValue();
            d11 = Math.min(d11, 10.0);
            if (entity instanceof ISOFallingBlockEntity) {
                d11 = Math.min(d11, 1.0);
                xDistance += (double)(this.f_46012_.m_213780_().m_188501_() - 0.5f);
                zDistance += (double)(this.f_46012_.m_213780_().m_188501_() - 0.5f);
            }
            double y = yDistance * d11;
            if (isLiving) {
                y = Math.max(y, (double)(0.1f * this.f_46017_));
            }
            entity.m_20256_(entity.m_20184_().m_82520_(xDistance * d11, y, zDistance * d11));
            if (!(entity instanceof Player) || (player = (Player)entity).m_5833_() || player.m_7500_() && player.m_150110_().f_35935_) continue;
            this.m_46078_().put(player, new Vec3(xDistance * d11, Math.max(yDistance * d11, (double)(0.1f * this.f_46017_)), zDistance * d11));
        }
    }

    public void destroyBlocks() {
        this.f_46012_.m_220400_(this.f_46016_, GameEvent.f_157812_, new Vec3(this.getPosition().f_82479_, this.getPosition().f_82480_, this.getPosition().f_82481_));
        if (!this.m_254884_()) {
            return;
        }
        Util.m_214673_((ObjectArrayList)this.f_46020_, (RandomSource)this.f_46012_.m_213780_());
        for (BlockPos blockpos : this.m_46081_()) {
            BlockState blockstate = this.f_46012_.m_8055_(blockpos);
            FluidState fluidState = this.f_46012_.m_6425_(blockpos);
            if (blockstate.m_60795_()) continue;
            BlockPos immutableBlockPos = blockpos.m_7949_();
            this.f_46012_.m_46473_().m_6180_("explosion_blocks");
            if (!this.doesCreeperCollateralApply() && blockstate.canDropFromExplosion((BlockGetter)this.f_46012_, blockpos, (Explosion)this) && this.f_46012_ instanceof ServerLevel) {
                BlockEntity blockEntity = blockstate.m_155947_() ? this.f_46012_.m_7702_(blockpos) : null;
                LootParams.Builder lootparams$builder = new LootParams.Builder((ServerLevel)this.f_46012_).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)blockpos)).m_287286_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_287289_(LootContextParams.f_81462_, (Object)blockEntity).m_287289_(LootContextParams.f_81455_, (Object)this.f_46016_);
                if (this.f_46010_ == Explosion.BlockInteraction.DESTROY_WITH_DECAY) {
                    lootparams$builder.m_287286_(LootContextParams.f_81464_, (Object)Float.valueOf(this.f_46017_));
                }
                blockstate.m_287290_(lootparams$builder).forEach(stack -> ISOExplosion.m_46067_(this.droppedItems, stack, immutableBlockPos));
            }
            blockstate.onBlockExploded(this.f_46012_, blockpos, (Explosion)this);
            if (!fluidState.m_76178_()) {
                this.f_46012_.m_7731_(blockpos, fluidState.m_76188_(), 3);
            }
            this.f_46012_.m_46473_().m_7238_();
        }
    }

    public static void m_46067_(ObjectArrayList<Pair<ItemStack, BlockPos>> pDropPositionArray, ItemStack stack, BlockPos pos) {
        int pairCount = pDropPositionArray.size();
        if (!ExplosionOverhaul.dontStackDrops.booleanValue()) {
            for (int i = 0; i < pairCount; ++i) {
                Pair pair = (Pair)pDropPositionArray.get(i);
                ItemStack pairStack = (ItemStack)pair.getFirst();
                if (!ItemEntity.m_32026_((ItemStack)pairStack, (ItemStack)stack)) continue;
                ItemStack mergedStack = ItemEntity.m_32029_((ItemStack)pairStack, (ItemStack)stack, (int)16);
                pDropPositionArray.set(i, (Object)Pair.of((Object)mergedStack, (Object)((BlockPos)pair.getSecond())));
                if (!stack.m_41619_()) continue;
                return;
            }
        }
        pDropPositionArray.add((Object)Pair.of((Object)stack, (Object)pos));
    }

    public boolean doesCreeperCollateralApply() {
        return this.creeperCollateral && this.getExploder() instanceof Creeper;
    }

    public void dropItems() {
        for (Pair pair : this.droppedItems) {
            Block.m_49840_((Level)this.f_46012_, (BlockPos)((BlockPos)pair.getSecond()), (ItemStack)((ItemStack)pair.getFirst()));
        }
    }

    public void processFire() {
        if (this.f_46009_) {
            for (BlockPos blockPos : this.m_46081_()) {
                if (this.f_46011_.m_188503_(3) != 0 || !this.f_46012_.m_8055_(blockPos).m_60795_() || !this.f_46012_.m_8055_(blockPos.m_7495_()).m_60804_((BlockGetter)this.f_46012_, blockPos.m_7495_())) continue;
                this.f_46012_.m_46597_(blockPos, BaseFireBlock.m_49245_((BlockGetter)this.f_46012_, (BlockPos)blockPos));
            }
        }
    }

    private void gatherAffectedEntities(float affectedRadius) {
        int x1 = Mth.m_14107_((double)(this.getPosition().m_7096_() - (double)affectedRadius - 1.0));
        int x2 = Mth.m_14107_((double)(this.getPosition().m_7096_() + (double)affectedRadius + 1.0));
        int y1 = Mth.m_14107_((double)(this.getPosition().m_7098_() - (double)affectedRadius - 1.0));
        int y2 = Mth.m_14107_((double)(this.getPosition().m_7098_() + (double)affectedRadius + 1.0));
        int z1 = Mth.m_14107_((double)(this.getPosition().m_7094_() - (double)affectedRadius - 1.0));
        int z2 = Mth.m_14107_((double)(this.getPosition().m_7094_() + (double)affectedRadius + 1.0));
        this.affectedEntities = this.f_46012_.m_45933_(this.f_46016_, new AABB((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2));
    }

    public static double getKnockbackReduction(LivingEntity livingEntity, double knockback) {
        double knockbackReduction = 0.0;
        int blastProtLevel = EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44968_, (LivingEntity)livingEntity) + EnchantmentHelper.m_44836_((Enchantment)((Enchantment)EnchantmentsFeature.BLAST_PROTECTION.get()), (LivingEntity)livingEntity);
        if (blastProtLevel > 0) {
            knockbackReduction += (double)blastProtLevel * 0.15;
        }
        if (livingEntity.m_21051_(Attributes.f_22278_) != null) {
            knockbackReduction += livingEntity.m_21051_(Attributes.f_22278_).m_22135_();
        }
        return knockback - knockback * Mth.m_14008_((double)knockbackReduction, (double)0.0, (double)1.0);
    }

    @Nullable
    public static ISOExplosion explode(Level level, @Nullable Entity source, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator damageCalculator, double x, double y, double z, float radius, boolean fire, Level.ExplosionInteraction explosionInteraction, boolean poofParticles) {
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Explosion.BlockInteraction blockInteraction = switch (explosionInteraction) {
            default -> throw new IncompatibleClassChangeError();
            case Level.ExplosionInteraction.NONE -> Explosion.BlockInteraction.KEEP;
            case Level.ExplosionInteraction.BLOCK -> {
                if (level.m_46469_().m_46207_(GameRules.f_254629_)) {
                    yield Explosion.BlockInteraction.DESTROY_WITH_DECAY;
                }
                yield Explosion.BlockInteraction.DESTROY;
            }
            case Level.ExplosionInteraction.MOB -> {
                if (ForgeEventFactory.getMobGriefingEvent((Level)level, (Entity)source)) {
                    if (level.m_46469_().m_46207_(GameRules.f_254692_)) {
                        yield Explosion.BlockInteraction.DESTROY_WITH_DECAY;
                    }
                    yield Explosion.BlockInteraction.DESTROY;
                }
                yield Explosion.BlockInteraction.KEEP;
            }
            case Level.ExplosionInteraction.TNT -> level.m_46469_().m_46207_(GameRules.f_254705_) ? Explosion.BlockInteraction.DESTROY_WITH_DECAY : Explosion.BlockInteraction.DESTROY;
        };
        return ISOExplosion.explode(serverLevel, source, damageSource, damageCalculator, x, y, z, radius, fire, blockInteraction, poofParticles);
    }

    public static ISOExplosion explode(ServerLevel level, @Nullable Entity source, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator damageCalculator, double x, double y, double z, float radius, boolean fire, Explosion.BlockInteraction blockInteraction, boolean poofParticles) {
        ISOExplosion explosion = new ISOExplosion((Level)level, source, damageSource, damageCalculator, x, y, z, radius, fire, blockInteraction, ExplosionOverhaul.creeperCollateral, poofParticles);
        if (ISOEventFactory.onITRExplosionCreated(explosion)) {
            return explosion;
        }
        if (level.m_46469_().m_46207_(ExplosionOverhaul.RULE_MOBGRIEFING)) {
            explosion.gatherAffectedBlocks(ExplosionOverhaul.disableExplosionRandomness == false);
        }
        if (ExplosionOverhaul.enableFlyingBlocks.booleanValue()) {
            explosion.fallingBlocks();
        }
        explosion.destroyBlocks();
        explosion.processEntities();
        explosion.dropItems();
        explosion.processFire();
        if (explosion.f_46010_ == Explosion.BlockInteraction.KEEP) {
            explosion.m_46080_();
        }
        for (ServerPlayer serverPlayer : level.m_6907_()) {
            if (!(serverPlayer.m_20275_(explosion.getPosition().f_82479_, explosion.getPosition().f_82480_, explosion.getPosition().f_82481_) < 4096.0)) continue;
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundExplodePacket(explosion.getPosition().f_82479_, explosion.getPosition().f_82480_, explosion.getPosition().f_82481_, explosion.f_46017_, explosion.m_46081_(), (Vec3)explosion.m_46078_().get(serverPlayer)));
        }
        return explosion;
    }
}

