/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.world.seasons;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.reflect.TypeToken;
import insane96mcp.iguanatweaksreborn.InsaneSO;
import insane96mcp.iguanatweaksreborn.data.generator.ISOBlockTagsProvider;
import insane96mcp.iguanatweaksreborn.event.HookTickToHookLureEvent;
import insane96mcp.iguanatweaksreborn.event.TideHookTickToHookLureEvent;
import insane96mcp.iguanatweaksreborn.module.misc.Packs;
import insane96mcp.iguanatweaksreborn.module.world.seasons.TimeControlIntegration;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.JsonFeature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonChangedEvent;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.init.ModConfig;
import sereneseasons.season.SeasonHandler;
import sereneseasons.season.SeasonSavedData;
import sereneseasons.season.SeasonTime;

@LoadFeature(module="iguanatweaksreborn:world", requiresMods={"sereneseasons"}, description="Change a few things relative to Serene Seasons. Grass and tall grass decays in Winter and regrows back in Spring. Saplings are also transformed into Dead Bushes. This can be disabled with the iguanatweaks:doSeasonGrassGrowDeath game rule", enabledByDefault=false)
public class Seasons
extends JsonFeature {
    public static final GameRules.Key<GameRules.BooleanValue> RULE_SEASONGRASSGROWDEATH = GameRules.m_46189_((String)"iguanatweaks:doSeasonGrassGrowDeath", (GameRules.Category)GameRules.Category.PLAYER, (GameRules.Type)GameRules.BooleanValue.m_46250_((boolean)true));
    public static final TagKey<Block> PLANTS_TO_DECAY = ISOBlockTagsProvider.create("plants_to_decay");
    public static final TagKey<Block> PLANTS_TO_DEAD_BUSH = ISOBlockTagsProvider.create("plants_to_dead_bush");
    @Config(description="Makes the following changes to Serene Seasons config:\n* seasonal_crops is set to false, as it's controlled by Plants Growth\n* Sets the starting season to the one in 'Starting season'")
    public static Boolean changeSereneSeasonsConfig = true;
    @Config(description="Removes greenhouse glass.")
    public static Boolean noGreenHouseGlass = true;
    @Config(description="Changes what leaves can drop in different seasons.\nSapling no longer drop in winter\nApples only drop in spring")
    public static Boolean leavesDrops = true;
    @Config(description="Has no effect if 'Serene Seasons changes' is disabled")
    public static Season.SubSeason startingSeason = Season.SubSeason.EARLY_SUMMER;
    @Config(min=0.0, description="How many minutes will day and night duration be (with this set to 10 the day will last 10 minutes and the night 10 minutes for a grand total of 20 minutes). This also adjusts the day_duration config option in Serene Seasons. Vanilla is 10. Requires Time Control mod")
    public static Double timeControlDayNightDuration = 15.0;
    @Config(min=0.0, description="How many minutes will day and night duration be shifted based off seasons? E.g. in Mid spring / autumn the duration of day and night is vanilla, when moving off those seasons day and night will last this many minutes more/less. In mid summer / winter the duration of day and night duration will be more / less by 3 times this value. Set to 0 to disable. Requires Time Control mod")
    public static Double timeControlDayNightShift = 1.5;
    @Config
    public static Boolean slowdownGrassSpreading = true;
    @Config
    public static Boolean seasonBasedFishingTime = true;
    @Config
    public static Boolean growDoubleTallGrass = true;
    @Config
    public static Boolean growFlowersFromGrass = false;
    public static final ArrayList<GrassTickingData> GRASS_GROWTH_DECAY_DEFAULT = new ArrayList<GrassTickingData>(List.of(new GrassTickingData(Season.SubSeason.EARLY_SPRING, 1000, GrassTickingType.GROW, 12, false, false), new GrassTickingData(Season.SubSeason.MID_SPRING, 1000, GrassTickingType.GROW, 12, false, true), new GrassTickingData(Season.SubSeason.LATE_SPRING, 1000, GrassTickingType.GROW, 12, false, true), new GrassTickingData(Season.SubSeason.EARLY_SUMMER, 2000, GrassTickingType.GROW, 10, true, true), new GrassTickingData(Season.SubSeason.MID_SUMMER, 2000, GrassTickingType.GROW, 8, true, false), new GrassTickingData(Season.SubSeason.LATE_SUMMER, 2000, GrassTickingType.GROW, 7, true, false), new GrassTickingData(Season.SubSeason.EARLY_AUTUMN, 2000, GrassTickingType.DECAY, 0, false, false), new GrassTickingData(Season.SubSeason.MID_AUTUMN, 1000, GrassTickingType.DECAY, 0, false, false), new GrassTickingData(Season.SubSeason.LATE_AUTUMN, 500, GrassTickingType.DECAY, 0, false, false), new GrassTickingData(Season.SubSeason.EARLY_WINTER, 200, GrassTickingType.DECAY, 0, false, false), new GrassTickingData(Season.SubSeason.MID_WINTER, 100, GrassTickingType.DECAY, 0, false, false), new GrassTickingData(Season.SubSeason.LATE_WINTER, 400, GrassTickingType.DECAY, 0, false, false)));
    public static final ArrayList<GrassTickingData> grassGrowthDecay = new ArrayList();

    public void init(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super.init(module, enabledByDefault, canBeDisabled);
        InsaneSO.addServerPack("serene_seasons_changes", "Insane's Survival Overhaul Serene Seasons Changes", () -> this.isEnabled() && Packs.disableAllDataPacks == false && noGreenHouseGlass != false);
        InsaneSO.addServerPack("leaves_drops", "Insane's Survival Overhaul Leaves Drops", () -> this.isEnabled() && Packs.disableAllDataPacks == false && leavesDrops != false);
        if (ModList.get().isLoaded("tide")) {
            MinecraftForge.EVENT_BUS.addListener(Seasons::shouldTideSlowdownFishing);
        }
        this.JSON_CONFIGS.add(new JsonFeature.JsonConfig("grass_growth_decay.json", grassGrowthDecay, GRASS_GROWTH_DECAY_DEFAULT, GrassTickingData.LIST_TYPE));
    }

    public String getModConfigFolder() {
        return "config/insanesurvivaloverhaul";
    }

    public void readConfig(ModConfigEvent event) {
        super.readConfig(event);
        if (this.isEnabled() && changeSereneSeasonsConfig.booleanValue()) {
            ModConfig.fertility.set("general.seasonal_crops", (Object)false);
        }
    }

    public boolean isEnabled() {
        return super.isEnabled() && ModList.get().isLoaded("sereneseasons");
    }

    public static boolean shouldSlowdownGrassSpreading(LevelReader level) {
        if (!Feature.isEnabled(Seasons.class) || !slowdownGrassSpreading.booleanValue()) {
            return false;
        }
        Season season = SeasonHelper.getSeasonState((Level)((Level)level)).getSeason();
        double failChance = switch (season) {
            default -> throw new IncompatibleClassChangeError();
            case Season.SPRING, Season.SUMMER -> 0.0;
            case Season.AUTUMN -> 0.3;
            case Season.WINTER -> 0.75;
        };
        return ((Level)level).f_46441_.m_188500_() < failChance;
    }

    public static void onSeasonChanged(SeasonChangedEvent.Standard event) {
        if (!Feature.isEnabled(Seasons.class) || timeControlDayNightShift == 0.0 || !ModConfig.seasons.isDimensionWhitelisted(event.getLevel().m_46472_())) {
            return;
        }
        if (ModList.get().isLoaded("timecontrol")) {
            TimeControlIntegration.updateDayNightLength((Season.SubSeason)event.getNewSeason());
        }
    }

    @SubscribeEvent
    public void onServerStart(ServerStartedEvent event) {
        if (changeSereneSeasonsConfig.booleanValue()) {
            ModConfig.seasons.set("time_settings.progress_season_while_offline", (Object)false);
        }
        if (ModList.get().isLoaded("timecontrol") && timeControlDayNightDuration != 10.0) {
            ModConfig.seasons.set("time_settings.day_duration", (Object)((int)(timeControlDayNightDuration * 60.0 * 20.0 * 2.0)));
            ModConfig.seasons.dayDuration = (int)(timeControlDayNightDuration * 60.0 * 20.0 * 2.0);
        }
    }

    @SubscribeEvent
    public void onPreLevelTick(TickEvent.LevelTickEvent event) {
        if (!event.level.f_46443_ && event.level.m_46467_() == 0L && changeSereneSeasonsConfig.booleanValue()) {
            SeasonSavedData seasonData = SeasonHandler.getSeasonSavedData((Level)event.level);
            seasonData.seasonCycleTicks = SeasonTime.ZERO.getSubSeasonDuration() * startingSeason.ordinal();
            seasonData.m_77762_();
            SeasonHandler.sendSeasonUpdate((Level)event.level);
            if (ModList.get().isLoaded("timecontrol")) {
                TimeControlIntegration.updateDayNightLength(startingSeason);
            }
        }
    }

    public static void tickPlantLifeDeath(BlockState state, BlockPos pos, ServerLevel level) {
        Season.SubSeason subSeason = SeasonHelper.getSeasonState((Level)level).getSubSeason();
        Optional<GrassTickingData> oData = GrassTickingData.get(subSeason);
        if (oData.isEmpty() || !oData.get().shouldTick((Level)level)) {
            return;
        }
        GrassTickingData data = oData.get();
        if (level.m_45517_(LightLayer.SKY, pos) < data.lightLevel) {
            return;
        }
        if (data.grassTickingType == GrassTickingType.DECAY && (state.m_204336_(PLANTS_TO_DECAY) || state.m_204336_(PLANTS_TO_DEAD_BUSH)) && level.m_213780_().m_188503_(data.chance) == 0) {
            if (state.m_204336_(PLANTS_TO_DECAY)) {
                level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            } else if (state.m_204336_(PLANTS_TO_DEAD_BUSH)) {
                level.m_7731_(pos, Blocks.f_50036_.m_49966_(), 3);
            }
        } else if (data.grassTickingType == GrassTickingType.GROW) {
            if (state.m_60795_() && level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50440_) && level.m_213780_().m_188503_(data.chance) == 0) {
                Optional oPlacedFeature = level.m_9598_().m_175515_(Registries.f_256988_).m_203636_(VegetationPlacements.f_195459_);
                oPlacedFeature.ifPresent(placedFeatureReference -> ((PlacedFeature)placedFeatureReference.m_203334_()).m_226357_((WorldGenLevel)level, level.m_7726_().m_8481_(), level.f_46441_, pos));
            } else if (state.m_60713_(Blocks.f_50034_) || state.m_60713_(Blocks.f_50035_)) {
                List list;
                if (growDoubleTallGrass.booleanValue() && data.canGrowTall && level.m_8055_(pos.m_7494_()).m_247087_() && level.m_213780_().m_188503_(data.chance) == 0) {
                    if (state.m_60713_(Blocks.f_50034_)) {
                        DoublePlantBlock.m_153173_((LevelAccessor)level, (BlockState)Blocks.f_50359_.m_49966_(), (BlockPos)pos, (int)3);
                    } else if (state.m_60713_(Blocks.f_50035_)) {
                        DoublePlantBlock.m_153173_((LevelAccessor)level, (BlockState)Blocks.f_50360_.m_49966_(), (BlockPos)pos, (int)3);
                    }
                } else if (growFlowersFromGrass.booleanValue() && data.canGrowFlower && level.m_213780_().m_188503_(data.chance * 10) == 0 && !(list = ((Biome)level.m_204166_(pos).m_203334_()).m_47536_().m_47815_()).isEmpty()) {
                    Holder holder = ((RandomPatchConfiguration)((ConfiguredFeature)list.get(0)).f_65378_()).f_191304_();
                    level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                    ((PlacedFeature)holder.m_203334_()).m_226357_((WorldGenLevel)level, level.m_7726_().m_8481_(), level.f_46441_, pos);
                }
            }
        }
    }

    @SubscribeEvent
    public void shouldSlowdownFishing(HookTickToHookLureEvent event) {
        if (event.getType() != HookTickToHookLureEvent.Type.LURE) {
            return;
        }
        int slowdown = Seasons.slowdownFishing(event.getHookEntity().m_9236_());
        event.setTick(event.getTick() + slowdown);
    }

    public static void shouldTideSlowdownFishing(TideHookTickToHookLureEvent event) {
        if (event.getType() != TideHookTickToHookLureEvent.Type.LURE) {
            return;
        }
        int slowdown = Seasons.slowdownFishing(event.getHookEntity().m_9236_());
        event.setTick(event.getTick() + slowdown);
    }

    public static int slowdownFishing(Level level) {
        if (!Feature.isEnabled(Seasons.class) || !seasonBasedFishingTime.booleanValue()) {
            return 0;
        }
        Season season = SeasonHelper.getSeasonState((Level)level).getSeason();
        return switch (season) {
            default -> throw new IncompatibleClassChangeError();
            case Season.SPRING -> 0;
            case Season.SUMMER -> 200;
            case Season.AUTUMN -> 100;
            case Season.WINTER -> 600;
        };
    }

    public static float getDayNightCycleModifier() {
        return Feature.isEnabled(Seasons.class) && ModList.get().isLoaded("timecontrol") ? timeControlDayNightDuration.floatValue() / 10.0f : 1.0f;
    }

    public static float getDayDuration() {
        return Feature.isEnabled(Seasons.class) && ModList.get().isLoaded("timecontrol") ? timeControlDayNightDuration.floatValue() * 2.0f : 20.0f;
    }

    @JsonAdapter(value=Serializer.class)
    public record GrassTickingData(Season.SubSeason subSeason, int chance, GrassTickingType grassTickingType, int lightLevel, boolean canGrowTall, boolean canGrowFlower) {
        public static final Type LIST_TYPE = new TypeToken<ArrayList<GrassTickingData>>(){}.getType();

        public boolean shouldTick(Level level) {
            return this.chance > 0 && (this.grassTickingType == GrassTickingType.DECAY || level.m_46461_());
        }

        public static Optional<GrassTickingData> get(Season.SubSeason subSeason) {
            for (GrassTickingData grassTickingData : grassGrowthDecay) {
                if (grassTickingData.subSeason != subSeason) continue;
                return Optional.of(grassTickingData);
            }
            return Optional.empty();
        }

        public static class Serializer
        implements JsonDeserializer<GrassTickingData>,
        JsonSerializer<GrassTickingData> {
            public GrassTickingData deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonObject jObject = json.getAsJsonObject();
                String subSeasonStr = jObject.get("sub_season").getAsString().toUpperCase();
                Season.SubSeason subSeason = null;
                try {
                    subSeason = Season.SubSeason.valueOf((String)subSeasonStr);
                }
                catch (IllegalArgumentException e) {
                    throw new JsonParseException("Unknown sub_season: " + subSeasonStr, (Throwable)e);
                }
                int chance = GsonHelper.m_13927_((JsonObject)jObject, (String)"chance");
                GrassTickingType grassTickingType = (GrassTickingType)((Object)context.deserialize(jObject.get("grass_ticking_type"), GrassTickingType.class));
                int lightLevel = GsonHelper.m_13824_((JsonObject)jObject, (String)"light_level", (int)0);
                boolean canGrowTall = GsonHelper.m_13855_((JsonObject)jObject, (String)"can_grow_tall", (boolean)false);
                boolean canGrowFlower = GsonHelper.m_13855_((JsonObject)jObject, (String)"can_grow_flower", (boolean)false);
                return new GrassTickingData(subSeason, chance, grassTickingType, lightLevel, canGrowTall, canGrowFlower);
            }

            public JsonElement serialize(GrassTickingData src, Type typeOfSrc, JsonSerializationContext context) {
                JsonObject jsonObject = new JsonObject();
                jsonObject.addProperty("sub_season", src.subSeason.name().toLowerCase(Locale.ROOT));
                jsonObject.addProperty("chance", (Number)src.chance);
                jsonObject.add("grass_ticking_type", context.serialize((Object)src.grassTickingType));
                if (src.lightLevel > 0) {
                    jsonObject.addProperty("light_level", (Number)src.lightLevel);
                }
                if (src.canGrowTall) {
                    jsonObject.addProperty("can_grow_tall", Boolean.valueOf(true));
                }
                if (src.canGrowFlower) {
                    jsonObject.addProperty("can_grow_flower", Boolean.valueOf(true));
                }
                return jsonObject;
            }
        }
    }

    public static enum GrassTickingType {
        GROW,
        DECAY;

    }
}

