/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.world.spawners;

import insane96mcp.iguanatweaksreborn.InsaneSO;
import insane96mcp.iguanatweaksreborn.data.generator.ISOItemTagsProvider;
import insane96mcp.iguanatweaksreborn.module.world.spawners.SpawnerStatusSync;
import insane96mcp.iguanatweaksreborn.module.world.spawners.capability.ISpawnerData;
import insane96mcp.iguanatweaksreborn.module.world.spawners.capability.SpawnerData;
import insane96mcp.iguanatweaksreborn.module.world.spawners.capability.SpawnerDataImpl;
import insane96mcp.iguanatweaksreborn.network.NetworkHandler;
import insane96mcp.iguanatweaksreborn.utils.ISOLogHelper;
import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.JsonFeature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.MinMax;
import insane96mcp.insanelib.data.IdTagValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.NetworkDirection;

@LoadFeature(module="iguanatweaksreborn:world", description="Spawners are now a challenge. Monsters spawning from spawners ignore light.")
public class Spawners
extends JsonFeature {
    public static final TagKey<EntityType<?>> BLACKLISTED_SPAWNERS = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)InsaneSO.location("blacklisted_spawners"));
    public static final TagKey<Item> SPAWNER_REACTIVATOR_TAG = ISOItemTagsProvider.create("spawner_reactivator");
    public static final String SPAWNER_REACTIVATOR_LANG = InsaneSO.lang("spawner_reactivator");
    @Config(min=1.0, description="If true, the spawner delay is set to 'Delay' instead of using MinSpawnDelay and MaxSpawnDelay")
    public static Boolean overrideSpawnDelay = true;
    @Config(min=1.0, description="Spawning Delay (in ticks) of the spawner. Vanilla is 200~800. Requires 'Override Spawn Delay' to be enabled.")
    public static MinMax delay = new MinMax(400.0, 1600.0);
    @Config(min=0.0, description="Range in which a player must be present for a spawner to work. Vanilla is 16.")
    public static int requiredPlayerRange = 24;
    @Config(description="If true, monsters from spawners will spawn no matter the light level.")
    public static Boolean ignoreLight = true;
    @Config(name="Re-enable with Spawner Reactivator", description="If true, disabled spawners can be re-enabled with a spawner reactivator item defined in the `iguanatweaksreborn:spawner_reactivator` item tag. These items get a new tooltip mentioning that they can be used to re-enable spawners.")
    public static Boolean reEnableWithSpawnerReactivator = true;
    @Config(description="If enabled, spawner will play a sound effect when spawning mobs")
    public static Boolean spawningSoundEffect = true;
    @Config(description="If true, spawners will be disabled after spawning a certain amount of mobs. This is not compatible with empowered spawners.")
    public static Boolean disableSpawners$enabled = false;
    @Config(min=0.0, description="The minimum amount of spawnable mobs (when the spawner is basically in the same position as the world spawn). The amount of spawnable mobs before deactivating is equal to the distance divided by 8 (plus this value). E.g. At 160 blocks from spawn the max spawnable mobs will be 160 / 8 + 20 = 20 + 20 = 40")
    public static Integer disableSpawners$minSpawnableMobs = 20;
    @Config(min=0.0, description="This multiplier increases the max mobs spawned.")
    public static Double disableSpawners$spawnableMobsMultiplier = 1.0;
    @Config(description="If true, spawners will generate in an empowered state. When empowered, will generate mobs really fast for a while and then will disable. This is not compatible with disable spawners.")
    public static Boolean empowered$enabled = true;
    @Config(min=0.0, description="When the spawner stops being empowered, it is disabled and will stop spawning mobs.")
    public static Boolean empowered$disableOnEnd = true;
    @Config(min=0.0, name="Empowered.Mobs amount", description="How many mobs are spawned before empowered ends.")
    public static Integer empoweredMobsAmount = 20;
    @Config(min=1.0, name="Empowered.Delay", description="Spawning Delay (in ticks) when the Spawner is empowered.")
    public static MinMax empoweredDelay = new MinMax(150.0, 300.0);
    @Config(min=0.0, name="Empowered.Experience Reward", description="When the Spawner stops being empowered, will generate this amount of experience")
    public static MinMax empoweredExperienceReward = new MinMax(150.0, 200.0);
    @Config(name="Empowered.Loot Reward", description="When the Spawner stops being empowered, will generate loot from the iguanatweaksreborn:empowered_spawner loot table")
    public static Boolean empoweredLootReward = true;
    @Config(name="Empowered.Sound effect", description="When the Spawner stops being empowered, will play a sound effect")
    public static Boolean empoweredSoundEffect = true;
    @Config(min=-1.0, description="The range of a player nearby in which the spawner will be active. Setting to -1 should keep the spawners always active (untested) as long as the chunk is loaded (hostiles will still despawn in a 128 block radius).")
    public static Integer reactivatedSpawners$playerRange = 128;
    @Config(description="How many ticks will the spawner try to summon mobs.")
    public static MinMax reactivatedSpawners$delay = new MinMax(3600.0, 6000.0);
    @Config(description="Reactivated spawners spawn mobs no matter the light level.")
    public static Boolean reactivatedSpawners$ignoreLight = false;
    public static final ArrayList<IdTagValue> FIXED_SPAWNER_SPAWNABLE_DEFAULT = new ArrayList(List.of());
    public static final ArrayList<IdTagValue> fixedSpawnerSpawnable = new ArrayList();

    public Spawners(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
        this.JSON_CONFIGS.add(new JsonFeature.JsonConfig("fixed_spawners_spawnable.json", fixedSpawnerSpawnable, FIXED_SPAWNER_SPAWNABLE_DEFAULT, IdTagValue.LIST_TYPE));
    }

    public String getModConfigFolder() {
        return "config/insanesurvivaloverhaul";
    }

    @SubscribeEvent
    public void onSpawnerSpawn(MobSpawnEvent.FinalizeSpawn event) {
        if (!this.isEnabled() || !event.getSpawnType().equals((Object)MobSpawnType.SPAWNER) || event.getSpawner() == null || event.getSpawner().getSpawnerBlockEntity() == null) {
            return;
        }
        BlockPos spawnerPos = event.getSpawner().getSpawnerBlockEntity().m_58899_();
        ServerLevel level = (ServerLevel)event.getLevel();
        BlockEntity blockEntity = event.getSpawner().getSpawnerBlockEntity();
        if (!(blockEntity instanceof SpawnerBlockEntity)) {
            ISOLogHelper.warn("SpawnerBlockEntity is null at %s. Some mod is giving a spawner a non SpawnerBlockEntity.".formatted(spawnerPos), new Object[0]);
            return;
        }
        SpawnerBlockEntity mobSpawner = (SpawnerBlockEntity)blockEntity;
        if (spawningSoundEffect.booleanValue()) {
            level.m_5594_(null, spawnerPos, SoundEvents.f_11874_, SoundSource.BLOCKS, 2.0f, 1.5f);
        }
        mobSpawner.getCapability(SpawnerData.INSTANCE).ifPresent(spawnerCap -> {
            spawnerCap.addSpawnedMobs(1);
            this.disabledSpawners(mobSpawner, event.getEntity(), level, spawnerPos, (ISpawnerData)spawnerCap);
            Spawners.empoweredSpawner(mobSpawner, event.getEntity(), level, spawnerPos, spawnerCap);
        });
    }

    private void disabledSpawners(SpawnerBlockEntity spawnerBlockEntity, Mob mob, ServerLevel level, BlockPos spawnerPos, ISpawnerData spawnerCap) {
        if (!disableSpawners$enabled.booleanValue() || mob.m_6095_().m_204039_(BLACKLISTED_SPAWNERS)) {
            return;
        }
        int maxSpawned = 0;
        for (IdTagValue idTagValue : fixedSpawnerSpawnable) {
            if (!idTagValue.id.matchesEntity((Entity)mob, level.m_46472_().m_135782_())) continue;
            maxSpawned = (int)idTagValue.value;
            break;
        }
        if (maxSpawned <= 0) {
            double distance = Math.sqrt(spawnerPos.m_123331_((Vec3i)level.m_220360_()));
            maxSpawned = (int)(((double)disableSpawners$minSpawnableMobs.intValue() + distance / 8.0) * disableSpawners$spawnableMobsMultiplier);
        }
        if (spawnerCap.getSpawnedMobs() >= maxSpawned) {
            Spawners.setSpawnerDisabled(spawnerBlockEntity, true);
        }
        spawnerBlockEntity.m_6596_();
    }

    private static void empoweredSpawner(SpawnerBlockEntity spawnerBlockEntity, Mob mob, ServerLevel level, BlockPos spawnerPos, ISpawnerData spawnerCap) {
        if (!empowered$enabled.booleanValue() || mob.m_6095_().m_204039_(BLACKLISTED_SPAWNERS) || !spawnerCap.isEmpowered()) {
            return;
        }
        if (spawnerCap.getSpawnedMobs() >= empoweredMobsAmount) {
            Spawners.setSpawnerEmpowered(spawnerBlockEntity, false);
            int amount = empoweredExperienceReward.getIntRandBetween(level.f_46441_);
            ExperienceOrb.m_147082_((ServerLevel)level, (Vec3)new Vec3((double)spawnerPos.m_123341_() + 0.5, (double)spawnerPos.m_123342_() + 1.1, (double)spawnerPos.m_123343_() + 0.5), (int)amount);
            if (empoweredLootReward.booleanValue()) {
                LootParams.Builder lootParamsBuilder = new LootParams.Builder(level).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)spawnerPos)).m_287286_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_287289_(LootContextParams.f_81461_, (Object)level.m_8055_(spawnerPos)).m_287289_(LootContextParams.f_81462_, (Object)spawnerBlockEntity);
                LootParams lootParams = lootParamsBuilder.m_287235_(LootContextParamSets.f_81410_);
                LootTable loottable = level.m_7654_().m_278653_().m_278676_(InsaneSO.location("empowered_spawner"));
                loottable.m_287195_(lootParams).forEach(stack -> level.m_7967_((Entity)new ItemEntity((Level)level, (double)((float)spawnerPos.m_123341_() + 0.5f), (double)((float)spawnerPos.m_123342_() + 1.1f), (double)((float)spawnerPos.m_123343_() + 0.5f), stack)));
            }
            if (empowered$disableOnEnd.booleanValue()) {
                Spawners.setSpawnerDisabled(spawnerBlockEntity, true);
            }
            if (empoweredSoundEffect.booleanValue()) {
                level.m_5594_(null, spawnerPos, SoundEvents.f_12275_, SoundSource.BLOCKS, 3.0f, 1.5f);
            }
        }
    }

    @SubscribeEvent
    public void onItemUse(PlayerInteractEvent.RightClickBlock event) {
        if (!reEnableWithSpawnerReactivator.booleanValue() || !event.getItemStack().m_204117_(SPAWNER_REACTIVATOR_TAG) || event.getLevel().m_8055_(event.getHitVec().m_82425_()).m_60734_() != Blocks.f_50085_) {
            return;
        }
        SpawnerBlockEntity spawner = (SpawnerBlockEntity)event.getLevel().m_7702_(event.getHitVec().m_82425_());
        if (spawner == null || !Spawners.isDisabled(spawner)) {
            return;
        }
        event.setUseItem(Event.Result.ALLOW);
        if (!event.getEntity().m_150110_().f_35937_) {
            event.getItemStack().m_41774_(1);
        }
        event.getEntity().m_21011_(event.getHand(), true);
        Spawners.setSpawnerDisabled(spawner, false);
        spawner.getCapability(SpawnerData.INSTANCE).ifPresent(spawnerCap -> {
            spawnerCap.setSpawnedMobs(0);
            spawnerCap.setHasBeenReactivated(true);
        });
        spawner.m_6596_();
    }

    @SubscribeEvent
    public void onSpawnCheck(MobSpawnEvent.SpawnPlacementCheck event) {
        if (!this.isEnabled() || event.getSpawnType() != MobSpawnType.SPAWNER || event.getEntityType().m_204039_(BLACKLISTED_SPAWNERS) || event.getDefaultResult()) {
            return;
        }
        if (Monster.m_219019_((EntityType)event.getEntityType(), (LevelAccessor)event.getLevel(), (MobSpawnType)event.getSpawnType(), (BlockPos)event.getPos(), (RandomSource)event.getRandom())) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public void onSpawnCheck(MobSpawnEvent.PositionCheck event) {
        BlockEntity blockEntity;
        if (!this.isEnabled() || event.getSpawnType() != MobSpawnType.SPAWNER || event.getEntity().m_6095_().m_204039_(BLACKLISTED_SPAWNERS) || event.getSpawner() == null || !((blockEntity = event.getSpawner().getSpawnerBlockEntity()) instanceof SpawnerBlockEntity)) {
            return;
        }
        SpawnerBlockEntity spawnerBlockEntity = (SpawnerBlockEntity)blockEntity;
        if (Spawners.hasBeenReactivated(spawnerBlockEntity)) {
            if (reactivatedSpawners$ignoreLight.booleanValue()) {
                event.setResult(Event.Result.ALLOW);
            }
        } else if (ignoreLight.booleanValue() && event.getEntity().m_6914_((LevelReader)event.getLevel())) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    public static boolean onSpawnerServerTick(BaseSpawner spawner) {
        SpawnerBlockEntity spawnerBlockEntity;
        block3: {
            block2: {
                BlockEntity blockEntity = spawner.getSpawnerBlockEntity();
                if (!(blockEntity instanceof SpawnerBlockEntity)) break block2;
                spawnerBlockEntity = (SpawnerBlockEntity)blockEntity;
                if (Feature.isEnabled(Spawners.class)) break block3;
            }
            return false;
        }
        return Spawners.isDisabled(spawnerBlockEntity);
    }

    public static boolean onSpawnerClientTick(BaseSpawner spawner, Level level) {
        SpawnerBlockEntity spawnerBlockEntity;
        block5: {
            block4: {
                BlockEntity blockEntity;
                if (!Feature.isEnabled(Spawners.class) || !((blockEntity = spawner.getSpawnerBlockEntity()) instanceof SpawnerBlockEntity)) break block4;
                spawnerBlockEntity = (SpawnerBlockEntity)blockEntity;
                if (spawner.f_45444_ != null) break block5;
            }
            return false;
        }
        Optional optional = EntityType.m_20637_((CompoundTag)spawner.f_45444_.f_186561_());
        if (optional.isEmpty()) {
            return false;
        }
        Spawners.clientTickOnEmpowered(spawner, level, spawnerBlockEntity);
        Spawners.clientTickOnDisabled(spawner, level, spawnerBlockEntity);
        return Spawners.isDisabled(spawnerBlockEntity);
    }

    public static void onSpawnerDelaySet(BaseSpawner spawner, Level level, BlockPos pos) {
        BlockEntity blockEntity;
        if (!Feature.isEnabled(Spawners.class) || !((blockEntity = spawner.getSpawnerBlockEntity()) instanceof SpawnerBlockEntity)) {
            return;
        }
        SpawnerBlockEntity spawnerBlockEntity = (SpawnerBlockEntity)blockEntity;
        int playerRange = requiredPlayerRange;
        if (Spawners.isEmpowered(spawnerBlockEntity)) {
            spawner.f_45442_ = empoweredDelay.getIntRandBetween(level.m_213780_());
        } else if (Spawners.hasBeenReactivated(spawnerBlockEntity)) {
            spawner.f_45442_ = reactivatedSpawners$delay.getIntRandBetween(level.m_213780_());
            playerRange = reactivatedSpawners$playerRange;
        } else if (overrideSpawnDelay.booleanValue()) {
            spawner.f_45442_ = delay.getIntRandBetween(level.m_213780_());
        }
        spawner.f_45452_ = playerRange;
        Spawners.syncSpawnerData(spawnerBlockEntity);
    }

    private static void clientTickOnEmpowered(BaseSpawner spawner, Level level, SpawnerBlockEntity spawnerBlockEntity) {
        if (!Spawners.isEmpowered(spawnerBlockEntity)) {
            return;
        }
        BlockPos blockpos = spawnerBlockEntity.m_58899_();
        for (int i = 0; i < 5; ++i) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, (double)blockpos.m_123341_() + level.f_46441_.m_188500_(), (double)blockpos.m_123342_() + level.f_46441_.m_188500_(), (double)blockpos.m_123343_() + level.f_46441_.m_188500_(), 0.0, 0.0, 0.0);
        }
        if (spawner.f_45442_ > 0 && spawner.f_45442_ % 10 == 0) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123792_, (double)blockpos.m_123341_() + level.f_46441_.m_188500_(), (double)blockpos.m_123342_() + level.f_46441_.m_188500_() + (double)0.2f, (double)blockpos.m_123343_() + level.f_46441_.m_188500_(), 0.0, 0.0, 0.0);
        }
    }

    private static void clientTickOnDisabled(BaseSpawner spawner, Level level, SpawnerBlockEntity spawnerBlockEntity) {
        if (!Spawners.isDisabled(spawnerBlockEntity)) {
            return;
        }
        BlockPos blockpos = spawnerBlockEntity.m_58899_();
        for (int i = 0; i < 8; ++i) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)blockpos.m_123341_() + level.f_46441_.m_188500_(), (double)blockpos.m_123342_() + level.f_46441_.m_188500_(), (double)blockpos.m_123343_() + level.f_46441_.m_188500_(), 0.0, 0.0, 0.0);
        }
    }

    private static void setSpawnerEmpowered(SpawnerBlockEntity spawner, boolean empowered) {
        spawner.getCapability(SpawnerData.INSTANCE).ifPresent(spawnerCap -> spawnerCap.setEmpowered(empowered));
        spawner.m_6596_();
        Spawners.syncSpawnerData(spawner);
    }

    private static void setSpawnerDisabled(SpawnerBlockEntity spawner, boolean disabled) {
        spawner.getCapability(SpawnerData.INSTANCE).ifPresent(spawnerCap -> spawnerCap.setDisabled(disabled));
        spawner.m_6596_();
        Spawners.syncSpawnerData(spawner);
    }

    private static void syncSpawnerData(SpawnerBlockEntity spawner) {
        if (!spawner.m_58898_() || spawner.m_58904_().f_46443_) {
            return;
        }
        LazyOptional spawnerDataLazy = spawner.getCapability(SpawnerData.INSTANCE);
        spawnerDataLazy.ifPresent(spawnerData -> {
            SpawnerStatusSync msg = new SpawnerStatusSync(spawner.m_58899_(), (SpawnerDataImpl)spawnerData, spawner.m_59801_().f_45442_, spawner.m_59801_().f_45452_);
            for (Player player : spawner.m_58904_().m_6907_()) {
                NetworkHandler.CHANNEL.sendTo((Object)msg, ((ServerPlayer)player).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            }
        });
    }

    private static boolean isDisabled(SpawnerBlockEntity spawner) {
        LazyOptional cap = spawner.getCapability(SpawnerData.INSTANCE);
        return cap.map(ISpawnerData::isDisabled).orElse(false);
    }

    private static boolean isEmpowered(SpawnerBlockEntity spawner) {
        if (!empowered$enabled.booleanValue()) {
            return false;
        }
        LazyOptional cap = spawner.getCapability(SpawnerData.INSTANCE);
        return cap.map(ISpawnerData::isEmpowered).orElse(false);
    }

    private static boolean hasBeenReactivated(SpawnerBlockEntity spawner) {
        LazyOptional cap = spawner.getCapability(SpawnerData.INSTANCE);
        return cap.map(ISpawnerData::hasBeenReactivated).orElse(false);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onTooltip(ItemTooltipEvent event) {
        if (!(this.isEnabled() && reEnableWithSpawnerReactivator.booleanValue() && event.getItemStack().m_204117_(SPAWNER_REACTIVATOR_TAG))) {
            return;
        }
        event.getToolTip().add(Component.m_237115_((String)SPAWNER_REACTIVATOR_LANG).m_130940_(ChatFormatting.LIGHT_PURPLE));
    }
}

