/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.iguanatweaksreborn.module.world.timber;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.reflect.TypeToken;
import insane96mcp.insanelib.data.IdTagMatcher;
import java.lang.reflect.Type;
import java.util.ArrayList;
import net.minecraft.util.GsonHelper;

@JsonAdapter(value=Serializer.class)
public class TreeInfo {
    public IdTagMatcher log;
    public IdTagMatcher leaves;
    public float logsSidewaysRatio;
    public int minLogs;
    public int maxDistanceFromLogs;
    public float decayPercentage;
    public static final Type LIST_TYPE = new TypeToken<ArrayList<TreeInfo>>(){}.getType();

    public TreeInfo(IdTagMatcher log, IdTagMatcher leaves, float logsSidewaysRatio, int minLogs, int maxDistanceFromLogs, float decayPercentage) {
        this.log = log;
        this.leaves = leaves;
        this.logsSidewaysRatio = logsSidewaysRatio;
        this.minLogs = minLogs;
        this.maxDistanceFromLogs = maxDistanceFromLogs;
        this.decayPercentage = decayPercentage;
    }

    public TreeInfo() {
        this.logsSidewaysRatio = 0.6f;
        this.minLogs = 3;
        this.maxDistanceFromLogs = 8;
        this.decayPercentage = 0.1f;
    }

    public static class Serializer
    implements JsonDeserializer<TreeInfo>,
    JsonSerializer<TreeInfo> {
        public TreeInfo deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jObject = json.getAsJsonObject();
            IdTagMatcher log = (IdTagMatcher)context.deserialize(jObject.get("log"), IdTagMatcher.class);
            IdTagMatcher leaves = (IdTagMatcher)context.deserialize(jObject.get("leaves"), IdTagMatcher.class);
            float logsSidewaysRatio = GsonHelper.m_13820_((JsonObject)jObject, (String)"logs_sideways_ratio", (float)0.6f);
            int minLogs = GsonHelper.m_13824_((JsonObject)jObject, (String)"min_logs", (int)3);
            int maxDistanceFromLogs = GsonHelper.m_13824_((JsonObject)jObject, (String)"max_distance_from_logs", (int)8);
            float decayPercentage = GsonHelper.m_13820_((JsonObject)jObject, (String)"decay_percentage", (float)0.1f);
            return new TreeInfo(log, leaves, logsSidewaysRatio, minLogs, maxDistanceFromLogs, decayPercentage);
        }

        public JsonElement serialize(TreeInfo src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.add("log", context.serialize((Object)src.log));
            jsonObject.add("leaves", context.serialize((Object)src.leaves));
            if (src.logsSidewaysRatio != 0.6f) {
                jsonObject.addProperty("logs_sideways_ratio", (Number)Float.valueOf(src.logsSidewaysRatio));
            }
            if (src.minLogs != 3) {
                jsonObject.addProperty("min_logs", (Number)src.minLogs);
            }
            if (src.maxDistanceFromLogs != 8) {
                jsonObject.addProperty("max_distance_from_logs", (Number)src.maxDistanceFromLogs);
            }
            if (src.decayPercentage != 0.1f) {
                jsonObject.addProperty("decay_percentage", (Number)Float.valueOf(src.decayPercentage));
            }
            return jsonObject;
        }
    }

    public static class Builder {
        private final TreeInfo treeInfo = new TreeInfo();

        public Builder log(IdTagMatcher log) {
            this.treeInfo.log = log;
            return this;
        }

        public Builder leaves(IdTagMatcher leaves) {
            this.treeInfo.leaves = leaves;
            return this;
        }

        public Builder logsSidewaysRatio(float logsSidewaysRatio) {
            this.treeInfo.logsSidewaysRatio = logsSidewaysRatio;
            return this;
        }

        public Builder minLogs(int minLogs) {
            this.treeInfo.minLogs = minLogs;
            return this;
        }

        public Builder maxDistanceFromLogs(int maxDistanceFromLogs) {
            this.treeInfo.maxDistanceFromLogs = maxDistanceFromLogs;
            return this;
        }

        public Builder decayPercentage(float decayPercentage) {
            this.treeInfo.decayPercentage = decayPercentage;
            return this;
        }

        public TreeInfo build() {
            return this.treeInfo;
        }
    }
}

